/* -*- mode: c++; coding: sjis-dos; -*-
 * Time-stamp: <2003-06-08 17:35:02 tfuruka1>
 * Copyright (C) 2003 Tadamegu Furukawa
 *
 * jbanner - {܂ޕg債Aoi[Ƃĉʂɕ\܂B
 *
 * $Id: main.c,v 1.1 2004/01/19 09:01:28 tfuruka1 Exp $
 * $Log: main.c,v $
 * Revision 1.1  2004/01/19 09:01:28  tfuruka1
 * rWǗRCSCVS֕ύX܂B
 *
 * Revision 1.4  2003/06/08 11:20:38  tfuruka1
 *  tHg̗񋓂sIvVǉB
 *  \̃`FbNɌ肪̂ŏCB
 *
 * Revision 1.3  2003/06/05 13:48:57  tfuruka1
 *  -c IvVŁuvwł悤ɏCB
 *
 * Revision 1.2  2003/06/01 11:17:32  tfuruka1
 * R}hC͂̃fobOpSyslogo͂ǉ܂B
 *
 * Revision 1.1  2003/06/01 08:19:58  tfuruka1
 * Initial revision
 */
#include "jbanner.h"

/*
 * CygwingccŁA{ʂׂɁAȉ̓̕R[hŖߍł
 * B
 *
 * \=\x95\x5c
 * \=\x8f\x5c
 * \=\x83\x5c
 */
#define USAGE_STR "Usage: %s "\
"[-c X] [-w 80] [--usage] [--version] [--help] \x95\x5c镶\n"

#define HELP_STR "Usage: %s \x95\x5c镶\n\n"\
"S̓IȃIvV\n"\
"  -c, --char=%s       gp镶 <%s>\n"\
"  -w, --width=%d     \x95\x5cݒ肵܂B<%d>\n\n"\
"wvIvV\n"\
"  -?, --help         ̃wvbZ[W\x95\x5c܂B\n"\
"  --usage            ȌȎgp@\x95\x5c܂B\n"\
"  --version          @[W\x95\x5c܂B\n\n"\
"IvV(WIN32)\n"\
"  -F, --fontname=\"%s\"\n"\
"                     gptHgw肵܂B<%s>\n"\
"  -f, --fontsize=%d  tHgTCYw肵܂B<%d>\n"\
"  --lsfont[=family]  familyŎw肵tHgt@~̃tHg"\
"񋓂܂B\n"\
"\ño[WCygwinbannerƓ悤ɓ삷悤ɍ쐬Ă\n"\
"łA\x83\x5c[X͈؎QƂĂ܂̂ŁAi͑SقȂ"\
"Ă\n"\
"ł傤B]āAׂڂ̓ɂĂAقȂ镔Ǝv\n"\
"܂B\n"\
"\nReport bugs to <tfuruka1@nifty.com>.\n"

/*
 * @[W\
 */
static void
ShowVersion()
{
  fprintf(stderr, "%s\n", VERSION);
}

/*
 * ȌȎgp@\
 */
static void ShowUsage(char *lpszCom)
{
    fprintf(stderr, USAGE_STR, GetLongBaseName(lpszCom));
}

/*
 * gp@\
 */
static void ShowHelp(char *lpszCom)
{
    ShowVersion();
    fprintf(stderr, HELP_STR, GetLongBaseName(lpszCom),
            DEFAULT_CHAR, DEFAULT_CHAR, DEFAULT_WIDTH, DEFAULT_WIDTH,
            DEFAULT_FONT, DEFAULT_FONT, DEFAULT_FSIZE, DEFAULT_FSIZE);
}

/*
 * s\ȏꍇ̂[bZ[W\AȌȎgp@\
 */
static void NotEnoughArguments(char *lpszCom)
{
    fprintf(stderr, "%s: s\x8f\x5cłB\n",
            GetLongBaseName(lpszCom));
    ShowUsage(lpszCom);
}

/*
 * {R}h̃Gg
 */ 
// `FbNp̃}NFargv[i]ƌߑłĂ̂ŗv
// ӁIIIsȂ̂̂ŁEEE
#define IS_ARG_OK1(Expected) (0 == strcmp(Expected, argv[i]))
#define IS_ARG_OK2(Exp1, Exp2) IS_ARG_OK1(Exp1) || IS_ARG_OK1(Exp2)
int main(int argc, char *argv[])
{
    int i;
    int nScreenWidth = DEFAULT_WIDTH;
    int nFontSize = DEFAULT_FSIZE;
    BOOL bDebug = FALSE;
    LPTSTR lpszUseChar = DEFAULT_CHAR;
    LPTSTR lpszFontName = DEFAULT_FONT;
    BYTE *pNextArg;


    // R}hIvṼfobOpł
    {
        Syslogger(FALSE, ">>>>>"
#if defined(CYGWIN)
                  "CYGWIN-VERSION"
#else
                  "MSVC-VERSION"
#endif
                  ": START");
        for (i = 0; i < argc; i++) {
            Syslogger(FALSE, "ARGV[%d]=<%s>", i, argv[i]);
        }
        Syslogger(FALSE, "<<<<<");
    }
    // R}hIvṼfobOp͂܂

    for (i = 1; i < argc; i++) {
        if ('-' != *argv[i]) {
            break;
        }

        // IvV=gpĂꍇ̏
        pNextArg = strchr(argv[i], '=');
        if (pNextArg) {
            if (!*(pNextArg)) {
                fprintf(stderr, "%s: IvV̒l݂܂B(%s)\n",
                        GetLongBaseName(argv[0]), argv[i]);
                return 1;
            }
            *pNextArg = '\0';
            pNextArg++;
        }

        // ̃`FbN
        if (IS_ARG_OK2("-?", "--help")) {
            ShowHelp(argv[0]);
            return 0;
        }
        else if (IS_ARG_OK1("--usage")) {
            ShowUsage(argv[0]);
            return 0;
        }
        else if (IS_ARG_OK1("--version")) {
            ShowVersion();
            return 0;
        }
        else if (IS_ARG_OK1("--lsfont")) {
            if (!pNextArg) {
                // ɂꂪŌ̈ƂĂÃ|C^
                // NULLȂ̂ŁALsFonẗƂĂ͒낪B
                pNextArg = argv[i + 1];
            }
            LsFont(pNextArg);
            return 0;
        }
        else if (IS_ARG_OK2("-c", "--char")) {
            if (!pNextArg) {
                if (NULL == argv[i + 1]) {
                    NotEnoughArguments(argv[0]);
                    return 1;
                }
                i++;
                pNextArg = argv[i];
            }
            lpszUseChar = pNextArg;
        }
        else if (IS_ARG_OK2("-w", "--width")) {
            if (!pNextArg) {
                if (NULL == argv[i + 1]) {
                    NotEnoughArguments(argv[0]);
                    return 1;
                }
                i++;
                pNextArg = argv[i];
            }
            nScreenWidth = (int)strtol(pNextArg, NULL, 10);
            if (0 >= nScreenWidth) {
                fprintf(stderr, "%s: \x95\x5c܂B<%d>\n",
                        GetLongBaseName(argv[0]), nScreenWidth);
                return 1;
            }
            if (MAX_WIDTH <= nScreenWidth) {
                fprintf(stderr, "%s: \x95\x5c傫܂B<%d>\n",
                        GetLongBaseName(argv[0]), nScreenWidth);
                return 1;
            }
        }
        else if (IS_ARG_OK2("-F", "--fontname")) {
            if (!pNextArg) {
                if (NULL == argv[i + 1]) {
                    NotEnoughArguments(argv[0]);
                    return 1;
                }
                i++;
                pNextArg = argv[i];
            }
            lpszFontName = pNextArg;
        }
        else if (IS_ARG_OK2("-f", "--fontsize")) {
            if (!pNextArg) {
                if (NULL == argv[i + 1]) {
                    NotEnoughArguments(argv[0]);
                    return 1;
                }
                i++;
                pNextArg = argv[i];
            }
            nFontSize = (int)strtol(pNextArg, NULL, 10);
            if (0 >= nFontSize) {
                fprintf(stderr, "%s: tHgTCY܂B<%d>\n",
                        GetLongBaseName(argv[0]), nFontSize);
                return 1;
            }
        }
        else if (IS_ARG_OK1("-d")) {
            // fobO[hɂ
            bDebug = TRUE;
        }
        else {
            fprintf(stderr, "%s: ȃIvVł(%s)\n",
                    GetLongBaseName(argv[0]), argv[i]);
            return 1;
        }
    }

    if (i >= argc) {
        NotEnoughArguments(argv[0]);
        return 1;
    }

    // gp񒷂ɍ킹ăTCY𒲐
    nScreenWidth /= strlen(lpszUseChar);

    if (strlen(lpszUseChar) >= (ULONG)nScreenWidth) {
            fprintf(stderr, "%s: \x95\x5cA"
                    "gp񒷂\x95\x5cł܂\n",
                    GetLongBaseName(argv[0]));
        return 1;
    }

    Syslogger(FALSE, "DBG: gp=%s, \x95\x5c=%d, "
              "tHg=%s, tHgTCY=%d",
              lpszUseChar, nScreenWidth, lpszFontName, nFontSize);

    // gptHg̏
    if (!SetLogFont(lpszFontName)) {
        fprintf(stderr, "%s: tHgt@~Ił܂łB\n",
                GetLongBaseName(argv[0]));
        return 1;
    }

    for (; i < argc; i++) {
        DrawBanner(lpszUseChar, nScreenWidth, nFontSize, argv[i], bDebug);
    }
    return 0;
}
