﻿namespace UVTexIntegra.CustomControls
{
    //! @brief ログファイルを出力するためのクラス
    public static class TextLogFile
    {
        //! @brief ログファイルのパス
        public static readonly System.String LogFilePath;

        //! @brief ログ出力時にメッセージを出すか設定します。
        public static bool MessageOnLog { get; set; }
        
        //! @brief 静的コンストラクタ
        static TextLogFile()
        {
            System.Reflection.Assembly assembly = System.Reflection.Assembly.GetAssembly(typeof(TextLogFile));
            if (assembly == null) assembly = System.Reflection.Assembly.GetCallingAssembly();
            if (assembly == null) assembly = System.Reflection.Assembly.GetExecutingAssembly();
            if (assembly == null) assembly = System.Reflection.Assembly.GetEntryAssembly();
            if (assembly == null)
            {
                System.Windows.Forms.MessageBox.Show("Warning : assembly is not found @ TextLogFile static initialize");
                return;
            }
            MessageOnLog = false;
            DotNetEx.IO.Path path = assembly.Location;
            path = path.Parent;
            path.Combine("Log.txt");
            LogFilePath = path.ToSystemFilePath();
        }

        //! @brief ログファイルに例外を書き足す。
        public static void AppendException(System.Exception ex)
        {
            System.String str = null;
            if (ex != null) str = DotNetEx.String.Extention.ToNestedMultilineString(ex);
            AppendException(ex);
        }

        //! @brief ログファイルに例外を書き足す。
        public static void AppendException(System.Object ex_obj)
        {
            System.String str = null;
            System.Exception ex = ex_obj as System.Exception;
            if (ex != null) str = DotNetEx.String.Extention.ToNestedMultilineString(ex);
            else if (ex_obj != null) str = ex_obj.ToString();
            AppendException(str);
        }

        //! @brief ログファイルに１行書き足す。
        public static void AppendLine()
        {
            using (System.IO.StreamWriter writer = new System.IO.StreamWriter(LogFilePath, true, System.Text.Encoding.UTF8))
            {
                writer.WriteLine("Log : " + System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss:fff"));
            }
        }

        //! @brief ログファイルに１行書き足す。
        public static void AppendLine(System.String str)
        {
            using (System.IO.StreamWriter writer = new System.IO.StreamWriter(LogFilePath, true, System.Text.Encoding.UTF8))
            {
                writer.WriteLine("Log : " + System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss:fff ") + str);
            }
            if (MessageOnLog) System.Windows.Forms.MessageBox.Show(LogFilePath + System.Environment.NewLine + str, "append log file");
        }

        //! @brief ログファイルに複数行を書き足す。
        public static void AppendMultiLine(System.String str)
        {
            using (System.IO.StreamWriter writer = new System.IO.StreamWriter(LogFilePath, true, System.Text.Encoding.UTF8))
            {
                writer.WriteLine("Log : " + System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss:fff"));
                writer.WriteLine(str);
            }
            if (MessageOnLog) System.Windows.Forms.MessageBox.Show(LogFilePath + System.Environment.NewLine + str, "append log file");
        }

        //! @brief ログファイルに複数行を書き足す。
        public static void AppendMultiLine(System.Collections.Generic.IEnumerable<System.String> lines)
        {
            using (System.IO.StreamWriter writer = new System.IO.StreamWriter(LogFilePath, true, System.Text.Encoding.UTF8))
            {
                writer.WriteLine("Log : " + System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss:fff"));
                foreach (System.String str in lines) writer.WriteLine(str);
            }
            if (MessageOnLog)
            {
                System.Windows.Forms.MessageBox.Show(
                    LogFilePath + System.Environment.NewLine + System.String.Join(System.Environment.NewLine, lines),
                    "append log file");
            }
        }

        //! @brief ログファイルに例外を書き足す
        private static void AppendException(System.String ex)
        {
            if (ex != null)
            {
                using (System.IO.StreamWriter writer = new System.IO.StreamWriter(LogFilePath, true, System.Text.Encoding.UTF8))
                {
                    writer.WriteLine("Exception : " + System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss:fff"));
                    writer.WriteLine(ex);
                }
                System.Windows.Forms.MessageBox.Show(LogFilePath, "Exception is recorded!!");
            }
            else System.Windows.Forms.MessageBox.Show(LogFilePath, "Exception!! (null)");
        }
    }
}
