﻿// == LICENSE INFORMATION ==
/*
 * First author tiritomato 2013.
 * This program is distributed under the GNU General Public License(GPL).
 * support blog (Japanese only) http://d.hatena.ne.jp/tiri_tomato/
 */
// == LICENSE INFORMATION ==

namespace UVTexIntegra.Scripting
{
    //! @addtogroup UVTexIntegra-Scripting名前空間
    //! @{
    
    public partial class CompiledAssembly
    {
        [System.Serializable]
        public new class SerializeInformation : LoadedAssembly.SerializeInformation
        {
            // public field //
            public static readonly System.String ReferencedAssembliesDefault;
            public bool AutoCompileOnOpenDialog;
			public System.String ReferencedAssemblies;
			//! @brief 静的コンストラクタ
            static SerializeInformation()
            {
                ReferencedAssembliesDefault = typeof(CompiledAssembly).GetProperty("ReferencedAssemblies").GetPrimaryAttribute<System.ComponentModel.DefaultValueAttribute>().Value.ToString();
            }
            //! @brief デフォルトコンストラクタ
            public SerializeInformation()
                : base()
            {
                AutoCompileOnOpenDialog = false;
                ReferencedAssemblies = ReferencedAssembliesDefault;
            }
            //! @brief コンストラクタ。パスを指定して新規生成用のデータを作成します。
            public SerializeInformation(System.String path)
                : base(path)
            {
                AutoCompileOnOpenDialog = false;
                ReferencedAssemblies = ReferencedAssembliesDefault;
            }
            //! @brief コンストラクタ。CompiledAssemblyからシリアライズデータを生成します。
            public SerializeInformation(CompiledAssembly src)
                : base(src)
            {
                AutoCompileOnOpenDialog = false;
                ReferencedAssemblies = ReferencedAssembliesDefault;
                if (src != null)
                {
                    AutoCompileOnOpenDialog = src.AutoCompileOnOpenDialog;
                    ReferencedAssemblies = src.ReferencedAssemblies;
                }
            }
            public override LoadedAssembly Load() { return CompiledAssembly.From(this); }
        }
    }

    //! @}
}
