﻿// == LICENSE INFORMATION ==
/*
 * First author tiritomato 2013.
 * This program is distributed under the GNU General Public License(GPL).
 * support blog (Japanese only) http://d.hatena.ne.jp/tiri_tomato/
 */
// == LICENSE INFORMATION ==

namespace UVTexIntegra.Scripting
{
    //! @addtogroup UVTexIntegra-Scripting名前空間
    //! @{

    public partial class LoadedAssembly {
        //! @brief シリアライズ情報クラス
        [System.Serializable]
        public class SerializeInformation
        {
            // public fields
            public System.String FilePath;
            public System.Byte[][] SerializedCollection;
            //! @brief デフォルトコンストラクタ
            public SerializeInformation() { }
            // @brief コンストラクタ。あるファイルパスを新しく読み込むための、空のSerializeInformationを構築します。
            public SerializeInformation(System.String FilePath) { this.FilePath = FilePath; }
            //! @brief コンストラクタ。LoadedAssemblyを元にシリアライズ可能なScriptMainインスタンスをバイナリデータにシリアライズします。
            public SerializeInformation(LoadedAssembly src)
            {
			    if ( src != null ) {
				    FilePath = src.LoadPath;
				    SerializedCollection = src.ObjectsToSerializedByteArray();
			    }
            }
            // public methods
            //! @brief SerializeInformationを基にLoadedAssemblyを生成します。
            //! @details 仮想関数であり、SerializeInformationを継承した情報クラスは、その情報クラスに対応するLoadedAssemblyの継承クラスを返すべきです。
            public virtual LoadedAssembly Load() { return LoadedAssembly.From(this); }
        };
    }
    
    //! @}
}
