// == LICENSE INFORMATION ==
/*
 * First author tiritomato 2013.
 * This program is distributed under the GNU General Public License(GPL).
 * support blog (Japanese only) http://d.hatena.ne.jp/tiri_tomato/
 */
// == LICENSE INFORMATION ==

#include "CustomControls.hpp"

namespace UVTexIntegra { namespace CustomControls {

	TextureSetForm::TextureSetForm( const MQDocument doc ) : TextureSetForm_Base(), m_doc(doc) {
		lblMsg->Text = System::String::Empty;
		m_u = m_v = 0;
		RefreshDialog();
		btnCancel->Click += gcnew System::EventHandler(this, &TextureSetForm::btnCancel_Click);
		btnOK->Click += gcnew System::EventHandler(this, &TextureSetForm::btnOK_Click);
		btnOpenFileDlg->Click += gcnew System::EventHandler(this, &TextureSetForm::btnOpenFileDlg_Click);
		System::EventHandler^ ehTxt_InputChanged = gcnew System::EventHandler(this, &TextureSetForm::txt_InputChanged);
		txtFilePath->Validated += ehTxt_InputChanged;
		txtU->Validated += ehTxt_InputChanged;
		txtV->Validated += ehTxt_InputChanged;
		System::ComponentModel::CancelEventHandler^ ehTxt_Validating =
			gcnew System::ComponentModel::CancelEventHandler(this, &TextureSetForm::txt_Validating);
		txtU->Validating += ehTxt_Validating;
		txtV->Validating += ehTxt_Validating;
	}

	void TextureSetForm::RefreshDialog() {
		txtU->Text = m_u.ToString();
		txtV->Text = m_v.ToString();
	}

	System::Void TextureSetForm::btnOK_Click(System::Object^ s, System::EventArgs^ e) { /* do nothing */ }
	System::Void TextureSetForm::btnCancel_Click(System::Object^ s, System::EventArgs^ e) { txtFilePath->Text = System::String::Empty; }
	System::Void TextureSetForm::btnOpenFileDlg_Click(System::Object^ s, System::EventArgs^ e) {}
	System::Void TextureSetForm::txt_InputChanged( System::Object^  sender, System::EventArgs^  e) {
		int tmp_u, tmp_v;
		if ( int::TryParse( txtU->Text, tmp_u ) &&
			int::TryParse( txtV->Text, tmp_v ) )
		{
			m_u = std::abs(tmp_u);
			m_v = std::abs(tmp_v);
		}
		RefreshDialog();
	}

	System::Void TextureSetForm::txt_Validating( Object^ sender, System::ComponentModel::CancelEventArgs^ e ) {
		System::Windows::Forms::Control^ ctrl = dynamic_cast<System::Windows::Forms::Control^>(sender);
		if ( ctrl != nullptr ) {
			int val;
			if ( int::TryParse( ctrl->Text, val ) ) ctrl->Text = std::abs(val).ToString();
			else RefreshDialog();
		}
	}

}}