// == LICENSE INFORMATION ==
/*
 * First author tiritomato 2013.
 * This program is distributed under the GNU General Public License(GPL).
 * support blog (Japanese only) http://d.hatena.ne.jp/tiri_tomato/
 */
// == LICENSE INFORMATION ==

#pragma once

namespace MQCLIEX {

	//! @addtogroup UVTexIntegra-MQCLIEXO
	//! @{

	//! @brief ^ZRCADWORD_J[System::Drawing::Colorɕϊ܂B
	inline System::Drawing::Color FromMQVertexColor( DWORD vc ) {
		return System::Drawing::Color::FromArgb( (vc & 0xFF000000)>>24, (vc & 0x000000FF), (vc & 0x0000FF00)>>8, (vc & 0x00FF0000)>>16 );
	}

	//! @brief R,G,B,A^ZRCADWORD_J[ɕϊ܂B
	inline DWORD ArgbToMQVertexColor( const int a, const int r, const int g, const int b )
	{
		return DWORD( unsigned int(r & 0xFF) | (unsigned int(g & 0xFF) << 8) | (unsigned int(b & 0xFF) << 16) | (unsigned int(a & 0xFF) << 24) );
	}

	//! @brief map_type̎w肷eNX`̃t@CpX擾AMQDocument::FindMappingFileŐ΃pXɕϊ܂B
	inline System::String^ GetMaterialTextureAbsName( const MQDocument doc, const MQMaterial mat, DWORD map_type ) {
		char buf[MAX_PATH];
		if ( (doc==NULL)||(mat==NULL) ) return System::String::Empty;
		std::string path = MQ0x::GetMaterialTextureName(mat, map_type);
		if ( doc->FindMappingFile(buf,path.c_str(),map_type)==FALSE ) return System::String::Empty;
		return gcnew System::String( buf );
	}

	//! @brief I𒆂̃IuWFNgIDXgԂ܂
	//! @param [in] isRecursiveRootOnly trueɐݒ肷ƁAI𒆂̎qIuWFNgAeɂǂĂꂩ̃IuWFNgIԂɂꍇɃXgAbvȂȂ܂B
	inline System::Collections::Generic::List<UINT>^ GetSelectedObjectIDs( const MQDocument doc, bool isRecursiveRootOnly ) {
		System::Collections::Generic::List<UINT>^ selectedObjectIDs = gcnew System::Collections::Generic::List<UINT>();
		if ( doc != NULL ) {
			const int ctObj = doc->GetObjectCount();
			for ( int ct = 0; ct < ctObj; ct++ ) {
				const MQObject obj = doc->GetObject(ct);
				if ( (obj!=NULL) && (obj->GetSelected()==TRUE) ) {
					const UINT id = obj->GetUniqueID();
					if ( selectedObjectIDs->Contains(id) == false ) {
						bool isFind = false;
						if ( isRecursiveRootOnly ) for ( MQObject parent = doc->GetParentObject( obj ); parent != NULL; parent = doc->GetParentObject(parent) ) {
							if ( parent->GetSelected() == TRUE ) { isFind = true; break; }
						}
						if ( isFind == false ) selectedObjectIDs->Add(id);
					}
				}
			}
		}
		return selectedObjectIDs;
	}
	//! @brief I𒆂̃IuWFNgIDXgԂ܂BGetSelectedObjectIDs( doc, false ) ɓłB
	inline System::Collections::Generic::List<UINT>^ GetSelectedObjectIDs( const MQDocument doc ) { return GetSelectedObjectIDs( doc, false ); }
	//! @brief I𒆂̃IuWFNg̖OString[]ɂĕԂ܂B
	//! @param [in] isRecursiveRootOnly trueɐݒ肷ƁAI𒆂̎qIuWFNgAeɂǂĂꂩ̃IuWFNgIԂɂꍇɃXgAbvȂȂ܂B
	inline System::Collections::Generic::List<System::String^>^ GetSelectedObjectNames( const MQDocument doc, bool isRecursiveRootOnly ) {
		System::Collections::Generic::List<UINT>^ IDs = GetSelectedObjectIDs( doc, isRecursiveRootOnly );
		System::Collections::Generic::List<System::String^>^ ret = gcnew System::Collections::Generic::List<System::String^>(IDs->Count);
		for each ( UINT id in IDs ) {
			System::String^ item = gcnew System::String(MQ0x::GetName(doc->GetObjectFromUniqueID(id)).c_str());
			if (System::String::IsNullOrEmpty(item)==false) ret->Add(item);
		}
		return ret;
	}
	//! @brief I𒆂̃IuWFNg̖OString[]ɂĕԂ܂B GetSelectedObjectNames(doc,false) ɓłB
	inline System::Collections::Generic::List<System::String^>^ GetSelectedObjectNames( const MQDocument doc ) { return GetSelectedObjectNames(doc,false); }

	//! @brief nȏ̍ŏ2ׂ̂Ԃ܂B
	//! @return nȏ̍ŏ2ׂ̂Bn傫2̊K悪Ť^̍ől𒴂ꍇ́An菬Ał߂2ׂ̂悪Ԃ܂B
	template <class T> T TryExpLogCeil2( T n ) {
		T threshold = 1;
		for ( ; threshold < (threshold*2); threshold *= 2 ) if ( n <= threshold ) break;
		return threshold;
	}


	//! @}
}