// == LICENSE INFORMATION ==
/*
 * First author tiritomato 2013.
 * This program is distributed under the GNU General Public License(GPL).
 * support blog (Japanese only) http://d.hatena.ne.jp/tiri_tomato/
 */
// == LICENSE INFORMATION ==

#include "UVTexIntegra.hpp"

namespace UVTexIntegra {

	DocumentFormat::DocumentFormat()
		: m_editDataItems( gcnew System::Collections::Generic::List<EditData^>() ),
		m_doc(NULL), BitFlags32(0), m_textureClearColor(0xFFFFFFFF), m_alphaClearColor(0xFFFFFFFF), m_bumpClearColor(0xFFFFFFFF)
	{
		IsCloneTrans= true; IsRecursiveTrans= true; IsIntegrateTexture= false; IsClrTextureOnIntegrate= false;
		IsIntegrateAlpha= false; IsClrAlphaOnIntegrate= false; IsIntegrateBump= false; IsClrBumpOnIntegrate= false;
	}
	
	DocumentFormat::DocumentFormat( DocumentFormat^ src )
		: m_doc(NULL), BitFlags32(0), m_textureClearColor(0xFFFFFFFF), m_alphaClearColor(0xFFFFFFFF), m_bumpClearColor(0xFFFFFFFF)
	{
		IsCloneTrans= true; IsRecursiveTrans= true; IsIntegrateTexture= false; IsClrTextureOnIntegrate= false;
		IsIntegrateAlpha= false; IsClrAlphaOnIntegrate= false; IsIntegrateBump= false; IsClrBumpOnIntegrate= false;
		if (src != nullptr) {
			m_doc = src->MQDocument;
			BitFlags32 = src->BitFlags32;
			m_textureClearColor = src->m_textureClearColor;
			m_alphaClearColor = src->m_alphaClearColor;
			m_bumpClearColor = src->m_bumpClearColor;
			EditDataItems = gcnew System::Collections::Generic::List<EditData^>(src->EditDataItems->Count);
			for each (EditData^ srcItem in src->EditDataItems) EditDataItems->Add(srcItem->Clone());
		}
	}
	
	EditData^ DocumentFormat::ItemFromID( const UINT UniqueID )
	{
		if (m_editDataItems != nullptr) for each (EditData^ eachData in m_editDataItems)
		{
			if ((eachData != nullptr) && (eachData->UniqueID == UniqueID)) return eachData;
		}
		return nullptr;
	}

	EditData^ DocumentFormat::ItemFromName( System::String^ matName ) {
		if ((m_editDataItems != nullptr) && (matName!=nullptr)) for each (EditData^ eachData in m_editDataItems)
		{
			if ((eachData != nullptr) && (System::String::Compare(eachData->MaterialName, matName) == 0)) return eachData;
		}
		return nullptr;
	}

	EditData^ DocumentFormat::ItemFromIndex( const int index )
	{
		if ((-1 < index) && (m_editDataItems != nullptr) && (index < m_editDataItems->Count)) return m_editDataItems[index];
		return nullptr;
	}

	int DocumentFormat::ItemIndexFromID( const UINT UniqueID )
	{
		if (m_editDataItems != nullptr) for (int index = 0; index < m_editDataItems->Count; index++)
		{
			if (m_editDataItems[index]->UniqueID == UniqueID) return index;
		}
		return -1;
	}

	EditData::SelectedCollection^ DocumentFormat::ItemsOnSelected(const int index)
	{
		System::Collections::Generic::List<EditData^>^ ret = gcnew System::Collections::Generic::List<EditData^>();
		if ( MQDocument != NULL ) {
			// first add, presented index
			EditData^ indexData = ItemFromIndex(index);
			if (indexData != nullptr) ret->Add(indexData);
			// second add, current material
			EditData^ curMatData = nullptr;
			const MQMaterial curMat = MQDocument->GetMaterial(MQDocument->GetCurrentMaterialIndex());
			if (curMat!=NULL) {
				curMatData = ItemFromID(curMat->GetUniqueID());
				if ((curMatData != nullptr) && ((indexData == nullptr) || (indexData->UniqueID != curMatData->UniqueID))) ret->Add(curMatData);
			}
			// other material
			const int ctMat = MQDocument->GetMaterialCount();
			for ( int ct = 0; ct < ctMat; ct++ ) {
				const MQMaterial mat = MQDocument->GetMaterial(ct);
				if ( mat != NULL ) {
					const UINT UniqueID = mat->GetUniqueID();
					if ((indexData != nullptr) && (indexData->UniqueID == UniqueID)) continue;
					if ((curMatData != nullptr) && (curMatData->UniqueID == UniqueID)) continue;
					if (mat->GetSelected() == TRUE) {
						EditData^ addItem = ItemFromID(UniqueID);
						if (addItem != nullptr) ret->Add(addItem);
					}
				}
			}
		}
		return gcnew EditData::SelectedCollection(ret->AsReadOnly());
	}

}
