using System;
using System.Collections.Generic;
using System.Text;

using System.Diagnostics;

using System.Runtime.InteropServices;
using System.Timers;

namespace Eyes
{
    delegate void RunningHandler(bool state);

    class IdleChecker
    {
        [DllImport("user32.dll", CharSet = CharSet.Auto)]
        private static extern bool SystemParametersInfo
            (int uAction, int uParam, ref int lpvParam, int flags);

        [DllImport("user32.dll", CharSet = CharSet.Auto)]
        private static extern bool SystemParametersInfo
            (int uAction, int uParam, ref bool lpvParam, int flags);

        private const int SPI_GETSCREENSAVERRUNNING = 114;

        private Timer timer = null;
        private bool wasRunning = false;

        public event RunningHandler running;

        public IdleChecker()
        {
            wasRunning = false;

            timer = new Timer();
            timer.Elapsed += new ElapsedEventHandler(CheckRunning);
            timer.AutoReset = true;     // ԊuƂɃCxg
        }

        public void Run(int period)
        {   // period ̓XN[Z[o[쒆ǂׂԊu
            wasRunning = false;

            timer.Interval = period;
            timer.Enabled = true;       // ^C}[X^[g
        }

        public void CheckRunning(object sender, ElapsedEventArgs e)
        {
            bool isRunning = false;

            SystemParametersInfo(SPI_GETSCREENSAVERRUNNING, 0, ref isRunning, 0);

            if (wasRunning != isRunning)    // XN[Z[o[̏Ԃ
                running(isRunning);         // ωCxg

            wasRunning = isRunning;
        }
    }
}
