using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Eyes.Properties;

using System.Diagnostics;

using System.Collections;

namespace Eyes
{
    public partial class Manager : Form
    {
        private void setNode(TreeNode node, ContactMember contact)
        {
            node.Name = contact.Name;
            node.Text = contact.Name;
            node.ImageIndex = (int)contact.Status;
            node.SelectedImageIndex = (int)contact.Status;
            node.ToolTipText = contact.Name + "@" + contact.Machine
                + " [" + contact.Address + "] ";
            node.Tag = contact;
            node.Checked = contact.Notify;
        }

        private void setNode(TreeNode node, Group group)
        {
            node.Name = group.Name;
            node.Text = group.Name;
            node.ImageIndex = 0;
            node.SelectedImageIndex = 0;
            node.ToolTipText = group.Name;
            node.Tag = group;

            foreach (ContactMember contact in group.Members)
            {
                TreeNode memberNode = new TreeNode();
                setNode(memberNode, contact);
                node.Nodes.Add(memberNode);
            }
        }

        private void InitializeTreeView()
        {
            treeView.ImageList = imageStatus;
            treeView.Nodes.Clear();

            List<TreeNode> nodes = new List<TreeNode>();
            int index = GROUP_ALL;

            foreach (Group group in groupList)
            {
                TreeNode groupNode = new TreeNode(group.Name);
                groupNode.Tag = group;
                if (group == this.group)
                    index = groupList.IndexOf(group);

                if (group.Members != null)
                    foreach (ContactMember contact in group.Members)
                    {
                        TreeNode node = new TreeNode();
                        setNode(node, contact);
                        groupNode.Nodes.Add(node);
                    }

                nodes.Add(groupNode);

                if (group.IsExpanded)
                    groupNode.Expand();
            }

            treeView.Nodes.AddRange(nodes.ToArray());
            treeView.SelectedNode = treeView.Nodes[index];
            treeView.Focus();

            // グループリストのメニューへグループを追加
            List<ToolStripMenuItem> list = new List<ToolStripMenuItem>();

            foreach (Group group in groupList)
            {
                ToolStripMenuItem item = new ToolStripMenuItem(group.Name);
                item.Click += new EventHandler(groupToolStripMenuItem_Click);
                item.Checked = (group == this.group) ? true:false;
                list.Add(item);
            }
            
            グループリストToolStripMenuItem.DropDownItems.AddRange(list.ToArray());
        }

        private void updateGroupNode(string groupName)
        {
            foreach (TreeNode groupNode in treeView.Nodes)
                if (groupNode.Text == groupName)
                {
                    Group group = (Group)groupNode.Tag;
                    List<TreeNode> nodes = new List<TreeNode>();

                    if (group.Members != null)
                        foreach (ContactMember contact in group.Members)
                        {
                            TreeNode node = new TreeNode();
                            setNode(node, contact);
                            nodes.Add(node);
                        }

                    groupNode.Nodes.Clear();
                    groupNode.Nodes.AddRange(nodes.ToArray());
                }
        }

        private void addMemberToTree(int index, ContactMember contact)
        {
            TreeNode node = new TreeNode();
            setNode(node, contact);
            treeView.Nodes[index].Nodes.Add(node);
        }

        private void delMemberFromTree(int index, ContactMember contact)
        {
            foreach (TreeNode node in treeView.Nodes[index].Nodes)
                if ((ContactMember)node.Tag == contact)
                    node.Remove();

            if (index == GROUP_ALL)
            {
                for (int i = 0; i < groupList.Count; i++)
                    if (groupList[i].Members.Contains(contact))
                    {
                        groupList[i].Members.Remove(contact);
                        delMemberFromTree(i, contact);
                    }
            }
        }

        private void insertGroupToTree(int index, Group group)
        {
            TreeNode node = new TreeNode();
            setNode(node, group);
            treeView.Nodes.Insert(index, node);
            node.Expand();
            group.IsExpanded = true;
            treeView.SelectedNode = node;
            treeView.Focus();
            
            ToolStripMenuItem item = new ToolStripMenuItem(group.Name);
            item.Click += new EventHandler(groupToolStripMenuItem_Click);
            item.Checked = (group == this.group) ? true : false;
            グループリストToolStripMenuItem.DropDownItems.Insert(index, item);
        }

        private void addGroupToTree(Group group)
        {
            int index = グループリストToolStripMenuItem.DropDownItems.Count - 1;
            insertGroupToTree(index, group);
        }

        private void delGroupFromTree(Group group)
        {
            if (this.group == group)
                this.group = groupList[groupList.IndexOf(group) - 1];

            foreach (TreeNode node in treeView.Nodes)
                if ((Group)node.Tag == group)
                    node.Remove();

            foreach (ToolStripMenuItem item in グループリストToolStripMenuItem.DropDownItems)
                if (item.Text == group.Name)
                {
                    グループリストToolStripMenuItem.DropDownItems.Remove(item);
                    break;
                }
        }

        private void updateNode(TreeNodeCollection nodes)
        {
            foreach (TreeNode node in nodes)
                if (node.Nodes.Count > 0)
                    foreach (TreeNode memberNode in node.Nodes)
                    {
                        ContactMember contact = (ContactMember)memberNode.Tag;
                        setNode(memberNode, contact);
                    }
        }

        private void updateTreeView()
        {
            updateNode(treeView.Nodes);

            UpdateListView(group);
        }

        private void treeView_AfterExpand(object sender, TreeViewEventArgs e)
        {
            Group group = (Group)e.Node.Tag;
            group.IsExpanded = true;
        }

        private void treeView_AfterCollapse(object sender, TreeViewEventArgs e)
        {
            Group group = (Group)e.Node.Tag;
            group.IsExpanded = false;
        }

        private void treeMenuEnable()
        {
            treeMenuStrip.Items["treeMenuUp"].Enabled = true;
            treeMenuStrip.Items["treeMenuUp"].Visible = true;
            treeMenuStrip.Items["treeMenuDown"].Enabled = true;
            treeMenuStrip.Items["treeMenuDown"].Visible = true;
            treeMenuStrip.Items["treeMenuRename"].Enabled = true;
            treeMenuStrip.Items["treeMenuRename"].Visible = true;

            treeMenuStrip.Items["treeMenuSeparator1"].Visible = true;
            treeMenuStrip.Items["treeMenuSeparator2"].Visible = true;
        }

        private void treeMenuDisable()
        {
            treeMenuStrip.Items["treeMenuUp"].Visible = false;
            treeMenuStrip.Items["treeMenuDown"].Visible = false;
            treeMenuStrip.Items["treeMenuRename"].Visible = false;
            treeMenuStrip.Items["treeMenuSeparator1"].Visible = false;
            treeMenuStrip.Items["treeMenuSeparator2"].Visible = false;
        }

        private void treeView_MouseDown(object sender, MouseEventArgs e)
        {
            treeView.SelectedNode = treeView.GetNodeAt(e.X, e.Y);
            treeView.Focus();

            if (treeView.SelectedNode != null)
            {
                Type nodeType = treeView.SelectedNode.Tag.GetType();

                if (e.Button == MouseButtons.Right)
                {
                    if (nodeType == typeof(Group))
                    {
                        treeMenuEnable();

                        if (treeView.Nodes[0].IsSelected == true)
                        {
                            treeMenuStrip.Items["treeMenuUp"].Enabled = false;
                            treeMenuStrip.Items["treeMenuDown"].Enabled = false;
                            treeMenuStrip.Items["treeMenuRename"].Enabled = false;
                            treeMenuStrip.Items["deleteTree"].Enabled = false;
                        }
                        else
                        {
                            if (treeView.Nodes[1].IsSelected == true)
                                treeMenuStrip.Items["treeMenuUp"].Enabled = false;

                            int lastIndex = (treeView.Nodes.Count - 1);
                            if (treeView.Nodes[lastIndex].IsSelected == true)
                                treeMenuStrip.Items["treeMenuDown"].Enabled = false;
                        }
                    }
                    else
                    {
                        treeMenuDisable();
                    }
                }

                if (nodeType == typeof(Group))
                    this.group = (Group)treeView.SelectedNode.Tag;
                else
                    this.group = (Group)treeView.SelectedNode.Parent.Tag;

                updateTreeView();
            }
        }

        private void treeView_MouseUp(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                if (treeView.GetNodeAt(e.X, e.Y) == null)
                    managerMenuStrip.Show(Cursor.Position.X, Cursor.Position.Y);
                else
                    treeMenuStrip.Show(Cursor.Position.X, Cursor.Position.Y);
            }
        }

        private void deleteTreeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            TreeNode node = treeView.SelectedNode;

            if (node.Tag.GetType() == typeof(Group))
            {
                Group group = (Group)node.Tag;
                treeView.SelectedNode = node.PrevNode;
                treeView.Focus();
                delGroupFromTree(group);
                groupList.Remove(group);
            }

            if (node.Tag.GetType() == typeof(ContactMember))
            {
                Group group = (Group)node.Parent.Tag;
                ContactMember contact = (ContactMember)node.Tag;
                int index = groupList.IndexOf(group);
                delMemberFromTree(index, contact);
                group.Members.Remove(contact);

                if (group.Members.Count == 0)
                {
                    delGroupFromTree(group);
                    groupList.Remove(group);
                    this.group = groupList[GROUP_ALL];
                }
            }

            updateListView();
        }
    }
}
