/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.conversion;

import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;

public final class Asset {
    private final String mimeType;
    private final byte[] data;
    private final String name;

    public Asset(String mimeType, byte[] data) {
        this(mimeType, data, null);
    }

    public Asset(String mimeType, byte[] data, String name) {
        this.mimeType = Preconditions.checkNotNull(mimeType).toLowerCase();
        this.data = data;
        this.name = name;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Asset other = (Asset)o;
        return Objects.equal(this.mimeType, other.getMimeType()) && Objects.deepEquals(this.data, other.getData()) && Objects.equal(this.name, other.getName());
    }

    public int hashCode() {
        return Objects.hashCode(this.mimeType, this.data, this.name);
    }
}

