/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.util;

import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.type.PrimitiveType;
import java.util.regex.Pattern;
import org.slim3.gen.util.StringUtil;
import org.slim3.gen.util.TypeUtil;

public final class FieldDeclarationUtil {
    private static Pattern isPrefixedFieldPattern = Pattern.compile("^is[A-Z].*");

    public static String getReadMethodName(FieldDeclaration fieldDeclaration) {
        if (fieldDeclaration == null) {
            throw new NullPointerException("The fieldDeclaration parameter is null.");
        }
        return FieldDeclarationUtil.getReadMethodNames(fieldDeclaration)[0];
    }

    public static String[] getReadMethodNames(FieldDeclaration fieldDeclaration) {
        if (fieldDeclaration == null) {
            throw new NullPointerException("The fieldDeclaration parameter is null.");
        }
        String fieldName = fieldDeclaration.getSimpleName();
        if (TypeUtil.isPrimitive(fieldDeclaration.getType(), PrimitiveType.Kind.BOOLEAN)) {
            if (isPrefixedFieldPattern.matcher(fieldName).matches()) {
                return new String[]{fieldName};
            }
            String capitalized = StringUtil.capitalize(fieldName);
            return new String[]{"is" + capitalized, "get" + capitalized};
        }
        return new String[]{"get" + StringUtil.capitalize(fieldName)};
    }

    public static String getWriteMethodName(FieldDeclaration fieldDeclaration) {
        if (fieldDeclaration == null) {
            throw new NullPointerException("The fieldDeclaration parameter is null.");
        }
        String fieldName = fieldDeclaration.getSimpleName();
        if (TypeUtil.isPrimitive(fieldDeclaration.getType(), PrimitiveType.Kind.BOOLEAN) && isPrefixedFieldPattern.matcher(fieldName).matches()) {
            return "set" + fieldName.substring(2);
        }
        return "set" + StringUtil.capitalize(fieldName);
    }

    public static String getPropertyName(FieldDeclaration fieldDeclaration) {
        if (fieldDeclaration == null) {
            throw new NullPointerException("The fieldDeclaration parameter is null.");
        }
        String fieldName = fieldDeclaration.getSimpleName();
        if (TypeUtil.isPrimitive(fieldDeclaration.getType(), PrimitiveType.Kind.BOOLEAN) && isPrefixedFieldPattern.matcher(fieldName).matches()) {
            return StringUtil.decapitalize(fieldName.substring(2));
        }
        return fieldName;
    }
}

