/**
 * 
 */
package jp.co.opst.sms.logic;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;

/**
 * Userカインドにアクセスする。
 * 
 * @author y-kim
 * 
 */
public final class LoginLogic {
	private static final Logger logger = Logger.getLogger("PMS Log");
	public static User checkLogin() {
		UserService us = UserServiceFactory.getUserService();
		User user = us.getCurrentUser();

		if (user == null) {
			logger.log(Level.INFO, "[DEBUG]:user == null ");
			return null;
		}


		if (!LoginLogic.checkExist(user.getEmail())) {
			logger.log(Level.INFO, "[DEBUG]:キーで取得不可 ");
			return null;
		}
		logger.log(Level.INFO, "[INFO]:Logined by " + user.getEmail());
		return user;
	}

	/**
	 * 指定されたIDが登録されているかチェックする。
	 * 
	 * @param userId
	 *            com.google.appengine.api.users.User.getUserId()で取得したID
	 * @return　 IDが存在していればtrueを返す。
	 */
	public static boolean checkExist(String gmail) {
		return false;
	}

}
