﻿/*************************
  Coppermine Photo Gallery
  ************************
  Copyright (c) 2003-2009 Coppermine Dev Team
  v1.1 originaly written by Gregory DEMAR

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  as published by the Free Software Foundation.

  ********************************************
  Coppermine version: 1.5.2
  $HeadURL: https://coppermine.svn.sourceforge.net/svnroot/coppermine/trunk/cpg1.5.x/docs/en/script.js $
  $Revision: 6605 $
  $LastChangedBy: gaugau $
  $Date: 2009-09-28 10:24:49 +0200 (Mo, 28. Sep 2009) $
**********************************************/

var linebreak = '\n';

$(function() {
    $("#toc_overall").treeview({
        collapsed: true,
        animated: "medium",
        control:"#sidetreecontrol"
    });
    $(".cpg_zebra tr:even").addClass("tableb");
	$(".cpg_zebra tr:odd").addClass("tableb_alternate");
});

function cpgDocToc() {
  if (getUrlParameters('hide_nav') == 1) {
  	$('#toc').replaceWith('');
	return;
  }
var doc_toc = '';
doc_toc += '<div id="toc_collapsed">\n';
doc_toc += '<h6><a href="toc.htm">Table of contents</a></h6>\n';
doc_toc += 'Move your mouse here to expand\n';
doc_toc += '<div align="center"><img src="../../images/icons/downdown.png" border="0" width="10" height="10" alt="" /></div>\n';
doc_toc += '</div>\n';
doc_toc += '<div id="toc_expanded" style="display:none;">\n';
doc_toc += '<h6>Table of contents (<a href="../index.htm">documentation language selection</a>)</h6>\n';
doc_toc += '<ul id="tree">\n';
doc_toc += '  <li><a href="index.htm">Coppermine documentation</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="index.htm#about">About Coppermine</a></li>\n';
doc_toc += '      <li><a href="index.htm#about_documentation">About the documentation</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="index.htm#about_documentation_conventions">Documentation Conventions</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="index.htm#features">Features</a></li>\n';
doc_toc += '      <li><a href="quickstart.htm#about">Quick-Start guide</a></li>\n';
doc_toc += '      <li><a href="toc.htm">Table of contents</a></li>\n';
doc_toc += '      <li><a href="requirements.htm">Minimum requirements</a>\n';
doc_toc += '        <ul id="minimum_requirements">\n';
doc_toc += '          <li><a href="requirements.htm#what_minimum">Server-sided minimum requirements</a>\n';
doc_toc += '            <ul id="minimum_requirements_server">\n';
doc_toc += '              <li><a href="requirements.htm#what_minimum_webserver">Web server</a></li>\n';
doc_toc += '              <li><a href="requirements.htm#what_minimum_php">PHP support</a></li>\n';
doc_toc += '              <li><a href="requirements.htm#what_minimum_mysql">mySQL database</a></li>\n';
doc_toc += '              <li><a href="requirements.htm#what_minimum_image_library">Image library</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="requirements.htm#what_minimum_self-hosting">Self-Hosting &amp; Webserver Setup</a></li>\n';
doc_toc += '          <li><a href="requirements.htm#personal">Personal requirements</a></li>\n';
doc_toc += '          <li><a href="requirements.htm#requirements_faq">Requirements FAQ</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="testing.htm">Testing (alpha/beta versions!)</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="testing.htm#testing_support">No support for alpha and beta versions</a></li>\n';
doc_toc += '          <li><a href="testing.htm#testing_areas">Areas to be particularly mindful of</a></li>\n';
doc_toc += '          <li><a href="testing.htm#testing_feature_list">Feature list</a></li>\n';
doc_toc += '          <li><a href="testing.htm#testing_report">The report format</a></li>\n';
doc_toc += '          <li><a href="testing.htm#testing_availability">Availability</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="languages.htm">Languages</a>\n';
doc_toc += '        <ul id="languages">\n';
doc_toc += '          <li><a href="languages.htm#how">How languages work in Coppermine</a></li>\n';
doc_toc += '          <li><a href="translation.htm">Translation guide</a>\n';
doc_toc += '            <ul id="translation">\n';
doc_toc += '              <li><a href="translation.htm#translation_translators_wanted">Translators wanted!</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_why_translate">Why translate?</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_which_languages">Translations for which languages are needed?</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_who">Who can translate?</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_char_encoding">Character encoding</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_editors">Editors &amp; Tools</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_full_translation">Full translations only</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_step_by_step">Step by step</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_special_issues">Special issues</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_versions">Language versions</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_work_in_progress">Work in progress</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_initial_translation">Initial translation for release</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_older_language_files">Using older language files</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_documentation">Translating the documentation</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="credits.htm">Credits</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="credits.htm#developers">Coppermine team</a></li>\n';
doc_toc += '          <li><a href="credits.htm#contributors">Contributors</a></li>\n';
doc_toc += '          <li><a href="credits.htm#translators">Translators</a>\n';
doc_toc += '            <ul class="level3" id="translators">\n';
doc_toc += '              <li><a href="credits.htm#translators_language_file">Language files</a></li>\n';
doc_toc += '              <li><a href="credits.htm#translators_documentation">Documentation</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="credits.htm#codebase">Free code used</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="copyrights.htm">License &amp; Copyright</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="copyrights.htm#copyright_copyright">Copyrights</a></li>\n';
doc_toc += '          <li><a href="copyrights.htm#copyright_license">License</a></li>\n';
doc_toc += '          <li><a href="copyrights.htm#copyrights_previous_versions">Previous versions</a></li>\n';
doc_toc += '          <li><a href="copyrights.htm#copyright_additional">Additional terms (license add-ons)</a>\n';
doc_toc += '            <ul class="level3" id="additional_terms">\n';
doc_toc += '              <li><a href="copyrights.htm#copyright_additional_preservation">Preservation of author attributions</a></li>\n';
doc_toc += '              <li><a href="copyrights.htm#copyright_additional_marking">Marking of modified versions</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="copyrights.htm#copyright_freedom">Freedom</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="known_issues.htm">Known issues</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="install.htm">Installation and setup</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="install.htm#how">How to install the script</a></li>\n';
doc_toc += '      <li><a href="install.htm#what">What the installer does</a></li>\n';
doc_toc += '      <li><a href="install_permissions.htm">Setting permissions</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="install_permissions.htm#chmod">Apache on Unix/Linux (CHMOD)</a></li>\n';
doc_toc += '          <li><a href="install_permissions.htm#apache_windows">Apache on Windows</a></li>\n';
doc_toc += '          <li><a href="install_permissions.htm#iis">IIS on Windows</a></li>\n';
doc_toc += '          <li><a href="install_permissions.htm#support">Asking for support on permissions issues</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="install_screen.htm">The install screen</a></li>\n';
doc_toc += '      <li><a href="auto-installers.htm">Auto-Installers</a></li>\n';
doc_toc += '      <li><a href="install_faq.htm">Installation FAQ</a></li>\n';
doc_toc += '      <li><a href="uninstall.htm">Uninstall</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="upgrading.htm">Upgrading</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="upgrading.htm#upgrade_why">Why upgrade?</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '              <li><a href="upgrading.htm#upgrade_why_reasons">Reasons for package releases</a></li>\n';
doc_toc += '              <li><a href="upgrading.htm#upgrade_why_changelog">Changelog</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upgrading.htm#upgrade_any">Steps needed to perform when upgrading Coppermine (from any version)</a></li>\n';
doc_toc += '      <li><a href="upgrading.htm#upgrade_particular">Additional actions for updating from particular versions</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="upgrading.htm#upgrade_10">Upgrading from versions cpg1.0,1.1,1.2.x or 1.3.x</a></li>\n';
doc_toc += '          <li><a href="upgrading.htm#upgrade_14">Upgrading from cpg1.4.x to version cpg1.5.x</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upgrading.htm#updater">The update script</a>\n';
doc_toc += '          <ul class="level3" id="updater">\n';
doc_toc += '              <li><a href="upgrading.htm#updater_what_it_does">What it does</a></li>\n';
doc_toc += '              <li><a href="upgrading.htm#updater_purpose">Purpose</a></li>\n';
doc_toc += '              <li><a href="upgrading.htm#updater_authorization">Authorization check</a></li>\n';
doc_toc += '              <li><a href="upgrading.htm#updater_when">When must the updater be run?</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upgrading.htm#versioncheck">The version check tool</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_description_start">What it does</a></li>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_options_start">Options</a></li>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_comparison_start">Version comparison</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upgrading.htm#upgrade_faq">Upgrading FAQ</a></li>\n';
doc_toc += '      <li><a href="upgrading.htm#downgrading">Downgrading from cpg1.5.x to an older version</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="start.htm">Getting Started</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="start.htm#getting_concepts">Basic concepts</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_initial_configuration">Initial configuration</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_structure">Category/album/file structure</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_resizing">Resized images</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="start.htm#getting_resizing_thumbnails">Thumbnails</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_resizing_intermediate">Intermediates</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_resizing_original">Originals</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_resizing_recommended">Recommended resizing setups</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="start.htm#getting_resizing_recommended_nofullsize">No full-size pop-ups</a></li>\n';
doc_toc += '              <li><a href="start.htm#getting_resizing_recommended_nointermediate">Allow full-size pop-ups with maximum space saving</a></li>\n';
doc_toc += '              <li><a href="start.htm#getting_resizing_recommended_regular">&quot;Regular&quot; setup with moderate file space consumption</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="start.htm#getting_admin_account">Your admin account</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_check_uploads">Check uploads</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_consider_bridging">Consider bridging</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_interaction">What are your visitors allowed to do?</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_design">Change your coppermine\'s design</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_typical">Typical setups</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="start.htm#getting_typical_monolithic">Single uploader without user interaction (Monolithic gallery)</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_typical_single_uploader_community">Single uploader with user interaction</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="faq.htm">Frequently Asked Questions</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="faq.htm#faq_setup">Setup / Configuration</a></li>\n';
doc_toc += '      <li><a href="faq.htm#hacks">Add-ons / Modifications / Hacks</a></li>\n';
doc_toc += '      <li><a href="faq.htm#support_board">Coppermine Support board</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="theme.htm">Themes</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="theme.htm#theme_builtin">Themes that come with Coppermine</a></li>\n';
doc_toc += '      <li><a href="theme.htm#theme_upgrading">Upgrading your custom theme</a>\n';
doc_toc += '      <ul>\n';
doc_toc += '        <li><a href="theme_upgrade_14x-15x.htm">Converting cpg1.4.x themes to cpg1.5.x</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '            <li><a href="theme_upgrade_14x-15x.htm#style">Edit style.css</a></li>\n';
doc_toc += '            <li><a href="theme_upgrade_14x-15x.htm#template">Edit template.html</a></li>\n';
doc_toc += '            <li><a href="theme_upgrade_14x-15x.htm#theme">Edit theme.php</a></li>\n';
doc_toc += '            <li><a href="theme_upgrade_14x-15x.htm#validation">Validation Methodology</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '        </li>\n';
doc_toc += '        <li><a href="theme_upgrade_13x-14x.htm">Converting cpg1.3.x themes to cpg1.4.x</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '            <li><a href="theme_upgrade_13x-14x.htm#style">Edit style.css</a></li>\n';
doc_toc += '            <li><a href="theme_upgrade_13x-14x.htm#template">Edit template.html</a></li>\n';
doc_toc += '            <li><a href="theme_upgrade_13x-14x.htm#theme">Edit theme.php</a></li>\n';
doc_toc += '            <li><a href="theme_upgrade_13x-14x.htm#validation">Validation Methodology</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '        </li>\n';
doc_toc += '      </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme.htm#theme_files">Content of a theme</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_template.htm#theme_template_html">Editing template.html</a>\n';
doc_toc += '              <ul class="level3" id="theme_template_html">\n';
doc_toc += '                  <li><a href="theme_template.htm#theme_template_token">Template tokens</a></li>\n';
doc_toc += '                  <li><a href="theme_template.htm#theme_template_important">Important</a></li>\n';
doc_toc += '                  <li><a href="theme_template.htm#theme_template_token_list">List of tokens in template.html</a></li>\n';
doc_toc += '              </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_style_css.htm#theme_style_css">Editing style.css</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_tools">Tools</a>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_list">List of classes in style.css</a>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_overall">Additional stylesheet</a>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_theme_php.htm#theme_create_theme_php">Editing theme.php</a>\n';
doc_toc += '              <ul class="level3" id="theme_theme_php">\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_types">Item types</a></li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm">The sample theme - a template to copy from</a></li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_method">Method</a></li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_scope">Scope</a></li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_list">List of items in theme.php</a></li>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples">Theme Examples</a></li>\n';
doc_toc += '              </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme.htm#theme_engine">How the theme engine works</a></li>\n';
doc_toc += '      <li><a href="theme_user-contributions.htm#theme_user-contributions">User-contributed themes</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_preview">Preview user-contributed themes</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_download">Download user-contributed themes</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_install">Installing user-contributed themes</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_copyrights">Copyrights of user-contributed themes</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_support">Asking for support on user-contributed themes</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_contributing">Contributing your own theme</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme_create.htm#theme_create">Creating your custom theme</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_create.htm#theme_create_rename">Rename your theme first</a></li>\n';
doc_toc += '          <li><a href="theme_create.htm#theme_create_tipps">Tipps &amp; tricks</a></li>\n';
doc_toc += '          <li><a href="theme_create.htm#theme_create_wysiwyg">Using WYSIWYG-editors</a></li>\n';
doc_toc += '          <li><a href="theme_create.htm#theme_create_colors">Modifying colors</a></li>\n';
doc_toc += '          <li><a href="theme_create_matching_page_tutorial.htm#theme_matching">Creating a Coppermine theme that matches your overall site layout</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme_copyright.htm">Copyright-disclaimer in footer</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_copyright.htm#theme_copyright_fair_use">Fair use</a>\n';
doc_toc += '          <li><a href="theme_copyright.htm#theme_copyright_unfair_use">Unfair use</a>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="php-content.htm">Dynamic (PHP-driven) content</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="php-content.htm#php-content_anycontent">Using anycontent.php</a></li>\n';
doc_toc += '          <li><a href="php-content.htm#php-content_header_footer">Custom header and footer</a></li>\n';
doc_toc += '          <li><a href="php-content.htm#php-content_theme">Theme-based dynamic content (theme.php)</a></li>\n';
doc_toc += '          <li><a href="php-content.htm#php-content_core">Modifying core files</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme_graphics.htm">Graphic resources in themes</a>\n';
doc_toc += '          <ul class="level3" id="theme_graphics">\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_menu_icons">Menu Icons</a></li>\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_nav_bar">Image Navigation bar</a></li>\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_rating">Rating images</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="administration.htm">Administration</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="admin_menu.htm">Admin menu items</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="admin_menu.htm#admin_user_mode">Enable / disable admin controls</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#upload_approval">Upload approval</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#config">Config</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#categories">Categories</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#albums">Albums</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#sort_my_pictures">Sort my pictures</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#groups">Groups</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#users">Users</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#ban">Ban Users</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#my_profile">My profile</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#review_comments">Review Comments</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#ecard_log">Display Ecards</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#batch_add">Batch add files</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#admin_tools">Admin Tools (Resize Pictures)</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#keyword_manager">Keyword manager</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#plugin_manager">Plugin Manager</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#bridge_manager">Bridge Manager</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#view_log">View log files</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#">Overall stats</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#stats"></a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#versioncheck">Check versions</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#update_database">Update database</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#export">Export</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#phpinfo">phpinfo</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#show_news">Show news</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#documentation">Documentation</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#">Admin mode for regular users</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#admin_mode_regular_users"></a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#user_menu_items">Admin menu items for regular users</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="banning.htm#banning">Banning</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '      <li><a href="banning.htm#banning_whats_new">What\'s new?</a></li>\n';
doc_toc += '      <li><a href="banning.htm#banning_scope">Scope</a></li>\n';
doc_toc += '      <li><a href="banning.htm#bannig_how_it_works">How banning works</a></li>\n';
doc_toc += '      <li><a href="banning.htm#banning_by_ip_address_no_good">Why banning by IP address is not recommended</a></li>\n';
doc_toc += '      <li><a href="banning.htm#banning_page">Page controls</a></li>\n';
doc_toc += '      <li><a href="banning.htm#banning_bridged">No banning when bridged</a></li>\n';
doc_toc += '      <li><a href="banning.htm#banning_todo">To do</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="configuration.htm">Configuration</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="configuration.htm#admin_general">General settings</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_language">Language &amp; Charset settings</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_theme">Themes settings</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_album_list">Album list view</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_thumbnail_view">Thumbnail view</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_image_comment">Image view</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_comment_start">Comment settings</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_contact_start">Contact form settings</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_thumb_start">Thumbnail settings</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_picture_thumbnail">File settings</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_watermarking">Image watermarking</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_registration">Registration</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_user">User settings</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_custom">Custom fields for user profile</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_custom_image">Custom fields for image description</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_cookie">Cookie settings</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_email">Email settings</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_logging">Logging &amp; statistics</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_misc">Maintenance settings</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="groups.htm">Groups</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="groups.htm#group_cp">The group control panel</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_names">Group names</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_types">Group types</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_quota">Quota</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_permissions">Group permissions (Rating/Ecards/Comments)</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_public">Public albums upload</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_personal">Personal gallery</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_upload_method">Upload method</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_assigned">Assigned albums</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_create">Creating custom groups</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_delete">Deleting custom groups</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_sync">Triggering synchronisation (bridged only)</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="users.htm">Users</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="users.htm#user_cp">The user control panel</a></li>\n';
doc_toc += '          <li><a href="users.htm#user_cp_page">Page controls</a></li>\n';
doc_toc += '          <li><a href="users.htm#user_cp_search">Searching for user(s)</a></li>\n';
doc_toc += '          <li><a href="users.htm#user_cp_new">Creating new users</a></li>\n';
doc_toc += '          <li><a href="users.htm#user_cp_edit">Editing users</a></li>\n';
doc_toc += '          <li><a href="users.htm#user_cp_group">Group membership</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="categories.htm">Categories</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="categories.htm#cat_cp">The categories control panel</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="categories.htm#cat_cp_page_controls">Page controls</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="categories.htm#cat_cp_page_controls_sort">Top box &quot;Sort categories alphabetically&quot;</a></li>\n';
doc_toc += '                  <li><a href="categories.htm#cat_cp_page_controls_categories">Middle box &quot;Manage Categories&quot;</a></li>\n';
doc_toc += '                  <li><a href="categories.htm#cat_cp_page_controls_create">Bottom box &quot;Update/Create category&quot;</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="categories.htm#cat_user_galleries">Special category &quot;User galleries&quot;</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="albums.htm">Albums</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="albums.htm#albmgr">The Album Manager</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="albums.htm#albmgr_create">Creating albums</a></li>\n';
doc_toc += '              <li><a href="albums.htm#albmgr_rename">Renaming albums</a></li>\n';
doc_toc += '              <li><a href="albums.htm#albmgr_order">Changing the album order</a></li>\n';
doc_toc += '              <li><a href="albums.htm#albmgr_delete">Deleting albums</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="albums.htm#modif_alb_pics">Modifying albums/files</a></li>\n';
doc_toc += '          <li><a href="albums.htm#album_prop">Album properties</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="albums.htm#album_prop_reset_start">Reset album properties</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="albums.htm#album_admin_user">Admin vs. user</a></li>\n';
doc_toc += '          <li><a href="albums.htm#album_faq">Album FAQ</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="files.htm">Files</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="files.htm#edit_pics">Editing files</a></li>\n';
doc_toc += '          <li><a href="files.htm#edit_vids">Editing videos</a></li>\n';
doc_toc += '          <li><a href="files.htm#cust_thmb">Custom Thumbnails</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="keywords.htm">Keywords</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="keywords.htm#keywords_assign">Assigning keywords</a></li>\n';
doc_toc += '          <li><a href="keywords.htm#keywords_assign_upload">Assigning keywords when uploading</a></li>\n';
doc_toc += '          <li><a href="keywords.htm#keywords_assign_edit">Editing/adding keywords</a></li>\n';
doc_toc += '          <li><a href="keywords.htm#keywords_manager">Keywords manager</a></li>\n';
doc_toc += '          <li><a href="keywords.htm#keywords_album">Album keywords</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="bbcode.htm">bbCode</a></li>\n';
doc_toc += '      <li><a href="exif.htm">Exif data</a></li>\n';
doc_toc += '      <li><a href="plugins.htm">Plugins</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_definition">What is a plugin?</a></li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_api">The Plugin API</a></li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_obtain">Where to get Plugins from?</a></li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_bundled">Plugins that ship with Coppermine</a></li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_manager">The Plugin Manager</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_manager_upload">Uploading a plugin</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_manager_install">Installing a plugin</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_manager_configuration">Plugin Configuration</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_manager_uninstall">Uninstalling a plugin</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_writing">Writing plugins</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="performance.htm#perf_tips">Performance</a></li>\n';
doc_toc += '      <li><a href="admin-tools.htm#admin_tools">Admin Tools</a></li>\n';
doc_toc += '      <li><a href="errors.htm#errors">Errors</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="errors.htm#errors_types">Error types</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="errors.htm#errors_soft">Soft Errors</a>\n';
doc_toc += '              <li><a href="errors.htm#errors_hard">Hard Errors</a>\n';
doc_toc += '              <li><a href="errors.htm#errors_unhandled">Unhandled Errors</a>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="errors.htm#errors_fatal">Fatal error</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="errors.htm#errors_debug_mode_config">Enabling debug_mode in Config</a>\n';
doc_toc += '              <li><a href="errors.htm#errors_debug_mode_manual">Manually enabling debug_mode</a>\n';
doc_toc += '              <li><a href="errors.htm#errors_debug_mode_off">Turning debug_mode off</a>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="errors.htm#errors_messages">Common error messages</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="errors.htm#errors_messages_database">Database-related error messages</a>\n';
doc_toc += '              <li><a href="errors.htm#commonPHPerrors">Common PHP errors</a>\n';
doc_toc += '              <li><a href="errors.htm#errors_messages_upload">Upload-related error messages</a>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="export.htm#backup_export">Backup &amp; Export</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="export.htm#backup_export_decision">Decide for one method</a></li>\n';
doc_toc += '          <li><a href="export.htm#backup">Backup</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="export.htm#backup_file">File Backup</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="export.htm#backup_file_complete">Complete File Backup</a></li>\n';
doc_toc += '                  <li><a href="export.htm#backup_file_partial">Partial File Backup</a></li>\n';
doc_toc += '                  <li><a href="export.htm#backup_file_incremental">Incremental File Backup</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="export.htm#backup_database">Database Backup</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="export.htm#backup_database_what">What needs to be backed up?</a></li>\n';
doc_toc += '                  <li><a href="export.htm#backup_database_tools">Database Backup Tools</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="export.htm#backup_database_tools_phpmyadmin">phpMyAdmin</a></li>\n';
doc_toc += '                      <li><a href="export.htm#backup_database_tools_mysqldumper">mySqlDumper</a></li>\n';
doc_toc += '                      <li><a href="export.htm#backup_database_tools_shell_mysqldump">mysqldump</a></li>\n';
doc_toc += '                      <li><a href="export.htm#backup_database_tools_shell_mysqlhotcopy">mysqlhotcopy</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="export.htm#backup_database_after">After the database backup</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="export.htm#export">Exporting</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="export.htm#export_scope">Scope</a></li>\n';
doc_toc += '              <li><a href="export.htm#export_usage">Usage</a></li>\n';
doc_toc += '              <li><a href="export.htm#export_preparations">Preparations</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="watermarking.htm#watermark">Watermarking</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="watermarking.htm#watermark_alternatives">Alternatives</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="watermarking.htm#watermark_alternatives_no_right_click">Turning the context menu off</a></li>\n';
doc_toc += '              <li><a href="watermarking.htm#watermark_alternatives_registered_only">Only display your precious content to legitimate viewers</a></li>\n';
doc_toc += '              <li><a href="watermarking.htm#watermark_alternatives_overlay">Display on overlay</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="watermarking.htm#watermark_client_sided">Client-sided watermarking</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="uploading.htm">Uploading</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="uploading_batch-add.htm#batch_add_pics">Uploading pics by FTP / Batch-Add Pictures</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#batch_add_pics_what">What batch-add does</a></li>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#batch_add_pics_how"></a></li>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#">How batch-add works</a></li>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#batch_add_common_mistakes">Common mistakes</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_common_mistakes_doesnt_work">Batch-add does not work as expected</a></li>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_common_mistakes_broken_files">Files appear to be broken</a></li>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_common_mistakes_rename">Do not rename</a></li>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_common_mistakes_delete">Do not delete</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#batch_add_sort">Sorting</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_sort_capitalization">Capitalization matters</a></li>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_sort_numbers">Computers see numbers differently</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="uploading_http.htm#upload_http">Uploading by HTTP</a></li>\n';
doc_toc += '      <li><a href="uploading_xp-publisher.htm#xp">Windows XP Web Publishing Wizard</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_requirements">Requirements</a></li>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_setup">Setup</a></li>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_upload">Uploading pictures</a></li>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_upload">File structure</a></li>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_remove">Removal/Uninstall</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upload_troubleshooting.htm#upload_trouble">Upload troubleshooting</a>\n';
doc_toc += '         <ul>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_trouble_permission">Permissions</a></li>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_trouble_enable_settings">Enable troubleshooting settings</a></li>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_support">Asking for support on upload issues</a>\n';
doc_toc += '             <ul>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_support_step-by-step">Step-by-step guide when asking for support</a>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_support_example">Example support request</a>\n';
doc_toc += '             </ul>\n';
doc_toc += '           </li>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_error_messages">Error messages</a>\n';
doc_toc += '             <ul>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorCantMovePic"></a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorImpossibleToMove">Impossible to move x to y</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorFailedToOpenDir">failed to open dir: No such file or directory</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#httpPostVars">Undefined variable: HTTP_POST_VARS</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorNoAlbumExisting">Sorry there is no album where you are allowed to upload files</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorAllowedMemorySize">Allowed memory size of X bytes exhausted</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorExecDisabled">Exec() has been disabled</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorNotAGdExtension">Not a GD extension</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#imagemagick127">Error executing ImageMagick - Return value 127</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#no_gd_support">PHP running on your server does not support the GD image library</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#no_file_uploaded">No file was uploaded ! If you have really selected a file to upload, check that the server allows file uploads</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#destination_not_writable">Destination directory x is not writable by the script</a></li>\n';
doc_toc += '             </ul>\n';
doc_toc += '           </li>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_trouble_server-sided_restrictions">Server-sided restrictions</a>\n';
doc_toc += '             <ul>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_trouble_server-sided_restrictions_check">Things to check</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_trouble_methods">Upload mechanisms/methods</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_trouble_memory_usage">Memory usage during resizing</a></li>\n';
doc_toc += '             </ul>\n';
doc_toc += '           </li>\n';
doc_toc += '         </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="comments.htm">Comments</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="comments.htm#comments_allow">Allowing comments</a></li>\n';
doc_toc += '      <li><a href="comments.htm#comments_options">Comments options</a></li>\n';
doc_toc += '      <li><a href="comments.htm#comments_options_spam">Spam issues</a></li>\n';
doc_toc += '      <li><a href="comments.htm#comments_review">Reviewing Comments</a></li>\n';
doc_toc += '      <li><a href="comments.htm#comments_individual">Individual Comments</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="bridging.htm">Bridging</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_bridge_purpose">What bridging does</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_bridge_start">Available bridge files</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_prerequisites_start">Pre-requistes</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_cookie_start">Authentication by cookie</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_standalone_start">Standalone version first</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_users_start">Coppermine users, groups and pics uploaded by users are lost when integrating</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_backup_start">Backup</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_steps_start">Integration steps</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_start">Using the bridge manager</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_app_start">Choose application to bridge coppermine with</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_path_start">Path(s) used by your bridge app</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_specific_start">Bridge-app-specific settings</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_enable_start">Enable/disable bridging</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="bridging.htm#bridge_manager_recover_start">Recover from failed bridging</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_steps_sync_start">Synchronising the bridge app groups with Coppermine\'s groups</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_support_start">Bridging support</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_config_options_start">Some config options get disabled</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_files_start">Bridging files</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_bridge_file_creating_start">Creating a custom bridge file</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_philosophy_start">Bridging philosophy</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_individual_bridge_issues_start">Individual bridge issues</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_subdomain">Subdomain issues</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="dev.htm">Developer documentation</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="dev_coding.htm">Coding guidelines</a></li>\n';
doc_toc += '      <li><a href="dev_files.htm">Adding/renaming/removing files</a></li>\n';
doc_toc += '      <li><a href="dev_superglobals.htm">Sanitization of Superglobals using Inspekt</a></li>\n';
doc_toc += '      <li><a href="dev_javascript.htm">Javascript in Coppermine</a></li>\n';
doc_toc += '      <li><a href="dev_plugins.htm">Plugin Writing for Coppermine</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_plugin_api.htm">Plugins tutorial, API description</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_overview">An Overview of the Coppermine Plugin API</a>\n';
doc_toc += '                <ul class="level5">\n';
doc_toc += '                    <li><a href="dev_plugin_api.htm#plugin_api_overview_intro">Introduction</a></li>\n';
doc_toc += '                    <li><a href="dev_plugin_api.htm#plugin_api_overview_who">Intended Audience</a></li>\n';
doc_toc += '                    <li><a href="dev_plugin_api.htm#plugin_api_overview_skills">Required Skills &amp; Knowledge</a></li>\n';
doc_toc += '                    <li><a href="dev_plugin_api.htm#plugin_api_overview_tools">Recommended Software &amp; Support Forums</a></li>\n';
doc_toc += '                    <li><a href="dev_plugin_api.htm#plugin_api_overview_doc">Structure of this Document</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_tutorial">"Hello, world" Plugin Tutorial</a>\n';
doc_toc += '                <ul class="level5">\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_first">My First Plugin</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_installconfig">Installation, Configuration, and Clean-Up</a>\n';
doc_toc += '                    <ul class="level5">\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_installsimple">Installation with Simple Configuration</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_install">Installation with Configuration Parameters</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_config">Configuration during Operation</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_cleanup">Uninstallation &amp; Clean-Up</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>  \n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_linking">Linking to Custom Plugin Scripts</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_button">Adding a Button to Coppermine</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_lang">Multi-language Support</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_js">Adding JavaScript to plugins</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_distrib">Distributing Your Plugin</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_wherenext">Where to Go from Here</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_hooks">Plugin Hooks</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_plugin_class">Plugin Class Properties &amp; Methods</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_globals">Global Variables &amp; Constants</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugin_hooks.htm">Reference list of plugin hooks </a>\n';
doc_toc += '            <ul class="level5">\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_choosing">Choosing Plugin Hooks</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_finding">Finding Plugin Hooks</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_using">Using Plugin Hooks</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_filename">Plugin Hooks by Script Filename</a>\n';
doc_toc += '                <ul class="level6">\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_ind_php">Script: index.php</a>\n';
doc_toc += '                    <ul class="level7">\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_ind_anyc">Filter: \'anycontent\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_ind_ucp">Filter: \'user_caption_params\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_ind_pb">Filter: \'plugin_block\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_di_php">Script: displayimage.php</a>\n';
doc_toc += '                    <ul class="level7">\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_di_fi">Filter: \'file_info\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_di_pbc">Filter: \'post_breadcrumb\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_thumb_php">Script: thumbnails.php</a>\n';
doc_toc += '                    <ul class="level7">\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_thumb_pbc">Filter: \'post_breadcrumb\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_php">Script: functions.inc.php</a>\n';
doc_toc += '                    <ul class="level7">\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_ghgf">Filters: \'gallery_header\' and \'gallery_footer\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_td">Filter: \'thumb_data\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_th">Filter: \'template_html\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_pm">Filter: \'page_meta\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_tc">Filters: \'thumb_caption\' and all derivatives</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_th_php">Script: themes.inc.php</a>\n';
doc_toc += '                    <ul class="level7">\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_th_fd">Filter: \'file_data\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_um_php">Script: usermgr.php</a>\n';
doc_toc += '                    <ul class="level7">\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_um_umh">Filter: \'usermgr_header\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_um_umf">Filter: \'usermgr_footer\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_pm_php">Script: pluginmgr.php</a>\n';
doc_toc += '                    <ul class="level7">\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_pm_pcon">Filter: \'plugin_configure\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_pm_pcl">Filter: \'plugin_cleanup\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_php">Script: plugin_api.inc.php</a>\n';
doc_toc += '                    <ul class="level7">\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_ph">Filter: \'page_html\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_pe">Filter: \'page_end\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_pi">Filter: \'plugin_install\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_pu">Filter: \'plugin_uninstall\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_pw">Filter: \'plugin_wakeup\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_ps">Filter: \'plugin_sleep\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_init_php">Script: init.inc.php</a>\n';
doc_toc += '                    <ul class="level9">\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_init_ps">Filter: \'page_start\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_picm_php">Script: picmgmt.inc.php</a>\n';
doc_toc += '                    <ul class="level9">\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_picm_afd">Filter: \'add_file_data\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_alphabetically">Plugin Hooks Alphabetically</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_hooktype">Plugin Hooks by Hook Type</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hook_examples">Plugin Hook Examples</a>\n';
doc_toc += '                <ul class="level6">\n';
doc_toc += '                    <li><a href="dev_plugin_hooks.htm#plugin_hook_example_upload_method">Adding an upload method</a></li>\n';
doc_toc += '                    <li><a href="dev_plugin_hooks.htm#plugin_hook_example_theme_display_thumbnails">Add tags for thumbnails display</a></li>\n';
doc_toc += '                </ul></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_documentation.htm">Editing the documentation</a></li>\n';
doc_toc += '      <li><a href="dev_subversion.htm">Subversion</a></li>\n';
doc_toc += '      <li><a href="dev_config.htm">Adding config options</a></li>\n';
doc_toc += '      <li><a href="dev_vars.htm#vars_constants">Variables &amp; Constants</a>\n';
doc_toc += '        <ul class="level5">\n';
doc_toc += '          <li><a href="dev_vars.htm#vars_constants_system">System Global Variables</a></li>\n';
doc_toc += '          <li><a href="dev_vars.htm#vars_constants_constants">Coppermine Constants</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_versioncheck.htm">Versioncheck</a></li>\n';
doc_toc += '      <li><a href="dev_update.htm">Updating</a></li>\n';
doc_toc += '      <li><a href="dev_tools.htm">Tools recommended by the devs</a>\n';
doc_toc += '          <ul class="level4">\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_database">Database manipulation</a></li>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_ftp_client">FTP clients</a></li>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_web_development">Web development</a></li>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_editor">Text editors</a></li>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_picture_editors">Picture Editors</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_database.htm">Database schema</a>\n';
doc_toc += '          <ul class="level4">\n';
doc_toc += '              <li><a href="dev_database.htm#db_config_file">Configuration file</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_reference within_code">Database reference within coppermine code</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_albums">cpg15x_albums</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_banned">cpg15x_banned</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_bridge">cpg15x_bridge</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_categories">cpg15x_categories</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_categorymap">cpg15x_categorymap</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_comments">cpg15x_comments</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_config">cpg15x_config</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_dict">cpg15x_dict</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_ecards">cpg15x_ecards</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_exif">cpg15x_exif</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_favpics">cpg15x_favpics</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_filetypes">cpg15x_filetypes</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_hit_stats">cpg15x_hit_stats</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_languages">cpg15x_languages</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_pictures">cpg15x_pictures</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_plugins">cpg15x_plugins</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_sessions">cpg15x_sessions</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_temp_messages">cpg15x_temp_messages</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_usergroups">cpg15x_usergroups</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_users">cpg15x_users</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_votes">cpg15x_votes</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_vote_stats">cpg15x_vote_stats</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '</ul>\n';
doc_toc += '</div>\n';
$('#toc').replaceWith('<div id="toc">' + doc_toc + '</div>');
}



function cpgDocHeader() {
	// Only display the header if the docs are not included
	if (getUrlParameters('hide_nav') == 1) {
		return;
	}
	$('#docheader').text('Coppermine Photo Gallery v1.5.1: Documentation and Manual');
	$('#docheader').after('<br clear="all" />\n<a name="top"></a>');
	$('#docheader').before('<img src="../images/coppermine-logo.png" alt="Coppermine Photo Gallery - Your Online Photo Gallery" align="left" />\n');
}

function cpgDocSearch() {
	// Only display the header if the docs are not included
	if (getUrlParameters('hide_nav') == 1) {
		return;
	}
	var doc_search = '';
	doc_search += '  <div id="doc_search" style="display:none;">\n';
	doc_search += '    <form action="http://www.google.com/cse" id="cse-search-box">\n';
	doc_search += '      <input type="hidden" name="cx" value="009353514429642786404:1fg_c1k1td8" />\n';
	doc_search += '      <input type="text" name="q" size="25" />\n';
	doc_search += '      <input type="submit" name="sa" value="search docs" style="font-size:9px;" />\n';
	doc_search += '    </form>\n';
	doc_search += '    <script type="text/javascript" src="http://www.google.com/coop/cse/brand?form=cse-search-box&lang=en"></script>\n';
	doc_search += '  </div>\n';
	$('#toc').append(doc_search);
}

function cpgDocFooter() {
  var overall_doc_footer = '';
  overall_doc_footer += '</div>';
  overall_doc_footer += '<div align="right">';
  overall_doc_footer += '<a href="#top">Back to Top</a>';
  overall_doc_footer += '</div>';
  $('#doc_footer').append(overall_doc_footer);
}



function dateRevision() {
  // strip the unneeded data from last_changed and revision fields
  var lastChangeDate = $('#doc_last_changed').text();
  var lastChangeDate = lastChangeDate.replace('$', '');
  var lastChangeDate = lastChangeDate.replace('$', '');
  var lastChangeDate = lastChangeDate.replace('LastChangedDate: ', '');
  var lastChangeDate = lastChangeDate.replace(/Date: /g, '');
  $('#doc_last_changed').text('About this document: ' + 'last changed on ' + lastChangeDate);

  var revisionNumber = $('#doc_revision').text();
  var revisionNumber = revisionNumber.replace('$', '');
  var revisionNumber = revisionNumber.replace('$', '');
  var revisionNumber = revisionNumber.replace(/Revision: /g, '');
  $('#doc_revision').text(', SVN revision ' + revisionNumber);
}

function getUrlParameters(name)
{
  // Taken from http://www.netlobo.com/url_query_string_javascript.html
  name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  var regexS = "[\\?&]"+name+"=([^&#]*)";
  var regex = new RegExp(regexS);
  var results = regex.exec(window.location.href);
  if(results == null) {
    return '';
  } else {
    return results[1];
  }
}

function cpgDocTranslationWarning() {
  $('#doc_en_only').replaceWith('');
  $('#doc_en_partial').replaceWith('');
}

$(document).ready(function()
{
	var $_GET = {};
	document.location.search.replace(/\??(?:([^=]+)=([^&]*)&?)/g, function () {
		function decode(s) {
			return decodeURIComponent(s).replace(/\+/g, " ");
		}
		$_GET[decode(arguments[1])] = decode(arguments[2]);
	});
	//hide all elements with class detail_body
	$(".detail_body").hide();
	if ($_GET["expand_all"] == 1) { // Show all details and get rid of the details toggle if the GET parameter expand_all is set
		$('.detail_body').show();
		$('.detail_head_collapsed').replaceWith('');
	}
	//toggle the component with class detail_body
	$(".detail_head_collapsed").click(function()
	{
		$(this).toggleClass("detail_head_expanded").next(".detail_body").slideToggle(600);
	});
	$(".detail_expand_all").click(function()
	{
		$(".detail_body").slideDown(1200);
		$(".detail_head_collapsed").toggleClass("detail_head_expanded");
		$(".detail_expand_all").hide();
		$(".detail_collapse_all").show();

	});
	$(".detail_collapse_all").click(function()
	{
		$(".detail_body").slideUp(1200);
		$(".detail_head_collapsed").toggleClass("detail_head_expanded");
		$(".detail_expand_all").show();
		$(".detail_collapse_all").hide();

	});
	$(".detail_toggle_all").click(function()
	{
		$(".detail_body").slideToggle(600);
		$(".detail_head_collapsed").toggleClass("detail_head_expanded");
	});
	cpgDocHeader();
	cpgDocTranslationWarning();
	cpgDocToc();
	$("#tree").treeview({
        collapsed: true,
        unique: true,
        animated: "slow",
        persist: "location"
    });
	cpgDocSearch();
	cpgDocFooter();
	dateRevision();
    $("a.nolink").click(function(){
      return false;
    });
    // Fade the toc in if it is needed
	$("#toc").bind("mouseenter",function(){
		$("#toc_collapsed").hide();
		$("#toc_expanded").fadeIn('slow');
		$("#doc_search").show();
	});
	// Fade the toc out if it isn't used
	$("#toc").bind("mouseleave",function(){
		$("#toc_expanded").fadeOut('slow');
		$("#toc_collapsed").show();
		$("#doc_search").hide();
	});
	
});