<?php
/**************************************************
  Coppermine Plugin - Hello, World
  *************************************************
  Copyright (c) 2008 <-InsertNameHere->
  *************************************************
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
***************************************************/

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

// Add install & configure actions
$thisplugin->add_action('plugin_install','hello_world_install');
$thisplugin->add_action('plugin_configure','hello_world_configure');

// Add a filter for the gallery header
$thisplugin->add_filter('gallery_header','hello_world_header');

// Function to modify the gallery header
function hello_world_header($html) {
    $html = '<p style="color:red"><b>Hello, world.</b> (tutorial 2.2.1)</p>'
            .$html;
    return $html;
}

// Install the plugin
function hello_world_install() {
    $superCage = Inspekt::makeSuperCage();
    $submit_code = '';
    if ($superCage->post->keyExists('submit')) {
      $submit_code = $superCage->post->getEscaped('submit');
    }
    if (!$submit_code) {
        return 1;  // configure function has not been called yet, so return error code '1'
    } elseif ($submit_code == 'Yes') {
        return true;  // configure function has been called, so install the plugin
    } elseif ($submit_code == 'No')  {
        header("Location: pluginmgr.php\n\n");  // go back to plugin manager without installing the plugin
        exit(0);
    } elseif ($submit_code == 'Simulate critical error') {
        return false;  // simulate a critical error by returning false
    } else {
        return 2;  // user is not sure whether to install yet, so return error code '2'
    }
}

// Configure function: displays the configuration form
function hello_world_configure($action_code) {
    global $thisplugin;
    $still = '';
    if ($action_code == 2) {
        echo 'Ok, I hope you\'ve had enough time to decide now.<br />';
        $still = 'still ';
    }
    if (($action_code == 1) || ($action_code == 2)) {
        echo <<< EOT
            <h3>Do you want to install plugin <b>{$thisplugin->name}</b>?</h3>
            <form action="{$_SERVER['REQUEST_URI']}" method="post">
            <input type="submit" name="submit" value="Yes" />
            <input type="submit" name="submit" value="No" />
            <input type="submit" name="submit" value="I'm {$still}not sure" />
            <input type="submit" name="submit" value="Simulate critical error" />
            </form>
EOT;
    }
}
?>
