<?php
	// This PHP guestbook script was written by Thomas Hettenhausen in 2003.
	// http://flatphpbook.sourceforge.net
	// http://www.hettenhausen.net
	//
	// This software is free software; you can redistribute it and/or modify
	// it under the terms of the GNU General Public License as published by
	// the Free Software Foundation; either version 2 of the License, or
	// (at your option) any later version.
	// 
	// This program is distributed in the hope that it will be useful,
	// but WITHOUT ANY WARRANTY; without even the implied warranty of
	// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	// GNU General Public License for more details.
	// 
	// You should have received a copy of the GNU General Public License
	// along with this program; if not, write to the Free Software
	// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


	// starting the session for the admin login
	session_start();
	header("Cache-control: private"); // IE 6 Fix, needed for using the "Back" button with sessions and forms

	// global variables, such as filenames and settings
	$version = "0.9.3";
	$gbname = "flatPHPBook"; // the name of the guestbook, this is used in the titles of the various pages - change to your liking
	$guestbookfile = "guestbook.db"; // filename of the guestbook itself (default: guestbook.db)
	$stylesheet = "guestbook.css"; // filename of the stylesheet
	$javaScriptFile = "guestbook.js"; // file containing the JavaScript functions
	$emailIcon = "email.png"; // the little image used to represent the email address, change this if you have another one (does not have to be PNG)
	$homepageIcon = "homepage.png"; // dito, for the homepage
	$delimiter = "::"; // the special character used to tokenize the parts of a post in the database file
	$displayNewestFirst = 1; // sorting order for display of entries, 1 for newest first, 0 for oldest first
	$refreshWaitingTime = 5; // time to wait in seconds before a refresh on the Thanks-for-posting page
	$showtotalnumber = 1; // if 1, displays the total number of posts in guestbook above the posts
	$adminusername = "admin"; // the administrator username who can delete posts - YOU REALLY SHOULD CHANGE THIS
	$adminpassword = "adminpw" ; // the corresponding passwort - YOU REALLY SHOULD CHANGE THIS
	$entriesperpage = 10 ; // set to 0 for all entries on a single page, or else to how many you want on one page
	$adminmode = 0; // set adminmode to 0 for security reasons
	$separateViewFromSign = 0; // if set to 1 (not 0), the form to sign the guestbook is displayed on another page and not together with the old entries

	///////////////////////////////////////////////////////////////////////////////////////////
	// functions declarations
	//
	
	// removes HTML tags and the delimiters used in the db file from the input
	function safeHTML($input, $delimiter)	{
		$input = strip_tags($input);
		$input = htmlspecialchars(stripslashes($input), ENT_QUOTES);
		$input = preg_replace("/(\015\012)|(\015)|(\012)/", "&nbsp;<br />", $input); // exchanges CR, LF and CRLF with <br />
		$input = ereg_replace($delimiter, "[[delimiter]]", $input);
		return $input;
	}

	// here the BBcode for formatting, links and images is replaced with the real HTML tags
	// together with any incidentally used delimiter in the database file (because a visitor wanted to use it in his text) -
	// they were exchanged by the safeHTML() function and are now reinserted for display
	function recreateUserInput($input, $delimiter)	{
		$input = str_replace("[[delimiter]]", $delimiter, $input);		// put the real delimiter back into the string
		$input = preg_replace('/(\[b\])(.+?)(\[\/b\])/i', '<b>\\2</b>',  $input);
		$input = preg_replace('/(\[i\])(.+?)(\[\/i\])/i', '<i>\\2</i>', $input);
		$input = preg_replace('/(\[u\])(.+?)(\[\/u\])/i', "<u>\\2</u>", $input);
		$input = preg_replace('/(\[pre\])(.+?)(\[\/pre\])/i', "<pre>\\2</pre>", $input);
		$input = preg_replace('/(\[img\])(.+?)(\[\/img\])/i', '<img src="\\2" alt="\\2">', $input);
		$input = preg_replace('/(\[color=(.+?)\])(.+?)(\[\/color\])/i', '<font color=\\2>\\3</font>', $input);
		$input = preg_replace('/(\[email\])(.+?)(\[\/email\])/i', "<a href=\"mailto:\\2\">\\2 </a>", $input);
		$input = preg_replace('/(\[email=(.+?)\])(.+?)(\[\/email\])/i', "<a href=\"mailto:\\2\">\\3</a>", $input);
		$input = preg_replace('/\[url=http\:\/\//i', '[url=', $input);
		$input = preg_replace('/(\[url\])(.+?)(\[\/url\])/i', "<a href=\"http://\\2\" target=\"_blank\">\\2</a>", $input);
		$input = preg_replace('/(\[url=\])(.+?)(\[\/url\])/i', "<a href=\"http://\\2\" target=\"_blank\">\\2</a>", $input);
		$input = preg_replace('/(\[url=(.+?)\])(.+?)(\[\/url\])/i', "<a href=\"http://\\2\" target=\"_blank\">\\3</a>", $input);
		$input = str_replace('\\&quot;', '&quot;', $input);
		return $input;
	}

	// displays the input fields for a new post: name, email, you name it
	// made into a function because used twice in the script, saves place
	function displayInputForm($Nickname, $Emailaddress, $Homepage) {
		if (isset($_POST["Message"]))	{
			$messageDisplay = stripslashes($_POST["Message"]);
		}
		else	{
			$messageDisplay = "";
		}
		echo "\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t<form name='inputform' method='post' action='" . $_SERVER['PHP_SELF'] . "'>\n";
		echo "\t\t\t\t\t\t\t<table border='0'>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td>Your name:<br>";
		echo "<input type='text' name='NickName' size='26' value='" . $Nickname . "' /></td>\n";
		echo "\t\t\t\t\t\t\t\t\t<td>Your email:<br>";
		echo "<input type='text' name='EmailAddress' size='36' value='" . $Emailaddress . "' /></td>";
		echo "\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td colspan='2'>Your homepage:<br>";
		echo "<input type='text' name='Homepage' size='67' value='" . $Homepage . "' /><br>";
		echo "\t\t\t</td></tr><tr><td colspan='2'>Your comment:<br>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<textarea rows='5' cols='50' id='messagebox' name='Message'>" . $messageDisplay . "</textarea>\n\t\t\t\t\t\t\t\t\t\t<br>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' accesskey='h' value='www' onClick='addHyperlink()' onMouseOver='helpHyperlink()' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' accesskey='e' value='@' onClick='addEmail()' onMouseOver='helpEmail()' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' accesskey='b' value='bold' style='font-weight: bold;' onClick='addBold()' onMouseOver='helpBold()' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' accesskey='i' value='italic' style='font-style: italic;' onClick='addItalics()' onMouseOver='helpItalics()' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' accesskey='u' value='underline' style='text-decoration: underline;' onClick='addUnderline()' onMouseOver='helpUnderline()' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<select accesskey='c' name='colorselect' size='1' onChange='addColor()' onMouseOver='helpColor()' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t<option>color</option><option value='#ff0000'>red</option><option value='#ff8800'>orange</option><option value='#ffff00'>yellow</option>\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t<option value='#884400'>brown</option><option value='#00ff00'>green</option><option value='#00ffff'>turquoise</option><option value='#0000ff'>blue</option>\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t<option value='#8800ff'>violet</option><option value='#ff00ff'>pink</option><option value='#ffffff'>white</option>\n\t\t\t\t\t\t\t\t\t\t</select>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' value='Image' onClick='addImage()' onMouseOver='helpImage()' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' value='code()' style='font-family: monospaced;' onClick='addCode()' onMouseOver='helpCode()' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<div id='jsHelpLine' class='jsHelpLine'>&nbsp;<br></div>\n";
		echo "\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td colspan='2'>\n\t\t\t\t\t\t\t\t\t\t<div align='left'>\n\t\t\t\t\t\t\t\t\t\t\t<input type='submit' name='submit' value='Submit Post' />&nbsp;\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t<input type='submit' name='preview' value='Preview Post'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</form>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t</table>";
	}


	// called when displaying posts on more than one page
	// adds the page navigation that looks like "< [1] 2 3 >"
	function displayPostNavigation($numberofposts, $offset)
	{
		global $entriesperpage;
		if (($numberofposts > 0) && ($numberofposts > $entriesperpage))	{
			$numberofpages = ceil($numberofposts / $entriesperpage); // one post more than entries per page -> new page
			echo "\n\t\t<!-- navigation between the pages -->";
			echo "\n\t\t<div style='text-align: center; width: 100%;'><p style='font-weight: bold;'>";
			echo "\n\t\t\t<a href='" . $_SERVER['PHP_SELF'] . "?offset=" . max(($offset - $entriesperpage), 0) . "'>&laquo;</a>";
			for ($thispage = 1; $thispage <= $numberofpages; $thispage++)  {
				if (($offset >= ($entriesperpage * ($thispage - 1))) && ($offset < ($entriesperpage * $thispage))) {
					echo "&nbsp;[" . $thispage . "]";
				}
				else {
					echo "&nbsp;<a href='" . $_SERVER['PHP_SELF'] . "?offset=" . ($entriesperpage * ($thispage - 1)) . "'>" . $thispage . "</a>";
				}
			}
			echo "&nbsp;<a href='" . $_SERVER['PHP_SELF'] . "?offset=" . min(($offset + $entriesperpage), $numberofposts - 1) . "'>&raquo;</a>\n";
			echo "\t\t</p></div>\n\n";
		}
	}
	
	// displays the recurring html header that is the same on every page (page title, style sheet, JavaScript, meta tags...)
	function displayHTMLHeader()	{
		global  $gbname, $stylesheet, $javaScriptFile;
		echo "<html>\n\t<head>\n\t\n\t\t<title>" . $gbname . "</title>\n\t\t<meta name='Author' content='Thomas Hettenhausen'>\n";
		echo "\t\t<link rel='stylesheet' type='text/css' href='" . $stylesheet . "'>\n";
		echo "\t\t<script language='JavaScript' src='" . $javaScriptFile . "'></script>\n\t</head>\n\t<body>\n";
	}


	///////////////////////////////////////////////////////////////////////////////////////////
	// MAIN body of the script
	//

	// FIRST all the special cases: previewing, submitting, logging in as admin

	// previewing a post
	if (isset($_POST["preview"]))	{
		// same requirements as if just submitting
		if (($_POST["NickName"] != "") && ($_POST["Message"] != ""))	{
			// preparing the data to be written to the guestbook
			$currentDate = date("Y-m-d");
			$currentTime = date("H:i:s");
			
			if (($_POST["Homepage"] == "http://") || ($_POST["Homepage"]) == "")	{
				$Homepage = "";
			}
			else	{
				$Homepage = safeHTML($_POST["Homepage"], $delimiter);
			}

			$Nickname = safeHTML($_POST["NickName"], $delimiter);
			$Emailaddress = safeHTML($_POST["EmailAddress"], $delimiter);
			$messagestring = safeHTML($_POST["Message"], $delimiter);
			
			// beginning to output the HTML page
			displayHTMLHeader();
			
			// displaying the single entry with the new data
			echo "\t\t<h1>" . $gbname . "</h1>\n\t\t<table class='gbdisplay' cellpadding='0' cellspacing='0'>\n";
			echo "\t\t\t<tr class='layouttr'>\n\t\t\t\t<td class='posttopleft' valign='top'>";
			echo "\n\t\t\t\t\t<span class='emphasis'>0. " . $Nickname . "</span>\n\t\t\t\t</td>\n";
			echo "\t\t\t\t<td class='posttopright'  valign='top'>\n\t\t\t\t\t<span class='emphasis'>" . $currentDate . ", " . $currentTime . "</span>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n";
			echo "\t\t\t<tr>\n\t\t\t\t<td class='postbottomleft'  valign='top'>";
			if ($Emailaddress != "")	{
				echo " <a href='mailto:" . $Emailaddress . "'><img src='" . $emailIcon . "' alt='email' border=''></a>&nbsp;";
				if ($Homepage == "")	{
					echo "\n\t\t\t\t<br>";
				}
			}
			if ($Homepage != "")	{
				if (!(preg_match("/^http:\/\//", $Homepage)))
					{$currentHomepage = "http://" . $Homepage;}
					echo "<a href='" . $currentHomepage . "'><img src='" . $homepageIcon . "' alt='homepage' border='0'></a><br>";
			}
			echo "</td>\n\t\t\t\t<td class='postbottomright' valign='top'>";
			echo "\n\t\t\t\t\t" . recreateUserInput($messagestring, $delimiter) . "\t\t\t\t</td>\n\t\t\t</tr>\n";
			echo "\t\t</table>\n\t\t<p>&nbsp;</p>\n";
			// displaying the form fields with the data inserted, too
			echo "\t\t<div class='gbinput'>\n\t\t\t";
			displayInputForm($Nickname, $Emailaddress, $Homepage);
			echo "\n\t\t</div>\n\t</body>\n</html>";
			die();
		}
		else	{
			// If no entry was made display an error message and go back to the guestbook
			// double time because user might want to press "Back" to re-submit without filling in everything again
			header( 'refresh: ' . $refreshWaitingTime * 2 . '; url= '. $_SERVER["PHP_SELF"] );
			echo "<html>\n\t<head>\n\t\n\t\t<title>" . $gbname . "</title>\n\t\t<meta name='Author' content='Thomas Hettenhausen'>\n";
			echo "\t\t<link rel='stylesheet' type='text/css' href='" . $stylesheet . "'>\n\t</head>\n\t<body>\n";
			echo "\t\t<div class='gbheader' align='center'><h1>" . $gbname . "</h1></div>\n";
			echo "\t\t<div class='gbinput'>\n";
			echo "\t\t\t<p>Sorry - at least a name and a message have to be entered!</p>\n";
			echo "\t\t\t<p>You will be taken back to the guestbook in " . $refreshWaitingTime * 2 . " seconds.</p>\n";
			echo "\t\t\t<a href='" . $_SERVER["PHP_SELF"] . "'>If you do not want to wait any longer, or your browser does not support auto-forwarding, click here.</a>\n\t\t</div>";
			echo "\t\t<div style='text-align: center; margin-top: 10px;'><a href='http://www.hettenhausen.net/flatPHPbook/' style='font-size: 9px;'>flatPHPbook by Thomas Hettenhausen</a></div>\n";
			echo "\n\t</body>\n</html>";
			die();
		}
		die;
	}

	// new post is being submitted
	if (isset($_POST["submit"]))
	{
		// minimum requirements for posting are a name and a message, would not make much sense without these
		// at least I do not want anonymous posts, might change this later for flexibilitys sake
		if (($_POST["NickName"] != "") && ($_POST["Message"] != ""))	{
			// preparing the data to be written to the guestbook
			$currentDate = date("Y-m-d");
			$currentTime = date("H:i:s");

			if (($_POST["Homepage"] == "http://") || ($_POST["Homepage"]) == "")	{
				$Homepage = "";
			}
			else	{
				$Homepage = safeHTML($_POST["Homepage"], $delimiter);
			}

			$Nickname = safeHTML($_POST["NickName"], $delimiter);
			$Emailaddress = safeHTML($_POST["EmailAddress"], $delimiter);
			$messagestring = safeHTML($_POST["Message"], $delimiter);

			$newguestbookline = $Nickname . $delimiter . $Emailaddress . $delimiter . $Homepage . $delimiter . date("Y-m-d") . $delimiter . date("H:i:s") . $delimiter . $_SERVER['REMOTE_ADDR'] . $delimiter . $messagestring . "\n";

			// adding the stuff to the guestbook file (simply adding a new line at the end due to design of the data structure)
			$bookinputstream = fopen($guestbookfile, "a");
			fwrite($bookinputstream, $newguestbookline);
			fclose($bookinputstream);

			// display a "Thank you" page and then go back to the guestbook
			header( 'refresh: ' . $refreshWaitingTime . '; url= '. $_SERVER["PHP_SELF"] );
			echo "<html>\n\t<head>\n\t\n\t\t<title>" . $gbname . "</title>\n\t\t<meta name='Author' content='Thomas Hettenhausen'>\n";
			echo "\t\t<link rel='stylesheet' type='text/css' href='" . $stylesheet . "'>\n\t</head>\n\t<body>\n";
			echo "\t\t<h1>" . $gbname . "</h1>\n";
			echo "\t\t<div class='gbinput'>\n";
			echo "\t\t\t<p>Thank you for your post!</p>\n";
			echo "\t\t\t<p>You will be taken back to the guestbook in " . $refreshWaitingTime . " seconds.</p>\n";
			echo "\t\t\t<a href='" . $_SERVER["PHP_SELF"] . "'>If you do not want to wait any longer, or your browser does not support auto-forwarding, click here.</a>\n\t\t</div>";
			echo "\t\t<div style='text-align: center; margin-top: 10px;'><a href='http://www.hettenhausen.net/flatPHPbook/' style='font-size: 9px;'>flatPHPbook by Thomas Hettenhausen</a></div>\n";
			echo "\n\t</body>\n</html>";
			die();
		}
		else	{
			// If no entry was made display an error message and go back to the guestbook
			// double time because user might want to press "Back" to re-submit without filling in everything again
			header( 'refresh: ' . $refreshWaitingTime * 2 . '; url= '. $_SERVER["PHP_SELF"] );
			echo "<html>\n\t<head>\n\t\n\t\t<title>" . $gbname . "</title>\n\t\t<meta name='Author' content='Thomas Hettenhausen'>\n";
			echo "\t\t<link rel='stylesheet' type='text/css' href='" . $stylesheet . "'>\n\t</head>\n\t<body>\n";
			echo "\t\t<h1>" . $gbname . "</h1>\n";
			echo "\t\t<div class='gbinput'>\n";
			echo "\t\t\t<p>Sorry - at least a name and a message have to be entered!</p>\n";
			echo "\t\t\t<p>You will be taken back to the guestbook in " . $refreshWaitingTime * 2 . " seconds.</p>\n";
			echo "\t\t\t<a href='" . $_SERVER["PHP_SELF"] . "'>If you do not want to wait any longer, or your browser does not support auto-forwarding, click here.</a>\n\t\t</div>";
			echo "\t\t<div style='text-align: center; margin-top: 10px;'><a href='http://www.hettenhausen.net/flatPHPbook/' style='font-size: 9px;'>flatPHPbook by Thomas Hettenhausen</a></div>\n";
			echo "\n\t</body>\n</html>";
			die();
		}
	}

	// deleting an entry (only allow POST so nobody can fake the action via URLs)
	if (isset($_POST["delete"]))	{
		// obviously, a post is to be deleted

		// need to load the database file, build an array, remove the corresponding field, and write the array back to the database file
		$content = file($guestbookfile);
		$posttobedeleted = count($content) - $_POST["whichpost"] - 1;
		$gbentry = split($delimiter, $content[$posttobedeleted]);	// preparing the double-checking: need to read the posttime filed from the database later on
		
		// double-checking: the post number and time the post was made have to be correct
		// if someone posts between clicking the delete button and the reloading of the page
		// the post numbers are screwed - in that case, nothing will be deleted
		if ($_POST["posttime"] == $gbentry[4])	{
			// now, $content is our array, need to remove the appropriate one
			$index_nb_elements = count($content) - 1;
			switch($posttobedeleted)
			{
				case 0:
					$content = array_slice($content, 1);
					break;
				case $index_nb_elements:
					$content = array_slice($content, 0, -1);
					break;
				default:
					$array_start = array_slice($content, 0, $posttobedeleted);
					$array_end = array_slice($content, $posttobedeleted + 1);
					$content = array_merge ($array_start, $array_end);
					break;
			}

			// writing the new array back
			$bookinputstream = fopen($guestbookfile, "w");
			fseek($bookinputstream, 0);
			// $content = implode("\r\n", $content);
			foreach ($content as $gbline)	{
				fwrite($bookinputstream, trim($gbline) . "\n"); }
			fclose($bookinputstream);
		}
	}
	
	// the admin mode login, displaying a form field for entering username and passwort,
	// then directing the user to the admin mode guestbook
	if (isset($_GET["adminlogin"]))
	{
		echo "<html>\n\t<head>\n\t\t<title>" . $gbname . "Admin Mode Login - Guestbook</title>\n\t\t<meta name='Author' content='Thomas Hettenhausen'>\n";
		echo "\t<link rel='stylesheet' type='text/css' href='" . $stylesheet . "'>\n\t</head>\n\t<body>\n";
		echo "\t\t<h1>" . $gbname . " Admin Login</h1>\n";
		echo "\t\t<div class='gbinput'>\n";
		echo "\t\t\t<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>\n";
		echo "\t\t\t\t<table>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>Username:</td>\n\t\t\t\t\t\t<td><input type='text' name='adminuser'></td>\n\t\t\t\t\t</tr>\n";
		echo "\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>Password:</td>\n\t\t\t\t\t\t<td><input type='password' name='adminpass'></td>\n\t\t\t\t\t</tr>\n";
		echo "\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>\n\n\t\t\t\t\t\t\t<input type='submit' name='Login' value='Login'/>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n";
		echo "\t\t\t</form>\n\t\t</div>\n";
		echo "\t\t<div style='text-align: center; margin-top: 10px;'><a href='http://www.hettenhausen.net/flatPHPbook/' style='font-size: 9px;'>flatPHPbook by Thomas Hettenhausen</a></div>\n";
		echo "\t</body>\n</html>";
		die();
	}
	
	// THEN the regular display of the guestbook, even if some special conditions get checked first
	
	// checking if logging into admin mode, setting the appropriate PHP session variables
	if (isset($_POST["Login"]) && ($_POST["adminuser"] == $adminusername) && ($_POST["adminpass"] == $adminpassword))	{
		$adminmode = 1;
		session_register('adminmode');
		$_SESSION['adminmode'] = $adminmode;
	}

	// check if already in admin mode via PHP session
	if ((isset($_SESSION['adminmode'])) && ($_SESSION['adminmode'] == 1))	{
		$adminmode = 1;
	}
	
	// logging out of admin mode and destroying the associated PHP session
	if (isset($_GET["logout"]))	{
		session_unset();
		session_destroy();
		$adminmode = 0;
	}

	// beginning the regular guestbok display
	echo "<html>\n\t<head>\n\t\t<title>" . $gbname . " Main Page</title>\n\t\t<meta name='Author' content='Thomas Hettenhausen'>\n";
	echo "\t\t<link rel='stylesheet' type='text/css' href='" . $stylesheet . "'>\n";
	echo "\t\t<script language='JavaScript' src='guestbook.js'></script>\n";
	echo "\t</head>\n\t<body>\n";
	echo "\t\t<h1>" . $gbname . " Main Page</h1>\n\n";
	echo "\t\t<!-- html input form for guestbook -->\n\t\t<div class='gbinput'>";
	
	// this includes (makes it as if it was really in this page) the content of welcomeMessage.html
	// this is useful for having your own welcome message
	// right now it lists the features of the script - just edit the welcomeMessage.html file
	// or change the following line so it points to another file
	include("./welcomeMessage.html");
	
	// all the "if ((separateViewFromSign == 1) ... etc make sure the right parts are displayed according to the mode:
	// either everything on one page, but no links, or either the form fields or the old entries together with navigation links ("Click to view" or "Click to sign").
	
	if (($separateViewFromSign == 1) && !isset($_GET['signgb']))	{
		echo "<p align='center'><a href='" . $_SERVER['PHP_SELF'] . "?signgb=1'>Click here to sign the guestbook.</a></p>";
	}
	else	{
		echo "<hr width='80%'>";
	}
	
	// calling the function which displays the long form with the input text fields and buttons
	// parameters are empty here, they are used for the preview page so that the fields can be filled with already submitted values
	if ((($separateViewFromSign == 1) && isset($_GET['signgb']) && ($_GET['signgb'] == 1)) || ($separateViewFromSign == 0))	{
		displayInputForm("", "", "");
		if (!($separateViewFromSign == 0))	{
			echo "<p align='center'><a href='" . $_SERVER['PHP_SELF'] . "'>Click here to view the guestbook without signing it.</a></p>";
		}
	}
	echo "</div>\n\t\t<p>&nbsp;</p>";

	if ((($separateViewFromSign == 1) && !isset($_GET['signgb'])) || ($separateViewFromSign == 0))
	{
		// checking if we are displaying posts starting with the first one or if we start somewhere else when using multiple pages
		if (isset($_GET["offset"]))	{
			$offset = $_GET["offset"];
		}
		else	{
			$offset = 0;
		}

		// reading the content of the guestbook file ($guestbookfile) and creating an array ($content) out of it
		//
		// if the file does not exist, create it for further use
		if (!file_exists($guestbookfile))	{
			touch($guestbookfile);
		}
		$content = file($guestbookfile);
		$numberofposts = count($content);

		// displaying the total number of posts in the guestbook if wanted
		if ($showtotalnumber == 1)	{
			echo "\t\t<!-- displaying the total number of posts in the guestbook -->\n";
			echo "\t\t<div class='gbinput'>\n\t\t\t<p style='font-weight: bold; text-align: center;'>\n\t\t\t\tTotal number of posts in this guestbook: " . $numberofposts . "\n\t\t\t</p>\n\t\t</div>\n\t\t<p>&nbsp;</p>\n";
		}

		// if splitting the posts onto several pages, display navigation links
		if ($entriesperpage > 0)	{
			displayPostNavigation($numberofposts, $offset);
		}

		// creating array out of guestbook entry
		//
		// prepare the check whether whole guestbook or current entry is empty (either if it is the last or if there accidentally got an empty line into the database file)
		$gbIsEmpty = "1";

		// order of display is checked: usually you want newest first
		if ($displayNewestFirst == "1")	{
			$content = array_reverse($content);
		}

		echo "\n\t\t<!-- beginning of the display of the guestbook entries -->\n";
		echo "\n\t\t<table class='gbdisplay' cellpadding='0' cellspacing='0'>\n";

		// looping over the posts and displaying the table rows for each one
		for ($postnumber = 0; $postnumber < $numberofposts; $postnumber++)	{
			$gbentryline = $content[$postnumber];

			// the current post might be empty, and then ...
			if (($gbentryline == "") && ($gbIsEmpty == "1"))	{
				// Obviously, the guestbook is currently empty -> display a message.
				echo "The guestbook is currently empty.";
			}
			else	{
				if (($entriesperpage == 0) || (($entriesperpage != 0) && ($postnumber >= $offset) && ($postnumber < ($offset + $entriesperpage))))	{
					// if we are here, we can display the current post

					// creating an array of each line in the guestbook file
					$gbentry = split($delimiter, $gbentryline);

					// first line of post: dark background;left cell: "nickname", right cell: "date, time"
					echo "\n\t\t\t<!-- post number " . ($numberofposts - $postnumber) . " -->\n";
					echo "\t\t\t<tr class='layouttr'>\n\t\t\t\t<td class='posttopleft' valign='top'>";
					echo "\n\t\t\t\t\t<span class='emphasis'>" . ($numberofposts - $postnumber) . ". " . $gbentry[0] . "</span>\n\t\t\t\t</td>\n";
					echo "\t\t\t\t<td class='posttopright'  valign='top'>\n\t\t\t\t\t<span class='emphasis'>" . $gbentry[3] . ", " . $gbentry[4] . "</span>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n";

					// second line of post: light background; left cell: "homepage, email", right cell: "message"
					echo "\t\t\t<tr>\n\t\t\t\t<td class='postbottomleft'  valign='top'>";
					if ($gbentry[1] != "")	{
						echo " <a href='mailto:" . $gbentry[1] . "'><img src='" . $emailIcon . "' alt='email' border=''></a>&nbsp;";
						if ($gbentry[2] == "")	{
							echo "\n\t\t\t\t<br>";
						}
					}

					if ($gbentry[2] != "")	{
						$currentHomepage = $gbentry[2];
						if (!(preg_match("/^http:\/\//", $currentHomepage)))
							{	$currentHomepage = "http://" . $currentHomepage;	}
						echo "<a href='" . $currentHomepage . "'><img src='" . $homepageIcon . "' alt='homepage' border='0'></a><br>";
					}

					// displaying button to delete the entry if logged in as admin
					if ($adminmode == 1)	{
						echo "\t\t\t\t\t<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'><input type='hidden' name='whichpost' value='" . $postnumber . "'><input type='hidden' name='posttime' value='" . $gbentry[4] . "'><input type='submit' value='Delete this post' name='delete'></form>";
					}

					echo "</td>\n\t\t\t\t<td class='postbottomright' valign='top'>";
					echo "\n\t\t\t\t\t" . recreateUserInput($gbentry[6], $delimiter) . "\t\t\t\t</td>\n\t\t\t</tr>\n";
					$gbIsEmpty = "0";
				}
				else	{
					// this post is not inside the wanted numbers, do nothing
				}
			}
		}
		echo "\t\t</table>\n";
	
		// if splitting the posts onto several pages, display navigation links
		if ($entriesperpage > 0)	{
			displayPostNavigation($numberofposts, $offset);
		}
	}
	
	if ($adminmode == 1)	{
		echo "\t\t<div class='adminlink'><a href='" . $_SERVER['PHP_SELF'] . "?logout' style='font-size: 9px;'>Logout</a></div>\n";
	}
	else {
		echo "\t\t<div class='adminlink'><a href='" . $_SERVER['PHP_SELF'] . "?adminlogin=1' style='font-size: 9px;'>Admin Mode</a></div>\n";
	}
	
	echo "\t\t<div style='text-align: center; margin-top: 10px;'><a href='http://www.hettenhausen.net/flatPHPbook/' style='font-size: 9px;'>flatPHPbook by Thomas Hettenhausen</a></div>\n";
	echo "\t</body>\n</html>\n";
?>
