<?php
	/*
	MGB 0.6.x - OpenSource PHP and MySql Guestbook
	Copyright (C) 2004 - 2011 Juergen Grueneisl - http://www.m-gb.org/

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/

	// ============ //
	// 063.php - 1.0 //
	// ============ //
	//
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //

if (file_exists("../functions.inc.php"))
	{
	if (unlink("../functions.inc.php"))
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- deleting old ''functions.inc.php'' from root directory...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: green;\">&nbsp;OK!<br /></span>\n";
		$success++;
		$count++;
		}
	else
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- deleting old ''functions.inc.php'' from root directory...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: red;\">ERROR!<br /></span>\n";
		$count++;
		}
	}
if (file_exists("../load_templates.inc.php"))
	{
	if (unlink("../load_templates.inc.php"))
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- deleting old ''load_templates.inc.php'' from root directory...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: green;\">&nbsp;OK!<br /></span>\n";
		$success++;
		$count++;
		}
	else
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- deleting old ''load_templates.inc.php'' from root directory...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: red;\">ERROR!<br /></span>\n";
		$count++;
		}
	}
if (file_exists("../load_settings.inc.php"))
	{
	if (unlink("../load_settings.inc.php"))
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- deleting old ''load_settings.inc.php'' from root directory...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: green;\">&nbsp;OK!<br /></span>\n";
		$success++;
		$count++;
		}
	else
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- deleting old ''load_settings.inc.php'' from root directory...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: red;\">ERROR!<br /></span>\n";
		$count++;
		}
	}
if (file_exists("../captcha.php"))
	{
	if (unlink("../captcha.php"))
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- deleting old ''captcha.php'' from root directory...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: green;\">&nbsp;OK!<br /></span>\n";
		$success++;
		$count++;
		}
	else
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- deleting old ''captcha.php'' from root directory...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: red;\">ERROR!<br /></span>\n";
		$count++;
		}
	}
if (file_exists("../akoom.ttf"))
	{
	if (unlink("../akoom.ttf"))
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- deleting old ''akoom.ttf'' from root directory...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: green;\">&nbsp;OK!<br /></span>\n";
		$success++;
		$count++;
		}
	else
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- deleting old ''akoom.ttf'' from root directory...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: red;\">ERROR!<br /></span>\n";
		$count++;
		}
	}
if (file_exists("../config.inc.php"))
	{
	if (rename("../config.inc.php", "../config.inc.bak"))
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- renaming old ''config.inc.php'' to ''config.inc.bak''...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: green;\">&nbsp;OK!<br /></span>\n";
		$success++;
		$count++;
		}
	else
		{
		echo "\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold;\">- renaming old ''config.inc.php'' to ''config.inc.bak''...</span>\n
			\t\t<span style=\"font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; font-weight: bold; color: red;\">ERROR!<br /></span>\n";
		$count++;
		}
	}

$sql = array();

$sql[1] = "CREATE TABLE ".$db['prefix']."captcha_math (
	`math` VARCHAR( 20 ) NOT NULL ,
	  `sum` INT NOT NULL ,
	  PRIMARY KEY ( `math` )
	  ) TYPE = MYISAM;";
$sqldescription[1] = "- Creating table for new captcha...";

$sql[2] = "INSERT INTO ".$db['prefix']."captcha_math (
		`math` ,
		`sum`
	) VALUES (
		'1+2+3' ,
		'6'
		);";
$sqldescription[2] = "- Inserting default values...";

$sql[3] = "ALTER TABLE `".$db['prefix']."settings` ADD `captcha_method` TINYINT( 1 ) DEFAULT '0' NOT NULL AFTER `captcha` ;";
$sqldescription[3] = "- Inserting field for new captcha method...";

$sql[4] = "ALTER TABLE `".$db['prefix']."settings` ADD `akismet_plugin` TINYINT( 1 ) DEFAULT '0' NOT NULL AFTER `captcha_method` ;";
$sqldescription[4] = "- Inserting field for akismet support...";

$sql[5] = "ALTER TABLE `".$db['prefix']."settings` ADD `akismet_api` VARCHAR( 50 ) NOT NULL AFTER `akismet_plugin` ;";
$sqldescription[5] = "- Inserting field for akismet support (API)...";

$sql[6] = "ALTER TABLE `".$db['prefix']."entries` ADD `isspam` TINYINT( 1 ) NOT NULL AFTER `checked` ;";
$sqldescription[6] = "- Inserting field for akismet spam-marking (entries)...";

$sql[7] = "ALTER TABLE `".$db['prefix']."settings` ADD `akismet_mark_as_spam` TINYINT( 1 ) DEFAULT '1' NOT NULL AFTER `akismet_api` ;";
$sqldescription[7] = "- Inserting field for akismet spam-marking (settings)...";

$sql[8] = "ALTER TABLE `".$db['prefix']."user` ADD `r_spam` TINYINT( 1 ) NOT NULL AFTER `r_edit` ;";
$sqldescription[8] = "- Inserting field for new user right 'manage spam'...";

$sql[9] = "ALTER TABLE `".$db['prefix']."settings` ADD `time_lock` INT( 1 ) NOT NULL AFTER `akismet_mark_as_spam` , ADD `time_lock_value` INT( 3 ) DEFAULT '30' NOT NULL AFTER `time_lock` , ADD `time_lock_maxtime` INT DEFAULT '300' NOT NULL AFTER `time_lock_value` ";
$sqldescription[9] = "- Inserting fields for time lock (settings)...";

$sql[10] = "CREATE TABLE ".$db['prefix']."smilies (
	  `ID` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
	  `path` VARCHAR( 255 ) NOT NULL ,
	  `replacement` VARCHAR( 255 ) NOT NULL ,
	  `height` TINYINT( 4 ) NOT NULL ,
	  `width` TINYINT( 4 ) NOT NULL
	  ) TYPE = MYISAM;";
$sqldescription[10] = "- Adding table for smilies...";

$sql[11] = "INSERT INTO ".$db['prefix']."smilies ( 
	  `ID` ,
	  `path` ,
	  `replacement` ,
	  `height` ,
	  `width`
	  ) VALUES 	( NULL , 'smiley_smile.gif', ':smile:', '15', '15' ),
				( NULL , 'smiley_wink.gif', ':wink:', '15', '15' ),
				( NULL , 'smiley_lol.gif', ':lol:', '15', '15' ),
				( NULL , 'smiley_biggrin.gif', ':biggrin:', '15', '15' ),
				( NULL , 'smiley_cool.gif', ':cool:', '15', '15' ),
				( NULL , 'smiley_fun.gif', ':fun:', '15', '15' ),
				( NULL , 'smiley_surprised.gif', ':surprised:', '15', '15' ),
				( NULL , 'smiley_tongue.gif', ':tongue:', '15', '15' ),
				( NULL , 'smiley_confused.gif', ':confused:', '15', '15' ),
				( NULL , 'smiley_eek.gif', ':eek:', '15', '15' ),
				( NULL , 'smiley_doubt.gif', ':doubt:', '15', '15' ),
				( NULL , 'smiley_neutral.gif', ':neutral:', '15', '15' ),
				( NULL , 'smiley_redface.gif', ':redface:', '15', '15' ),
				( NULL , 'smiley_rolleyes.gif', ':rolleyes:', '15', '15' ),
				( NULL , 'smiley_silenced.gif', ':silenced:', '15', '15' ),
				( NULL , 'smiley_sad.gif', ':sad:', '15', '15' ),
				( NULL , 'smiley_cry.gif', ':cry:', '15', '15' ),
				( NULL , 'smiley_doh.gif', ':doh:', '15', '15' ),
				( NULL , 'smiley_angry.gif', ':angry:', '15', '15' ),
				( NULL , 'icon_arrow.gif', ':arrow:', '15', '15' ),
				( NULL , 'icon_exclaim.gif', ':exclaim:', '15', '15' ),
				( NULL , 'icon_question.gif', ':question:', '15', '15' );";
$sqldescription[11] = "- Adding smilies...";

$sql[12] = "ALTER TABLE `".$db['prefix']."user` ADD `r_edit_smilies` TINYINT( 1 ) NOT NULL AFTER `r_spam`";
$sqldescription[12] = "- Updating table for users...";

$sql[13] = "ALTER TABLE `".$db['prefix']."settings` ADD `gravatar_type` TINYINT( 1 ) NOT NULL DEFAULT '1' AFTER `gravatar_rating` ,
          ADD `gravatar_size` INT( 3 ) NOT NULL DEFAULT '50' AFTER `gravatar_type` ,
          ADD `gravatar_position` TINYINT( 1 ) NOT NULL DEFAULT '1' AFTER `gravatar_size` ";
$sqldescription[13] = "- Adding improved gravatar support...";

$sql[14] = "ALTER TABLE `".$db['prefix']."settings` ADD `entries_order_asc_desc` VARCHAR( 4 ) NOT NULL DEFAULT 'DESC' AFTER `entries_order` ,
		   ADD `entries_numbering` TINYINT( 1 ) NOT NULL DEFAULT '0' AFTER `entries_order_asc_desc` ,
		   CHANGE `entries_order` `entries_order` VARCHAR( 11 ) NOT NULL DEFAULT 'ID' ";
$sqldescription[14] = "- Adding fields for improved entries ordering...";

$sql[15] = "UPDATE `".$db['prefix']."settings` SET `entries_order` = 'ID'";
$sqldescription[15] = "- Changing value of field 'entries_order'...";

$sql[16] = "ALTER TABLE `".$db['prefix']."settings` ADD `smileys_break` INT( 2 ) NOT NULL DEFAULT '11' AFTER `smileys` ,
		   ADD `smileys_order` VARCHAR( 4 ) NOT NULL DEFAULT 'ASC' AFTER `smileys_break` ";
$sqldescription[16] = "- Adding fields for improved smiley editing...";

$sql[17] = "ALTER TABLE `".$db['prefix']."settings` ADD `password_min_length` TINYINT( 2 ) NOT NULL DEFAULT '8' AFTER `session_timeout` ";
$sqldescription[17] = "- Adding field for minimum password length...";

// update version number every time
$sql[18] = "UPDATE `".$db['prefix']."settings` SET `version` = '".MGB_VERSION."'";
$sqldescription[18] = "- Updating version number...";

$to = 18;
?>
