/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.cache.internal;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.internet.cache.internal.Cache;
import org.eclipse.wst.internet.cache.internal.CacheJob;
import org.eclipse.wst.internet.cache.internal.LicenseRegistry;
import org.eclipse.wst.internet.cache.internal.ToCacheRegistryReader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CachePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.wst.internet.cache";
    private static CachePlugin plugin;

    public CachePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ToCacheRegistryReader.getInstance().readRegistry();
        Cache.open(Platform.getStateLocation((Bundle)this.getBundle()));
        if (this.getPluginPreferences().contains("cacheEnabled")) {
            this.setCacheEnabled(this.getPluginPreferences().getBoolean("cacheEnabled"));
        } else {
            this.setCacheEnabled(false);
        }
        Preferences prefs = this.getPluginPreferences();
        LicenseRegistry registry = LicenseRegistry.getInstance();
        String[] licenses = registry.getLicenses();
        int numLicenses = licenses.length;
        int i = 0;
        while (i < numLicenses) {
            int state = prefs.getInt(licenses[i]);
            if (state == LicenseRegistry.LICENSE_AGREE) {
                registry.agreeLicense(licenses[i]);
            } else if (state == LicenseRegistry.LICENSE_DISAGREE) {
                registry.disagreeLicense(licenses[i]);
            }
            ++i;
        }
    }

    public void stop(BundleContext context) throws Exception {
        Preferences prefs = this.getPluginPreferences();
        LicenseRegistry registry = LicenseRegistry.getInstance();
        String[] licenses = registry.getLicenses();
        int numLicenses = licenses.length;
        int i = 0;
        while (i < numLicenses) {
            Integer state = registry.getLicenseState(licenses[i]);
            if (state == LicenseRegistry.LICENSE_DISAGREE_THIS_SESSION) {
                state = LicenseRegistry.LICENSE_DISAGREE;
            }
            prefs.setValue(licenses[i], state.intValue());
            ++i;
        }
        Cache.getInstance().close();
        CacheJob.stopJob();
        super.stop(context);
        plugin = null;
    }

    public static CachePlugin getDefault() {
        return plugin;
    }

    public void setCacheEnabled(boolean enabled) {
        this.getPluginPreferences().setValue("cacheEnabled", enabled);
        CacheJob.stopJob();
    }

    public boolean isCacheEnabled() {
        if (this.getPluginPreferences().contains("cacheEnabled")) {
            return this.getPluginPreferences().getBoolean("cacheEnabled");
        }
        return true;
    }

    public void setPromptDisagreedLicenses(boolean prompt) {
        this.getPluginPreferences().setValue("promptDisagreedLicenses", prompt);
    }

    public boolean shouldPrompt() {
        if (this.getPluginPreferences().contains("promptDisagreedLicenses")) {
            return this.getPluginPreferences().getBoolean("promptDisagreedLicenses");
        }
        return true;
    }
}

