/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.discovery.core.util.ITransportService;

public class P2TransportService
implements ITransportService {
    private Object transport;
    private Method downloadMethod;
    private Method streamMethod;
    private Method getLastModifiedMethod;

    public P2TransportService() throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName("org.eclipse.equinox.internal.p2.repository.RepositoryTransport");
            Method getInstanceMethod = clazz.getDeclaredMethod("getInstance", new Class[0]);
            this.transport = getInstanceMethod.invoke(null, new Object[0]);
            this.downloadMethod = clazz.getDeclaredMethod("download", URI.class, OutputStream.class, IProgressMonitor.class);
            this.streamMethod = clazz.getDeclaredMethod("stream", URI.class, IProgressMonitor.class);
            this.getLastModifiedMethod = clazz.getDeclaredMethod("getLastModified", URI.class, IProgressMonitor.class);
        }
        catch (LinkageError e) {
            throw new ClassNotFoundException("Failed to load P2 transport", e);
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Failed to load P2 transport", e);
        }
    }

    public IStatus download(URI uri, OutputStream out, IProgressMonitor monitor) {
        try {
            return (IStatus)this.downloadMethod.invoke(this.transport, uri, out, monitor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream stream(URI uri, IProgressMonitor monitor) throws IOException, CoreException {
        try {
            return (InputStream)this.streamMethod.invoke(this.transport, uri, monitor);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    public long getLastModified(URI location, IProgressMonitor monitor) throws CoreException, IOException {
        try {
            return (Long)this.getLastModifiedMethod.invoke(this.transport, location, monitor);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }
}

