/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.services.impl;

import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.services.IPropertyProvider;
import org.eclipse.datatools.connectivity.oda.consumer.util.manifest.ExtensionExplorer;
import org.eclipse.datatools.connectivity.oda.consumer.util.manifest.PropertyProviderManifest;
import org.eclipse.datatools.connectivity.oda.util.logging.LogManager;
import org.eclipse.datatools.connectivity.oda.util.logging.Logger;

public class ProviderUtil {
    private static final String sm_loggerName = "org.eclipse.datatools.connectivity.oda.consumer";

    public static IPropertyProvider createPropertyProvider(String applicationId) throws OdaException {
        if (applicationId == null || applicationId.length() == 0) {
            ProviderUtil.log("ProviderUtil.getPropertyProvider( String )\t", "No application id specified in method argument.");
            return null;
        }
        PropertyProviderManifest providerManifest = ExtensionExplorer.getInstance().getPropertyProviderManifest(applicationId);
        if (providerManifest == null) {
            ProviderUtil.log("ProviderUtil.getPropertyProvider( String )\t", "No IPropertyProvider found for " + applicationId + ".");
            return null;
        }
        IPropertyProvider extnProvider = providerManifest.createProvider();
        ProviderUtil.log("ProviderUtil.getPropertyProvider( String )\t", "Returning IPropertyProvider instance (" + extnProvider + ") of application id (" + applicationId + ").");
        return extnProvider;
    }

    public static Properties getEffectiveProperties(Properties candidateProperties, Object appContext) throws OdaException {
        IPropertyProvider propProvider = ProviderUtil.createPropertyProvider(ProviderUtil.getConsumerApplicationId(appContext));
        if (propProvider == null) {
            return candidateProperties;
        }
        Properties effectiveProps = propProvider.getDataSourceProperties(candidateProperties, ProviderUtil.getConnectionPropertyContext(appContext));
        return effectiveProps;
    }

    public static String getConsumerApplicationId(Object appContext) {
        if (appContext == null || !(appContext instanceof Map)) {
            return null;
        }
        Object value = ((Map)appContext).get("OdaConsumerId");
        return value instanceof String ? (String)value : null;
    }

    public static Object getConnectionPropertyContext(Object appContext) {
        if (appContext == null || !(appContext instanceof Map)) {
            return null;
        }
        return ((Map)appContext).get("OdaConnPropertyContext");
    }

    public static Boolean getReloadProfileStoreContextValue(Object connPropContext) {
        if (connPropContext == null || !(connPropContext instanceof Map)) {
            return null;
        }
        Object reloadStoreValue = ((Map)connPropContext).get(IPropertyProvider.ODA_RELOAD_PROFILE_STORE);
        return reloadStoreValue instanceof Boolean ? (Boolean)reloadStoreValue : null;
    }

    public static void setReloadProfileStoreContextValue(Map connPropContext, Boolean reloadStoreValue) {
        if (connPropContext == null) {
            throw new IllegalArgumentException("Null connPropContext argument in setReloadProfileStoreIndicator()");
        }
        connPropContext.put(IPropertyProvider.ODA_RELOAD_PROFILE_STORE, reloadStoreValue);
    }

    private static void log(String context, String msg) {
        Logger logger = ProviderUtil.getLogger();
        if (logger != null) {
            logger.fine(String.valueOf(context) + msg);
        }
    }

    private static Logger getLogger() {
        return LogManager.getLogger((String)sm_loggerName);
    }
}

