/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.PostExecution;
import org.eclipse.jpt.common.utility.internal.iterators.SuperListIteratorWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.jpa.core.context.BaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlySecondaryTable;
import org.eclipse.jpt.jpa.core.context.SecondaryTable;
import org.eclipse.jpt.jpa.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.details.PrimaryKeyJoinColumnInSecondaryTableDialog;
import org.eclipse.jpt.jpa.ui.internal.details.PrimaryKeyJoinColumnInSecondaryTableStateObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimaryKeyJoinColumnsInSecondaryTableComposite
extends Pane<ReadOnlySecondaryTable> {
    private WritablePropertyValueModel<ReadOnlyPrimaryKeyJoinColumn> joinColumnHolder;

    public PrimaryKeyJoinColumnsInSecondaryTableComposite(Pane<?> parentPane, PropertyValueModel<? extends ReadOnlySecondaryTable> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    public PrimaryKeyJoinColumnsInSecondaryTableComposite(PropertyValueModel<? extends ReadOnlySecondaryTable> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    void addJoinColumn(PrimaryKeyJoinColumnInSecondaryTableStateObject stateObject) {
        SecondaryTable secondaryTable = stateObject.getOwner();
        int index = secondaryTable.specifiedPrimaryKeyJoinColumnsSize();
        PrimaryKeyJoinColumn joinColumn = secondaryTable.addSpecifiedPrimaryKeyJoinColumn(index);
        stateObject.updateJoinColumn((BaseJoinColumn)joinColumn);
    }

    void addPrimaryKeyJoinColumn() {
        PrimaryKeyJoinColumnInSecondaryTableDialog dialog = new PrimaryKeyJoinColumnInSecondaryTableDialog(this.getShell(), (SecondaryTable)this.getSubject(), null);
        dialog.openDialog(this.buildAddPrimaryKeyJoinColumnPostExecution());
    }

    private PostExecution<PrimaryKeyJoinColumnInSecondaryTableDialog> buildAddPrimaryKeyJoinColumnPostExecution() {
        return new PostExecution<PrimaryKeyJoinColumnInSecondaryTableDialog>(){

            public void execute(PrimaryKeyJoinColumnInSecondaryTableDialog dialog) {
                if (dialog.wasConfirmed()) {
                    PrimaryKeyJoinColumnsInSecondaryTableComposite.this.addJoinColumn((PrimaryKeyJoinColumnInSecondaryTableStateObject)dialog.getSubject());
                }
            }
        };
    }

    private PropertyValueModel<Boolean> buildControlBooleanHolder() {
        return new TransformationPropertyValueModel<ReadOnlySecondaryTable, Boolean>(this.getSubjectHolder()){

            protected Boolean transform(ReadOnlySecondaryTable value) {
                if (value == null) {
                    return Boolean.FALSE;
                }
                return !value.isVirtual();
            }
        };
    }

    private PropertyValueModel<ReadOnlyPrimaryKeyJoinColumn> buildDefaultJoinColumnHolder() {
        return new PropertyAspectAdapter<ReadOnlySecondaryTable, ReadOnlyPrimaryKeyJoinColumn>(this.getSubjectHolder(), new String[]{"defaultPrimaryKeyJoinColumn"}){

            protected ReadOnlyPrimaryKeyJoinColumn buildValue_() {
                return ((ReadOnlySecondaryTable)this.subject).getDefaultPrimaryKeyJoinColumn();
            }
        };
    }

    private ListValueModel<ReadOnlyPrimaryKeyJoinColumn> buildDefaultJoinColumnListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultJoinColumnHolder());
    }

    private PostExecution<PrimaryKeyJoinColumnInSecondaryTableDialog> buildEditPrimaryKeyJoinColumnPostExecution() {
        return new PostExecution<PrimaryKeyJoinColumnInSecondaryTableDialog>(){

            public void execute(PrimaryKeyJoinColumnInSecondaryTableDialog dialog) {
                if (dialog.wasConfirmed()) {
                    PrimaryKeyJoinColumnsInSecondaryTableComposite.this.editPrimaryKeyJoinColumn((PrimaryKeyJoinColumnInSecondaryTableStateObject)dialog.getSubject());
                }
            }
        };
    }

    String buildJoinColumnLabel(ReadOnlyPrimaryKeyJoinColumn joinColumn) {
        if (joinColumn.isDefault()) {
            return NLS.bind((String)JptUiDetailsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedName() == null) {
            if (joinColumn.getSpecifiedReferencedColumnName() == null) {
                return NLS.bind((String)JptUiDetailsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsBothDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
            }
            return NLS.bind((String)JptUiDetailsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsFirstDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedReferencedColumnName() == null) {
            return NLS.bind((String)JptUiDetailsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsSecDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        return NLS.bind((String)JptUiDetailsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParams, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    private ILabelProvider buildJoinColumnsListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                ReadOnlyPrimaryKeyJoinColumn joinColumn = (ReadOnlyPrimaryKeyJoinColumn)element;
                return PrimaryKeyJoinColumnsInSecondaryTableComposite.this.buildJoinColumnLabel(joinColumn);
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildOverrideDefaultJoinColumnHolder() {
        return new OverrideDefaultJoinColumnHolder();
    }

    private AddRemovePane.Adapter buildPrimaryKeyJoinColumnAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                PrimaryKeyJoinColumnsInSecondaryTableComposite.this.addPrimaryKeyJoinColumn();
            }

            public boolean hasOptionalButton() {
                return true;
            }

            public String optionalButtonText() {
                return JptUiDetailsMessages.PrimaryKeyJoinColumnsComposite_edit;
            }

            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                PrimaryKeyJoinColumnsInSecondaryTableComposite.this.editPrimaryKeyJoinColumn(listSelectionModel);
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                PrimaryKeyJoinColumnsInSecondaryTableComposite.this.removePrimaryKeyJoinColumn(listSelectionModel);
            }
        };
    }

    private WritablePropertyValueModel<ReadOnlyPrimaryKeyJoinColumn> buildPrimaryKeyJoinColumnHolder() {
        return new SimplePropertyValueModel();
    }

    private ListValueModel<ReadOnlyPrimaryKeyJoinColumn> buildPrimaryKeyJoinColumnsListHolder() {
        ArrayList<ListValueModel<ReadOnlyPrimaryKeyJoinColumn>> list = new ArrayList<ListValueModel<ReadOnlyPrimaryKeyJoinColumn>>();
        list.add(this.buildSpecifiedJoinColumnsListHolder());
        list.add(this.buildDefaultJoinColumnListHolder());
        return new CompositeListValueModel(list);
    }

    private ListValueModel<ReadOnlyPrimaryKeyJoinColumn> buildPrimaryKeyJoinColumnsListModel() {
        return new ItemPropertyListValueModelAdapter(this.buildPrimaryKeyJoinColumnsListHolder(), new String[]{"specifiedName", "defaultName", "specifiedReferencedColumnName", "defaultReferencedColumnName"});
    }

    ListValueModel<ReadOnlyPrimaryKeyJoinColumn> buildSpecifiedJoinColumnsListHolder() {
        return new ListAspectAdapter<ReadOnlySecondaryTable, ReadOnlyPrimaryKeyJoinColumn>(this.getSubjectHolder(), new String[]{"specifiedPrimaryKeyJoinColumns"}){

            protected ListIterator<ReadOnlyPrimaryKeyJoinColumn> listIterator_() {
                return new SuperListIteratorWrapper(((ReadOnlySecondaryTable)this.subject).specifiedPrimaryKeyJoinColumns());
            }

            protected int size_() {
                return ((ReadOnlySecondaryTable)this.subject).specifiedPrimaryKeyJoinColumnsSize();
            }
        };
    }

    void editPrimaryKeyJoinColumn(ObjectListSelectionModel listSelectionModel) {
        PrimaryKeyJoinColumn joinColumn = (PrimaryKeyJoinColumn)listSelectionModel.selectedValue();
        PrimaryKeyJoinColumnInSecondaryTableDialog dialog = new PrimaryKeyJoinColumnInSecondaryTableDialog(this.getShell(), (SecondaryTable)this.getSubject(), joinColumn);
        dialog.openDialog(this.buildEditPrimaryKeyJoinColumnPostExecution());
    }

    void editPrimaryKeyJoinColumn(PrimaryKeyJoinColumnInSecondaryTableStateObject stateObject) {
        stateObject.updateJoinColumn((BaseJoinColumn)stateObject.getJoinColumn());
    }

    protected void initialize() {
        super.initialize();
        this.joinColumnHolder = this.buildPrimaryKeyJoinColumnHolder();
    }

    protected void initializeLayout(Composite container) {
        Group groupPane = this.addTitledGroup(container, JptUiDetailsMessages.PrimaryKeyJoinColumnsComposite_primaryKeyJoinColumn);
        this.addCheckBox(this.addSubPane((Composite)groupPane, 8), JptUiDetailsMessages.PrimaryKeyJoinColumnsComposite_overrideDefaultPrimaryKeyJoinColumns, this.buildOverrideDefaultJoinColumnHolder(), null, this.buildControlBooleanHolder());
        AddRemoveListPane joinColumnsPane = new AddRemoveListPane((Pane)this, (Composite)groupPane, this.buildPrimaryKeyJoinColumnAdapter(), this.buildPrimaryKeyJoinColumnsListModel(), this.joinColumnHolder, this.buildJoinColumnsListLabelProvider(), "org.eclipse.jpt.jpa.ui.mapping_joinTableJoinColumns");
        this.installPrimaryKeyJoinColumnListPaneEnabler((AddRemoveListPane<ReadOnlySecondaryTable>)joinColumnsPane);
    }

    private void installPrimaryKeyJoinColumnListPaneEnabler(AddRemoveListPane<ReadOnlySecondaryTable> pkJoinColumnListPane) {
        new PaneEnabler(this.buildOverrideDefaultJoinColumnHolder(), pkJoinColumnListPane);
    }

    void removePrimaryKeyJoinColumn(ObjectListSelectionModel listSelectionModel) {
        int[] selectedIndices = listSelectionModel.selectedIndices();
        int index = selectedIndices.length;
        while (--index >= 0) {
            ((SecondaryTable)this.getSubject()).removeSpecifiedPrimaryKeyJoinColumn(selectedIndices[index]);
        }
    }

    void updateJoinColumns(boolean selected) {
        if (this.isPopulating()) {
            return;
        }
        this.setPopulating(true);
        try {
            SecondaryTable secondaryTable = (SecondaryTable)this.getSubject();
            if (selected) {
                PrimaryKeyJoinColumn defaultJoinColumn = secondaryTable.getDefaultPrimaryKeyJoinColumn();
                if (defaultJoinColumn != null) {
                    String columnName = defaultJoinColumn.getDefaultName();
                    String referencedColumnName = defaultJoinColumn.getDefaultReferencedColumnName();
                    PrimaryKeyJoinColumn pkJoinColumn = secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0);
                    pkJoinColumn.setSpecifiedName(columnName);
                    pkJoinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
                    this.joinColumnHolder.setValue((Object)pkJoinColumn);
                }
            } else {
                int index = secondaryTable.specifiedPrimaryKeyJoinColumnsSize();
                while (--index >= 0) {
                    secondaryTable.removeSpecifiedPrimaryKeyJoinColumn(index);
                }
            }
        }
        finally {
            this.setPopulating(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OverrideDefaultJoinColumnHolder
    extends ListPropertyValueModelAdapter<Boolean>
    implements WritablePropertyValueModel<Boolean> {
        public OverrideDefaultJoinColumnHolder() {
            super(PrimaryKeyJoinColumnsInSecondaryTableComposite.this.buildSpecifiedJoinColumnsListHolder());
        }

        protected Boolean buildValue() {
            return this.buildValue_();
        }

        protected boolean buildValue_() {
            ReadOnlySecondaryTable table = (ReadOnlySecondaryTable)PrimaryKeyJoinColumnsInSecondaryTableComposite.this.getSubject();
            return table != null && !table.isVirtual() && this.listHolder.size() > 0;
        }

        public void setValue(Boolean value) {
            PrimaryKeyJoinColumnsInSecondaryTableComposite.this.updateJoinColumns(value);
        }
    }
}

