/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.textcanvas;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.internal.terminal.textcanvas.ILinelRenderer;
import org.eclipse.tm.internal.terminal.textcanvas.ITextCanvasModel;
import org.eclipse.tm.internal.terminal.textcanvas.StyleMap;
import org.eclipse.tm.internal.terminal.textcanvas.TextCanvas;
import org.eclipse.tm.terminal.model.ITerminalTextDataReadOnly;
import org.eclipse.tm.terminal.model.LineSegment;
import org.eclipse.tm.terminal.model.Style;

public class TextLineRenderer
implements ILinelRenderer {
    private final ITextCanvasModel fModel;
    StyleMap fStyleMap = new StyleMap();

    public TextLineRenderer(TextCanvas c, ITextCanvasModel model) {
        this.fModel = model;
    }

    public int getCellWidth() {
        return this.fStyleMap.getFontWidth();
    }

    public int getCellHeight() {
        return this.fStyleMap.getFontHeight();
    }

    public void drawLine(ITextCanvasModel model, GC gc, int line, int x, int y, int colFirst, int colLast) {
        if (line < 0 || line >= this.getTerminalText().getHeight() || colFirst >= this.getTerminalText().getWidth() || colFirst - colLast == 0) {
            this.fillBackground(gc, x, y, this.getCellWidth() * (colLast - colFirst), this.getCellHeight());
        } else {
            colLast = Math.min(colLast, this.getTerminalText().getWidth());
            LineSegment[] segments = this.getTerminalText().getLineSegments(line, colFirst, colLast - colFirst);
            int i = 0;
            while (i < segments.length) {
                LineSegment segment = segments[i];
                Style style = segment.getStyle();
                this.setupGC(gc, style);
                String text = segment.getText();
                this.drawText(gc, x, y, colFirst, segment.getColumn(), text);
                this.drawCursor(model, gc, line, x, y, colFirst);
                ++i;
            }
            if (this.fModel.hasLineSelection(line)) {
                gc.setForeground(Display.getCurrent().getSystemColor(27));
                gc.setBackground(Display.getCurrent().getSystemColor(26));
                Point start = model.getSelectionStart();
                Point end = model.getSelectionEnd();
                char[] chars = model.getTerminalText().getChars(line);
                if (chars == null) {
                    return;
                }
                int offset = 0;
                if (start.y == line) {
                    offset = start.x;
                }
                offset = Math.max(offset, colFirst);
                int len = end.y == line ? end.x - offset + 1 : chars.length - offset + 1;
                if ((len = Math.min(len, chars.length - offset)) > 0) {
                    String text = new String(chars, offset, len);
                    this.drawText(gc, x, y, colFirst, offset, text);
                }
            }
        }
    }

    private void fillBackground(GC gc, int x, int y, int width, int height) {
        Color bg = gc.getBackground();
        gc.setBackground(this.getDefaultBackgroundColor());
        gc.fillRectangle(x, y, width, height);
        gc.setBackground(bg);
    }

    public Color getDefaultBackgroundColor() {
        return this.fStyleMap.getBackgroundColor(null);
    }

    private void drawCursor(ITextCanvasModel model, GC gc, int row, int x, int y, int colFirst) {
        int cursorColumn;
        if (!model.isCursorOn()) {
            return;
        }
        int cursorLine = model.getCursorLine();
        if (row == cursorLine && (cursorColumn = model.getCursorColumn()) < this.getTerminalText().getWidth()) {
            Style style = this.getTerminalText().getStyle(row, cursorColumn);
            if (style == null) {
                style = Style.getStyle("BLACK", "WHITE");
            }
            style = style.setReverse(!style.isReverse());
            this.setupGC(gc, style);
            String text = String.valueOf(this.getTerminalText().getChar(row, cursorColumn));
            this.drawText(gc, x, y, colFirst, cursorColumn, text);
        }
    }

    private void drawText(GC gc, int x, int y, int colFirst, int col, String text) {
        int offset = (col - colFirst) * this.getCellWidth();
        if (this.fStyleMap.isFontProportional()) {
            int i = 0;
            while (i < text.length()) {
                char c = text.charAt(i);
                int xx = x + offset + i * this.fStyleMap.getFontWidth();
                gc.fillRectangle(xx, y, this.fStyleMap.getFontWidth(), this.fStyleMap.getFontHeight());
                if (c != ' ' && c != '\u0000') {
                    gc.drawString(String.valueOf(c), this.fStyleMap.getCharOffset(c) + xx, y, true);
                }
                ++i;
            }
        } else {
            text = text.replace('\u0000', ' ');
            gc.drawString(text, x + offset, y, false);
        }
    }

    private void setupGC(GC gc, Style style) {
        Font f;
        Color c = this.fStyleMap.getForegrondColor(style);
        if (c != gc.getForeground()) {
            gc.setForeground(c);
        }
        if ((c = this.fStyleMap.getBackgroundColor(style)) != gc.getBackground()) {
            gc.setBackground(c);
        }
        if ((f = this.fStyleMap.getFont(style)) != gc.getFont()) {
            gc.setFont(f);
        }
    }

    ITerminalTextDataReadOnly getTerminalText() {
        return this.fModel.getTerminalText();
    }

    public void onFontChange() {
        this.fStyleMap.updateFont();
    }

    public void setInvertedColors(boolean invert) {
        this.fStyleMap.setInvertedColors(invert);
    }
}

