/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.ui.internal.propertypage.verifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.verifier.VerifierRegistryReader;
import org.eclipse.wst.server.core.IRuntime;

public class VerifierRegistry {
    private static VerifierRegistry INSTANCE;
    private HashMap assemblyVerifierExtensions = new HashMap();

    protected void register(IConfigurationElement verifier, List serverTargets, List components) {
        for (String compID : components) {
            for (String runtimeID : serverTargets) {
                HashMap targetVerifiers = this.getVerifierExtensions(compID);
                this.getTargetVerifiers(targetVerifiers, runtimeID).add(verifier);
            }
        }
    }

    private List getVerifiers(String compID, String serverTarget) {
        HashMap targetVerifiers = this.getVerifierExtensions(compID);
        return this.getTargetVerifiers(targetVerifiers, serverTarget);
    }

    protected static VerifierRegistry instance() {
        if (INSTANCE == null) {
            INSTANCE = new VerifierRegistry();
            VerifierRegistry.readRegistry();
        }
        return INSTANCE;
    }

    private static void readRegistry() {
        VerifierRegistryReader reader = new VerifierRegistryReader();
        reader.readRegistry();
    }

    private List getTargetVerifiers(HashMap targetVerifiers, String serverTarget) {
        if (targetVerifiers.get(serverTarget) == null) {
            targetVerifiers.put(serverTarget, new ArrayList());
        }
        return (List)targetVerifiers.get(serverTarget);
    }

    private HashMap getVerifierExtensions(String compID) {
        if (this.getVerifierExtensions().get(compID) == null) {
            this.getVerifierExtensions().put(compID, new HashMap());
        }
        return (HashMap)this.getVerifierExtensions().get(compID);
    }

    private HashMap getVerifierExtensions() {
        return this.assemblyVerifierExtensions;
    }

    public List getVerifierExtensions(String facetTypeID, IRuntime runtime) {
        String runtimeID = null;
        runtimeID = runtime == null ? "None" : runtime.getRuntimeType().getId();
        List verifiers = this.getVerifiers(facetTypeID, runtimeID);
        if (verifiers == null) {
            return Collections.EMPTY_LIST;
        }
        return verifiers;
    }
}

