/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.data;

import java.util.List;
import java.util.Map;
import javax.xml.transform.sax.TransformerHandler;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDataStateWriter {
    private static final String TASK_DATA_STATE_VERSION = "2.0";
    private static final String CDATA = "CDATA";
    private final TransformerHandler handler;

    public TaskDataStateWriter(TransformerHandler handler) {
        this.handler = handler;
    }

    public void write(ITaskDataWorkingCopy state) throws SAXException {
        this.handler.startDocument();
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "connectorKind", CDATA, state.getConnectorKind());
        atts.addAttribute("", "", "repositoryUrl", CDATA, state.getRepositoryUrl());
        atts.addAttribute("", "", "taskId", CDATA, state.getTaskId());
        atts.addAttribute("", "", "version", CDATA, TASK_DATA_STATE_VERSION);
        this.handler.startElement("", "", "TaskState", atts);
        if (state.getRepositoryData() != null) {
            this.writeTaskData(state.getRepositoryData(), "NewData");
        }
        if (state.getLastReadData() != null) {
            this.writeTaskData(state.getLastReadData(), "OldData");
        }
        if (state.getEditsData() != null) {
            this.writeTaskData(state.getEditsData(), "EditsData");
        }
        this.handler.endElement("", "", "TaskState");
        this.handler.endDocument();
    }

    private void writeTaskData(TaskData taskData, String elementName) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "connectorKind", CDATA, taskData.getConnectorKind());
        atts.addAttribute("", "", "repositoryUrl", CDATA, taskData.getRepositoryUrl());
        atts.addAttribute("", "", "taskId", CDATA, taskData.getTaskId());
        if (taskData.getVersion() != null) {
            atts.addAttribute("", "", "version", CDATA, taskData.getVersion());
        }
        this.handler.startElement("", "", elementName, atts);
        atts.clear();
        this.handler.startElement("", "", "Attributes", atts);
        this.writeTaskAttribute(taskData.getRoot());
        this.handler.endElement("", "", "Attributes");
        this.handler.endElement("", "", elementName);
    }

    private void writeTaskAttribute(TaskAttribute attribute) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "id", CDATA, attribute.getId());
        this.handler.startElement("", "", "Attribute", atts);
        atts.clear();
        this.handler.startElement("", "", "values", atts);
        List<String> values = attribute.getValues();
        for (String value : values) {
            this.handler.startElement("", "", "value", atts);
            this.handler.characters(value.toCharArray(), 0, value.length());
            this.handler.endElement("", "", "value");
        }
        this.handler.endElement("", "", "values");
        this.handler.startElement("", "", "options", atts);
        this.writeMap(atts, attribute.getOptions(), "option");
        this.handler.endElement("", "", "options");
        this.handler.startElement("", "", "MetaData", atts);
        this.writeMap(atts, attribute.getMetaData().getValues(), "meta");
        this.handler.endElement("", "", "MetaData");
        this.handler.startElement("", "", "Attributes", atts);
        Map<String, TaskAttribute> children = attribute.getAttributes();
        for (TaskAttribute child : children.values()) {
            this.writeTaskAttribute(child);
        }
        this.handler.endElement("", "", "Attributes");
        this.handler.endElement("", "", "Attribute");
    }

    private void writeMap(AttributesImpl atts, Map<String, String> options, String elementName) throws SAXException {
        for (String key : options.keySet()) {
            String value = options.get(key);
            this.handler.startElement("", "", elementName, atts);
            this.handler.startElement("", "", "key", atts);
            this.handler.characters(key.toCharArray(), 0, key.length());
            this.handler.endElement("", "", "key");
            this.handler.startElement("", "", "value", atts);
            this.handler.characters(value.toCharArray(), 0, value.length());
            this.handler.endElement("", "", "value");
            this.handler.endElement("", "", elementName);
        }
    }
}

