/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import java.io.File;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.ITaskListRunnable;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.externalization.AbstractExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.core.externalization.ExternalizationManager;
import org.eclipse.mylyn.internal.tasks.core.externalization.IExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.core.externalization.Messages;
import org.eclipse.mylyn.internal.tasks.core.externalization.TaskListExternalizer;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListExternalizationParticipant
extends AbstractExternalizationParticipant
implements IExternalizationParticipant,
ITaskListChangeListener,
ITaskActivationListener {
    private static final String DESCRIPTION = Messages.TaskListExternalizationParticipant_Task_List;
    private final ExternalizationManager manager;
    private final TaskListExternalizer taskListWriter;
    private final TaskList taskList;
    private boolean dirty;
    private final TaskRepositoryManager taskRepositoryManager;
    private final RepositoryModel repositoryModel;

    public TaskListExternalizationParticipant(RepositoryModel repositoryModel, TaskList taskList, TaskListExternalizer taskListExternalizer, ExternalizationManager manager, TaskRepositoryManager repositoryManager) {
        this.repositoryModel = repositoryModel;
        this.manager = manager;
        this.taskList = taskList;
        this.taskListWriter = taskListExternalizer;
        this.taskRepositoryManager = repositoryManager;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return TaskList.getSchedulingRule();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void load(final File sourceFile, IProgressMonitor monitor) throws CoreException {
        ITaskListRunnable loadRunnable = new ITaskListRunnable(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                TaskListExternalizationParticipant.this.resetTaskList();
                TaskListExternalizationParticipant.this.taskListWriter.readTaskList(TaskListExternalizationParticipant.this.taskList, sourceFile);
            }
        };
        this.taskList.run(loadRunnable, monitor);
    }

    @Override
    protected boolean performLoad(File dataFile, IProgressMonitor monitor) throws CoreException {
        if (super.performLoad(dataFile, monitor)) {
            return true;
        }
        try {
            File oldTasklist = new File(dataFile.getParent(), "tasklist.xml.zip");
            if (oldTasklist.exists()) {
                this.load(oldTasklist, monitor);
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public void resetTaskList() {
        this.repositoryModel.clear();
        this.taskList.reset();
        this.prepareOrphanContainers();
    }

    private void prepareOrphanContainers() {
        for (TaskRepository repository : this.taskRepositoryManager.getAllRepositories()) {
            if (repository.getConnectorKind().equals("local")) continue;
            this.taskList.addUnmatchedContainer(new UnmatchedTaskContainer(repository.getConnectorKind(), repository.getRepositoryUrl()));
        }
    }

    @Override
    public void save(final File targetFile, IProgressMonitor monitor) throws CoreException {
        ITaskListRunnable saveRunnable = new ITaskListRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(IProgressMonitor monitor) throws CoreException {
                TaskListExternalizationParticipant taskListExternalizationParticipant = TaskListExternalizationParticipant.this;
                synchronized (taskListExternalizationParticipant) {
                    TaskListExternalizationParticipant.this.dirty = false;
                }
                TaskListExternalizationParticipant.this.taskListWriter.writeTaskList(TaskListExternalizationParticipant.this.taskList, targetFile);
            }
        };
        this.taskList.run(saveRunnable, monitor);
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getFileName() {
        return "tasks.xml.zip";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void containersChanged(Set<TaskContainerDelta> containers) {
        for (TaskContainerDelta taskContainerDelta : containers) {
            if (taskContainerDelta.isTransient()) continue;
            TaskListExternalizationParticipant taskListExternalizationParticipant = this;
            synchronized (taskListExternalizationParticipant) {
                this.dirty = true;
            }
            this.manager.requestSave();
            return;
        }
    }

    @Override
    public void preTaskActivated(ITask task) {
    }

    @Override
    public void preTaskDeactivated(ITask task) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskActivated(ITask task) {
        TaskListExternalizationParticipant taskListExternalizationParticipant = this;
        synchronized (taskListExternalizationParticipant) {
            this.dirty = true;
        }
        this.manager.requestSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskDeactivated(ITask task) {
        TaskListExternalizationParticipant taskListExternalizationParticipant = this;
        synchronized (taskListExternalizationParticipant) {
            this.dirty = true;
        }
        this.manager.requestSave();
    }
}

