/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.auth;

import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.mylyn.commons.repositories.auth.AuthenticationCredentials;
import org.eclipse.mylyn.commons.repositories.auth.ICredentialsStore;

public class UsernamePasswordCredentials
extends AuthenticationCredentials {
    private final String userName;
    private final String password;

    public UsernamePasswordCredentials(String userName, String password) {
        if (userName == null) {
            throw new IllegalArgumentException();
        }
        if (password == null) {
            throw new IllegalArgumentException();
        }
        this.userName = userName;
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UsernamePasswordCredentials other = (UsernamePasswordCredentials)obj;
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }

    public static UsernamePasswordCredentials create(ICredentialsStore store, String prefix) throws StorageException {
        String userName = store.get(String.valueOf(prefix) + ".user", "");
        String password = store.get(String.valueOf(prefix) + ".password", "");
        return new UsernamePasswordCredentials(userName, password);
    }

    public void save(ICredentialsStore store, String prefix) throws StorageException {
        store.put(String.valueOf(prefix) + ".user", this.userName, false);
        store.put(String.valueOf(prefix) + ".password", this.password, true);
    }
}

