/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.sampleapp.command;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitoractions.JavaMofBeanVisitorAction;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitors.JavaMofBeanVisitor;
import org.eclipse.jst.ws.internal.consumption.command.common.JavaMofReflectionCommand;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.selection.BooleanSelection;
import org.eclipse.wst.common.environment.Choice;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;

public class JavaToModelCommand
extends AbstractDataModelOperation {
    private String clientProject;
    private BooleanSelection[] methods;
    private String proxyBean;
    private JavaClass javaClass;
    private Model model;
    private Element parentElement;

    private IStatus createJavaReflection(IEnvironment env, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        JavaMofReflectionCommand javaMofReflectionCommand = new JavaMofReflectionCommand();
        javaMofReflectionCommand.setClientProject(this.clientProject);
        javaMofReflectionCommand.setProxyBean(this.proxyBean);
        javaMofReflectionCommand.setEnvironment(env);
        status = javaMofReflectionCommand.execute(monitor, null);
        this.javaClass = (JavaClass)javaMofReflectionCommand.getJavaClass();
        return status;
    }

    public Model getJavaDataModel() {
        return this.model;
    }

    public IStatus buildModelFromMof(IEnvironment env) throws CoreException {
        Choice OKChoice = new Choice('O', ConsumptionMessages.LABEL_OK, ConsumptionMessages.DESCRIPTION_OK);
        Choice CancelChoice = new Choice('C', ConsumptionMessages.LABEL_CANCEL, ConsumptionMessages.DESCRIPTION_CANCEL);
        IStatus status = Status.OK_STATUS;
        if (this.model == null && this.parentElement == null) {
            Choice result;
            JavaMofBeanVisitor beanVisitor = new JavaMofBeanVisitor();
            JavaMofBeanVisitorAction beanVisitorAction = new JavaMofBeanVisitorAction(this.clientProject, this.methods, env);
            status = beanVisitor.run(this.javaClass, beanVisitorAction);
            int severity = status.getSeverity();
            if (severity == 4) {
                return status;
            }
            if (severity == 2 && (result = env.getStatusHandler().report(status, new Choice[]{OKChoice, CancelChoice})).getLabel().equals(CancelChoice.getLabel())) {
                return StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_SAMPLE_CREATION_CANCELED);
            }
            this.model = beanVisitorAction.getModel();
        } else if (this.model == null && this.parentElement != null) {
            Choice result;
            JavaMofBeanVisitor beanVisitor = new JavaMofBeanVisitor();
            JavaMofBeanVisitorAction beanVisitorAction = new JavaMofBeanVisitorAction(this.parentElement, this.clientProject, env);
            status = beanVisitor.run(this.javaClass, beanVisitorAction);
            int severity = status.getSeverity();
            if (severity == 4) {
                return status;
            }
            if (severity == 2 && (result = env.getStatusHandler().report(status, new Choice[]{OKChoice, CancelChoice})).getLabel().equals(CancelChoice.getLabel())) {
                return StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_SAMPLE_CREATION_CANCELED);
            }
            this.model = beanVisitorAction.getModel();
        } else {
            Choice result;
            JavaMofBeanVisitor beanVisitor = new JavaMofBeanVisitor();
            JavaMofBeanVisitorAction beanVisitorAction = new JavaMofBeanVisitorAction(this.model, this.clientProject, env);
            status = beanVisitor.run(this.javaClass, beanVisitorAction);
            int severity = status.getSeverity();
            if (severity == 4) {
                return status;
            }
            if (severity == 2 && (result = env.getStatusHandler().report(status, new Choice[]{OKChoice, CancelChoice})).getLabel().equals(CancelChoice.getLabel())) {
                return StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_SAMPLE_CREATION_CANCELED);
            }
            this.model = beanVisitorAction.getModel();
        }
        return status;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        if (this.clientProject == null) {
            return status;
        }
        status = this.createJavaReflection(env, monitor);
        if (status.getSeverity() == 4) {
            return status;
        }
        try {
            status = this.buildModelFromMof(env);
            return status;
        }
        catch (CoreException exc) {
            IStatus embeddedStatus;
            status = embeddedStatus = exc.getStatus();
            return status;
        }
    }

    public void setMethods(BooleanSelection[] methods) {
        this.methods = methods;
    }

    public void setClientProject(String clientProject) {
        this.clientProject = clientProject;
    }

    public void setParentElement(Element parentElement) {
        this.parentElement = parentElement;
    }

    public void setProxyBean(String proxyBean) {
        this.proxyBean = proxyBean;
    }
}

