/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.Collection;
import java.util.Map;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sessions.IsolatedClientSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExclusiveIsolatedClientSession
extends IsolatedClientSession {
    protected boolean shouldAlwaysUseExclusiveConnection;

    public ExclusiveIsolatedClientSession(ServerSession parent, ConnectionPolicy connectionPolicy) {
        this(parent, connectionPolicy, null);
    }

    public ExclusiveIsolatedClientSession(ServerSession parent, ConnectionPolicy connectionPolicy, Map properties) {
        super(parent, connectionPolicy, properties);
        this.accessors = null;
        this.shouldAlwaysUseExclusiveConnection = connectionPolicy.isExclusiveAlways();
    }

    @Override
    public Collection<Accessor> getAccessors() {
        return this.getWriteConnections().values();
    }

    @Override
    public void setAccessor(Accessor accessor) {
        this.setWriteConnection(accessor);
    }

    @Override
    protected void releaseWriteConnection() {
    }

    @Override
    public void postAcquireConnection(Accessor accessor) {
        super.postAcquireConnection(accessor);
        if (this.parent.hasEventManager()) {
            this.parent.getEventManager().postAcquireExclusiveConnection(this, accessor);
        }
    }

    @Override
    public void preReleaseConnection(Accessor accessor) {
        super.preReleaseConnection(accessor);
        if (this.parent.hasEventManager()) {
            this.parent.getEventManager().preReleaseExclusiveConnection(this, accessor);
        }
    }

    @Override
    public boolean isExclusiveConnectionRequired() {
        return this.isActive;
    }

    @Override
    public boolean isExclusiveIsolatedClientSession() {
        return true;
    }

    @Override
    protected boolean shouldExecuteLocally(DatabaseQuery query) {
        if (this.shouldAlwaysUseExclusiveConnection) {
            return true;
        }
        return super.shouldExecuteLocally(query);
    }
}

