/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionCommandHandler;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.ICommandAccess;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class LinkedNamesAssistProposal
implements IJavaCompletionProposal,
ICompletionProposalExtension2,
ICompletionProposalExtension6,
ICommandAccess {
    public static final String ASSIST_ID = "org.eclipse.jdt.ui.correction.renameInFile.assist";
    private SimpleName fNode;
    private IInvocationContext fContext;
    private String fLabel;
    private String fValueSuggestion;
    private int fRelevance;

    public LinkedNamesAssistProposal(IInvocationContext context, SimpleName node) {
        this(CorrectionMessages.LinkedNamesAssistProposal_description, context, node, null);
    }

    public LinkedNamesAssistProposal(String label, IInvocationContext context, SimpleName node, String valueSuggestion) {
        this.fLabel = label;
        this.fNode = node;
        this.fContext = context;
        this.fValueSuggestion = valueSuggestion;
        this.fRelevance = 8;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        try {
            IEditorPart editor;
            Point seletion = viewer.getSelectedRange();
            CompilationUnit root = SharedASTProvider.getAST((ITypeRoot)this.fContext.getCompilationUnit(), SharedASTProvider.WAIT_YES, null);
            ASTNode nameNode = NodeFinder.perform((ASTNode)root, (int)this.fNode.getStartPosition(), (int)this.fNode.getLength());
            final int pos = this.fNode.getStartPosition();
            Object[] sameNodes = nameNode instanceof SimpleName ? LinkedNodeFinder.findByNode((ASTNode)root, (SimpleName)nameNode) : new ASTNode[]{nameNode};
            Arrays.sort(sameNodes, new Comparator<ASTNode>(){

                @Override
                public int compare(ASTNode o1, ASTNode o2) {
                    return this.rank(o1) - this.rank(o2);
                }

                private int rank(ASTNode node) {
                    int relativeRank = node.getStartPosition() + node.getLength() - pos;
                    if (relativeRank < 0) {
                        return Integer.MAX_VALUE + relativeRank;
                    }
                    return relativeRank;
                }
            });
            IDocument document = viewer.getDocument();
            LinkedPositionGroup group = new LinkedPositionGroup();
            int i = 0;
            while (i < sameNodes.length) {
                SimpleName elem = sameNodes[i];
                group.addPosition(new LinkedPosition(document, elem.getStartPosition(), elem.getLength(), i));
                ++i;
            }
            LinkedModeModel model = new LinkedModeModel();
            model.addGroup(group);
            model.forceInstall();
            if (this.fContext instanceof AssistContext && (editor = ((AssistContext)this.fContext).getEditor()) instanceof JavaEditor) {
                model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer((JavaEditor)editor));
            }
            EditorLinkedModeUI ui = new EditorLinkedModeUI(model, viewer);
            ui.setExitPolicy((LinkedModeUI.IExitPolicy)new DeleteBlockingExitPolicy(document));
            ui.setExitPosition(viewer, offset, 0, -1);
            ui.enter();
            if (this.fValueSuggestion != null) {
                document.replace(nameNode.getStartPosition(), nameNode.getLength(), this.fValueSuggestion);
                IRegion selectedRegion = ui.getSelectedRegion();
                seletion = new Point(selectedRegion.getOffset(), this.fValueSuggestion.length());
            }
            viewer.setSelectedRange(seletion.x, seletion.y);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    public void apply(IDocument document) {
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return CorrectionMessages.LinkedNamesAssistProposal_proposalinfo;
    }

    public String getDisplayString() {
        String shortCutString = CorrectionCommandHandler.getShortCutString(this.getCommandId());
        if (shortCutString != null) {
            return Messages.format(CorrectionMessages.ChangeCorrectionProposal_name_with_shortcut, new String[]{this.fLabel, shortCutString});
        }
        return this.fLabel;
    }

    public StyledString getStyledDisplayString() {
        StyledString str = new StyledString(this.fLabel);
        String shortCutString = CorrectionCommandHandler.getShortCutString(this.getCommandId());
        if (shortCutString != null) {
            String decorated = Messages.format(CorrectionMessages.ChangeCorrectionProposal_name_with_shortcut, new String[]{this.fLabel, shortCutString});
            return StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.QUALIFIER_STYLER, (StyledString)str);
        }
        return str;
    }

    public Image getImage() {
        return JavaPluginImages.get("org.eclipse.jdt.ui.correction_linked_rename.gif");
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void selected(ITextViewer textViewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer textViewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return false;
    }

    public String getCommandId() {
        return ASSIST_ID;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }

    public static class DeleteBlockingExitPolicy
    implements LinkedModeUI.IExitPolicy {
        private IDocument fDocument;

        public DeleteBlockingExitPolicy(IDocument document) {
            this.fDocument = document;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            LinkedPosition position;
            if (length == 0 && (event.character == '\b' || event.character == '\u007f') && (position = model.findPosition(new LinkedPosition(this.fDocument, offset, 0, -1))) != null) {
                if (event.character == '\b') {
                    if (offset - 1 < position.getOffset()) {
                        event.doit = false;
                    }
                } else if (offset + 1 > position.getOffset() + position.getLength()) {
                    event.doit = false;
                }
            }
            return null;
        }
    }
}

