/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.text.java;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.text.java.ContentAssistHistory;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.CompletionProposalLabelProvider;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class JavaContentAssistInvocationContext
extends ContentAssistInvocationContext {
    private final IEditorPart fEditor;
    private ICompilationUnit fCU = null;
    private boolean fCUComputed = false;
    private CompletionProposalLabelProvider fLabelProvider;
    private CompletionProposalCollector fCollector;
    private ContentAssistHistory.RHSHistory fRHSHistory;
    private IType fType;
    private IJavaCompletionProposal[] fKeywordProposals = null;
    private CompletionContext fCoreContext = null;

    public JavaContentAssistInvocationContext(ITextViewer viewer, int offset, IEditorPart editor) {
        super(viewer, offset);
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
    }

    public JavaContentAssistInvocationContext(ICompilationUnit unit) {
        this.fCU = unit;
        this.fCUComputed = true;
        this.fEditor = null;
    }

    public ICompilationUnit getCompilationUnit() {
        if (!this.fCUComputed) {
            this.fCUComputed = true;
            if (this.fCollector != null) {
                this.fCU = this.fCollector.getCompilationUnit();
            } else {
                ITypeRoot je = EditorUtility.getEditorInputJavaElement(this.fEditor, false);
                if (je instanceof ICompilationUnit) {
                    this.fCU = (ICompilationUnit)je;
                }
            }
        }
        return this.fCU;
    }

    public IJavaProject getProject() {
        ICompilationUnit unit = this.getCompilationUnit();
        return unit == null ? null : unit.getJavaProject();
    }

    public IJavaCompletionProposal[] getKeywordProposals() {
        if (this.fKeywordProposals == null) {
            if (this.fCollector != null && !this.fCollector.isIgnored(3) && this.fCollector.getContext() != null) {
                this.fKeywordProposals = this.fCollector.getKeywordCompletionProposals();
            } else {
                this.computeKeywordsAndContext();
            }
        }
        return this.fKeywordProposals;
    }

    public CompletionContext getCoreContext() {
        CompletionContext context;
        if (this.fCollector != null && (context = this.fCollector.getContext()) != null) {
            if (this.fCoreContext == null) {
                this.fCoreContext = context;
            }
            return context;
        }
        if (this.fCoreContext == null) {
            this.computeKeywordsAndContext();
        }
        return this.fCoreContext;
    }

    public float getHistoryRelevance(String qualifiedTypeName) {
        return this.getRHSHistory().getRank(qualifiedTypeName);
    }

    private ContentAssistHistory.RHSHistory getRHSHistory() {
        if (this.fRHSHistory == null) {
            char[][] expectedTypes;
            CompletionContext context = this.getCoreContext();
            if (context != null && (expectedTypes = context.getExpectedTypesSignatures()) != null && expectedTypes.length > 0) {
                String expected = SignatureUtil.stripSignatureToFQN(String.valueOf(expectedTypes[0]));
                this.fRHSHistory = JavaPlugin.getDefault().getContentAssistHistory().getHistory(expected);
            }
            if (this.fRHSHistory == null) {
                this.fRHSHistory = JavaPlugin.getDefault().getContentAssistHistory().getHistory(null);
            }
        }
        return this.fRHSHistory;
    }

    public IType getExpectedType() {
        IJavaProject project;
        char[][] expectedTypes;
        CompletionContext context;
        if (this.fType == null && this.getCompilationUnit() != null && (context = this.getCoreContext()) != null && (expectedTypes = context.getExpectedTypesSignatures()) != null && expectedTypes.length > 0 && (project = this.getCompilationUnit().getJavaProject()) != null) {
            try {
                this.fType = project.findType(SignatureUtil.stripSignatureToFQN(String.valueOf(expectedTypes[0])));
            }
            catch (JavaModelException x) {
                JavaPlugin.log(x);
            }
        }
        return this.fType;
    }

    public CompletionProposalLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = this.fCollector != null ? this.fCollector.getLabelProvider() : new CompletionProposalLabelProvider();
        }
        return this.fLabelProvider;
    }

    void setCollector(CompletionProposalCollector collector) {
        this.fCollector = collector;
    }

    private void computeKeywordsAndContext() {
        block8: {
            ICompilationUnit cu = this.getCompilationUnit();
            if (cu == null) {
                if (this.fKeywordProposals == null) {
                    this.fKeywordProposals = new IJavaCompletionProposal[0];
                }
                return;
            }
            CompletionProposalCollector collector = new CompletionProposalCollector(cu, true);
            collector.setIgnored(3, false);
            try {
                cu.codeComplete(this.getInvocationOffset(), (CompletionRequestor)collector);
                if (this.fCoreContext == null) {
                    this.fCoreContext = collector.getContext();
                }
                if (this.fKeywordProposals == null) {
                    this.fKeywordProposals = collector.getKeywordCompletionProposals();
                }
                if (this.fLabelProvider == null) {
                    this.fLabelProvider = collector.getLabelProvider();
                }
            }
            catch (JavaModelException x) {
                if (!x.isDoesNotExist() || cu.getJavaProject() == null || cu.getJavaProject().isOnClasspath((IJavaElement)cu)) {
                    JavaPlugin.log(x);
                }
                if (this.fKeywordProposals != null) break block8;
                this.fKeywordProposals = new IJavaCompletionProposal[0];
            }
        }
    }
}

