/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.confluence.core.block;

import org.eclipse.mylyn.internal.wikitext.confluence.core.block.AbstractConfluenceDelimitedBlock;
import org.eclipse.mylyn.wikitext.confluence.core.ConfluenceLanguage;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class ExtendedQuoteBlock
extends AbstractConfluenceDelimitedBlock {
    private int paraLine = 0;
    private boolean paraOpen = false;
    private Block nestedBlock = null;

    public ExtendedQuoteBlock() {
        super("quote");
    }

    protected void resetState() {
        super.resetState();
        this.paraOpen = false;
        this.paraLine = 0;
        this.nestedBlock = null;
    }

    protected void beginBlock() {
        Attributes attributes = new Attributes();
        this.builder.beginBlock(DocumentBuilder.BlockType.QUOTE, attributes);
    }

    protected void endBlock() {
        if (this.nestedBlock != null) {
            this.nestedBlock.setClosed(true);
            this.nestedBlock = null;
        }
        if (this.paraOpen) {
            this.builder.endBlock();
            this.paraLine = 0;
            this.paraOpen = false;
        }
        this.builder.endBlock();
    }

    protected void handleBlockContent(String content) {
        if (this.nestedBlock == null) {
            ConfluenceLanguage markupLanguage = (ConfluenceLanguage)this.getMarkupLanguage();
            for (Block block : markupLanguage.getNestedBlocks()) {
                if (!block.canStart(content, 0)) continue;
                this.nestedBlock = block.clone();
                this.nestedBlock.setParser(this.getParser());
                this.nestedBlock.setState(this.getState());
                if (!this.paraOpen) break;
                this.builder.endBlock();
                this.paraOpen = false;
                this.paraLine = 0;
                break;
            }
        }
        if (this.nestedBlock != null) {
            int lineOffset = this.nestedBlock.processLine(content, 0);
            if (this.nestedBlock.isClosed()) {
                this.nestedBlock = null;
            }
            if (lineOffset < content.length() && lineOffset >= 0) {
                if (this.nestedBlock != null) {
                    throw new IllegalStateException("if a block does not fully process a line then it must be closed");
                }
                content = content.substring(lineOffset);
            } else {
                return;
            }
        }
        if (this.blockLineCount == 1 && content.length() == 0) {
            return;
        }
        if (this.blockLineCount > 1 && this.paraOpen && this.getMarkupLanguage().isEmptyLine(content)) {
            this.builder.endBlock();
            this.paraOpen = false;
            this.paraLine = 0;
            return;
        }
        if (!this.paraOpen) {
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
            this.paraOpen = true;
        }
        if (this.paraLine != 0) {
            this.builder.lineBreak();
        }
        ++this.paraLine;
        this.getMarkupLanguage().emitMarkupLine(this.getParser(), this.state, content, 0);
    }

    protected void setOption(String key, String value) {
    }
}

