/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.schemagen.internal;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.jpt.jaxb.core.schemagen.internal.JptJaxbCoreMessages;

public final class Tools {
    public static String GEN_DEFAULT_NAME = "schema";
    public static final String EMPTY_STRING = "";

    public static boolean stringIsEmpty(String string) {
        if (string == null) {
            return true;
        }
        int len = string.length();
        if (len == 0) {
            return true;
        }
        return Tools.stringIsEmpty_(string.toCharArray(), len);
    }

    private static boolean stringIsEmpty_(char[] s, int len) {
        int i = len;
        while (i-- > 0) {
            if (Character.isWhitespace(s[i])) continue;
            return false;
        }
        return true;
    }

    public static String stripExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    public static String stripProtocol(String uri) {
        return uri.replaceFirst("http://", EMPTY_STRING);
    }

    public static String appendXsdExtension(String name) {
        return String.valueOf(name) + ".xsd";
    }

    public static String extractFileNumber(String fileName) {
        String result = Tools.stripExtension(fileName);
        if (Tools.stringIsEmpty(result)) {
            return EMPTY_STRING;
        }
        return result.replaceFirst(GEN_DEFAULT_NAME, EMPTY_STRING);
    }

    public static String extractDirectory(String path) {
        if (!path.contains(File.separator)) {
            return EMPTY_STRING;
        }
        return path.substring(0, path.lastIndexOf(File.separator));
    }

    public static String getString(String key) {
        return JptJaxbCoreMessages.getString(key);
    }

    public static String bind(String key, Object argument) {
        return MessageFormat.format(Tools.getString(key), argument);
    }
}

