/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.ui.preview;

import com.ibm.icu.text.DateFormat;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.usagedata.internal.gathering.events.UsageDataEvent;
import org.eclipse.epp.usagedata.internal.recording.filtering.FilterChangeListener;
import org.eclipse.epp.usagedata.internal.recording.filtering.FilterUtils;
import org.eclipse.epp.usagedata.internal.recording.filtering.PreferencesBasedFilter;
import org.eclipse.epp.usagedata.internal.recording.uploading.UploadParameters;
import org.eclipse.epp.usagedata.internal.recording.uploading.UsageDataFileReader;
import org.eclipse.epp.usagedata.internal.ui.Activator;
import org.eclipse.epp.usagedata.internal.ui.preview.AddFilterDialog;
import org.eclipse.epp.usagedata.internal.ui.preview.Messages;
import org.eclipse.epp.usagedata.internal.ui.preview.RemoveFilterDialog;
import org.eclipse.epp.usagedata.internal.ui.preview.UsageDataEventWrapper;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadPreview {
    private final UploadParameters parameters;
    TableViewer viewer;
    Job contentJob;
    List<UsageDataEventWrapper> events = Collections.synchronizedList(new ArrayList());
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance((int)3, (int)3);
    private UsageDataTableViewerColumn includeColumn;
    private UsageDataTableViewerColumn whatColumn;
    private UsageDataTableViewerColumn kindColumn;
    private UsageDataTableViewerColumn descriptionColumn;
    private UsageDataTableViewerColumn bundleIdColumn;
    private UsageDataTableViewerColumn bundleVersionColumn;
    private UsageDataTableViewerColumn timestampColumn;
    private Color colorGray;
    private Color colorBlack;
    private Image xImage;
    private Cursor busyCursor;
    Button removeFilterButton;
    private Button eclipseOnlyButton;
    private Button addFilterButton;

    public UploadPreview(UploadParameters parameters) {
        this.parameters = parameters;
    }

    public Control createControl(Composite parent) {
        this.allocateResources(parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.createDescriptionText(composite);
        this.createEventsTable(composite);
        this.createEclipseOnlyButton(composite);
        this.createButtons(composite);
        PaintListener paintListener = new PaintListener(){
            boolean called = false;

            public void paintControl(PaintEvent e) {
                if (this.called) {
                    return;
                }
                this.called = true;
                UploadPreview.this.startContentJob();
            }
        };
        composite.addPaintListener(paintListener);
        return composite;
    }

    private void allocateResources(Composite parent) {
        this.colorGray = parent.getDisplay().getSystemColor(15);
        this.colorBlack = parent.getDisplay().getSystemColor(2);
        this.busyCursor = parent.getDisplay().getSystemCursor(1);
        this.xImage = Activator.getDefault().getImageDescriptor("/icons/x.png").createImage((Device)parent.getDisplay());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UploadPreview.this.xImage.dispose();
            }
        });
    }

    private void createDescriptionText(Composite parent) {
        FormText text = new FormText(parent, 0);
        text.setImage("x", this.xImage);
        text.setText(Messages.UploadPreview_2, true, false);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.widthHint = 500;
        text.setLayoutData((Object)layoutData);
    }

    private void createEventsTable(Composite parent) {
        this.viewer = new TableViewer(parent, 68354);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(false);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 500;
        this.viewer.getTable().setLayoutData((Object)layoutData);
        this.createIncludeColumn();
        this.createWhatColumn();
        this.createKindColumn();
        this.createDescriptionColumn();
        this.createBundleIdColumn();
        this.createBundleVersionColumn();
        this.createTimestampColumn();
        this.timestampColumn.setSortColumn();
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object input) {
                if (input instanceof List) {
                    return ((List)input).toArray(new Object[((List)input).size()]);
                }
                return new Object[0];
            }
        });
        final FilterChangeListener filterChangeListener = new FilterChangeListener(){

            public void filterChanged() {
                for (UsageDataEventWrapper event : UploadPreview.this.events) {
                    event.resetCaches();
                }
                UploadPreview.this.viewer.refresh();
            }
        };
        this.parameters.getFilter().addFilterChangeListener(filterChangeListener);
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UploadPreview.this.parameters.getFilter().removeFilterChangeListener(filterChangeListener);
            }
        });
        this.viewer.setInput(this.events);
    }

    private void createIncludeColumn() {
        this.includeColumn = new UsageDataTableViewerColumn(0x1000000);
        this.includeColumn.setLabelProvider(new UsageDataColumnProvider(){

            public Image getImage(UsageDataEventWrapper event) {
                if (!event.isIncludedByFilter()) {
                    return UploadPreview.this.xImage;
                }
                return null;
            }
        });
    }

    private void createWhatColumn() {
        this.whatColumn = new UsageDataTableViewerColumn(16384);
        this.whatColumn.setText(Messages.UploadPreview_3);
        this.whatColumn.setLabelProvider(new UsageDataColumnProvider(){

            public String getText(UsageDataEventWrapper event) {
                return event.getWhat();
            }
        });
    }

    private void createKindColumn() {
        this.kindColumn = new UsageDataTableViewerColumn(16384);
        this.kindColumn.setText(Messages.UploadPreview_4);
        this.kindColumn.setLabelProvider(new UsageDataColumnProvider(){

            public String getText(UsageDataEventWrapper event) {
                return event.getKind();
            }
        });
    }

    private void createDescriptionColumn() {
        this.descriptionColumn = new UsageDataTableViewerColumn(16384);
        this.descriptionColumn.setText(Messages.UploadPreview_5);
        this.descriptionColumn.setLabelProvider(new UsageDataColumnProvider(){

            public String getText(UsageDataEventWrapper event) {
                return event.getDescription();
            }
        });
    }

    private void createBundleIdColumn() {
        this.bundleIdColumn = new UsageDataTableViewerColumn(16384);
        this.bundleIdColumn.setText(Messages.UploadPreview_6);
        this.bundleIdColumn.setLabelProvider(new UsageDataColumnProvider(){

            public String getText(UsageDataEventWrapper event) {
                return event.getBundleId();
            }
        });
    }

    private void createBundleVersionColumn() {
        this.bundleVersionColumn = new UsageDataTableViewerColumn(16384);
        this.bundleVersionColumn.setText(Messages.UploadPreview_7);
        this.bundleVersionColumn.setLabelProvider(new UsageDataColumnProvider(){

            public String getText(UsageDataEventWrapper event) {
                return event.getBundleVersion();
            }
        });
    }

    private void createTimestampColumn() {
        this.timestampColumn = new UsageDataTableViewerColumn(16384);
        this.timestampColumn.setText(Messages.UploadPreview_8);
        this.timestampColumn.setLabelProvider(new UsageDataColumnProvider(){

            public String getText(UsageDataEventWrapper event) {
                return dateFormat.format(new Date(event.getWhen()));
            }
        });
        this.timestampColumn.setSorter(new Comparator<UsageDataEventWrapper>(){

            @Override
            public int compare(UsageDataEventWrapper event1, UsageDataEventWrapper event2) {
                if (event1.getWhen() == event2.getWhen()) {
                    return 0;
                }
                return event1.getWhen() > event2.getWhen() ? 1 : -1;
            }
        });
    }

    private void createButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 4, true, false);
        buttons.setLayoutData((Object)layoutData);
        buttons.setLayout((Layout)new RowLayout());
        this.createAddFilterButton(buttons);
        this.createRemoveFilterButton(buttons);
        final FilterChangeListener filterChangeListener = new FilterChangeListener(){

            public void filterChanged() {
                UploadPreview.this.updateButtons();
            }
        };
        this.parameters.getFilter().addFilterChangeListener(filterChangeListener);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UploadPreview.this.parameters.getFilter().removeFilterChangeListener(filterChangeListener);
            }
        });
        this.updateButtons();
    }

    private void createEclipseOnlyButton(Composite buttons) {
        this.eclipseOnlyButton = new Button(buttons, 32);
        this.eclipseOnlyButton.setText(Messages.UploadPreview_9);
        this.eclipseOnlyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((PreferencesBasedFilter)UploadPreview.this.parameters.getFilter()).setEclipseOnly(UploadPreview.this.eclipseOnlyButton.getSelection());
            }
        });
    }

    private void updateButtons() {
        if (this.parameters.getFilter() instanceof PreferencesBasedFilter) {
            PreferencesBasedFilter filter = (PreferencesBasedFilter)this.parameters.getFilter();
            if (filter.isEclipseOnly()) {
                this.eclipseOnlyButton.setSelection(true);
                this.addFilterButton.setEnabled(false);
                this.removeFilterButton.setEnabled(false);
            } else {
                this.eclipseOnlyButton.setSelection(false);
                this.addFilterButton.setEnabled(true);
                this.removeFilterButton.setEnabled(filter.getFilterPatterns().length > 0);
            }
        }
    }

    private void createAddFilterButton(Composite parent) {
        if (this.parameters.getFilter() instanceof PreferencesBasedFilter) {
            this.addFilterButton = new Button(parent, 8);
            this.addFilterButton.setText(Messages.UploadPreview_10);
            this.addFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    new AddFilterDialog((PreferencesBasedFilter)UploadPreview.this.parameters.getFilter()).prompt(UploadPreview.this.viewer.getTable().getShell(), UploadPreview.this.getFilterSuggestion());
                }
            });
        }
    }

    private void createRemoveFilterButton(Composite parent) {
        if (this.parameters.getFilter() instanceof PreferencesBasedFilter) {
            this.removeFilterButton = new Button(parent, 8);
            this.removeFilterButton.setText(Messages.UploadPreview_11);
            this.removeFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    new RemoveFilterDialog((PreferencesBasedFilter)UploadPreview.this.parameters.getFilter()).prompt(UploadPreview.this.viewer.getTable().getShell());
                }
            });
        }
    }

    String getFilterSuggestion() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection != null) {
            if (selection.size() == 1) {
                return this.getFilterSuggestionBasedOnSingleSelection(selection);
            }
            if (selection.size() > 1) {
                return this.getFilterSuggestionBasedOnMultipleSelection(selection);
            }
        }
        return FilterUtils.getDefaultFilterSuggestion();
    }

    String getFilterSuggestionBasedOnSingleSelection(IStructuredSelection selection) {
        return ((UsageDataEventWrapper)selection.getFirstElement()).getBundleId();
    }

    String getFilterSuggestionBasedOnMultipleSelection(IStructuredSelection selection) {
        String[] names = new String[selection.size()];
        int index = 0;
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object event = objectArray[n2];
            names[index++] = ((UsageDataEventWrapper)event).getBundleId();
            ++n2;
        }
        return FilterUtils.getFilterSuggestionBasedOnBundleIds((String[])names);
    }

    synchronized void startContentJob() {
        if (this.contentJob != null) {
            return;
        }
        this.contentJob = new Job("Generate Usage Data Upload Preview"){

            protected IStatus run(IProgressMonitor monitor) {
                this.setTableCursor(UploadPreview.this.busyCursor);
                UploadPreview.this.processFiles(monitor);
                this.setTableCursor(null);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }

            private void setTableCursor(final Cursor cursor) {
                if (UploadPreview.this.isDisposed()) {
                    return;
                }
                UploadPreview.this.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        if (UploadPreview.this.isDisposed()) {
                            return;
                        }
                        (this).UploadPreview.this.viewer.getTable().setCursor(cursor);
                    }
                });
            }
        };
        this.contentJob.setPriority(30);
        this.contentJob.schedule();
    }

    void processFiles(IProgressMonitor monitor) {
        File[] files = this.parameters.getFiles();
        monitor.beginTask("Process Files", files.length);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (this.isDisposed() || monitor.isCanceled()) break;
            this.processFile(file, monitor);
            monitor.worked(1);
            ++n2;
        }
        monitor.done();
    }

    void processFile(File file, IProgressMonitor monitor) {
        block11: {
            final ArrayList<UsageDataEventWrapper> events = new ArrayList<UsageDataEventWrapper>();
            UsageDataFileReader reader = null;
            try {
                try {
                    reader = new UsageDataFileReader(file);
                    reader.iterate(monitor, new UsageDataFileReader.Iterator(){

                        public void header(String header) {
                        }

                        public void event(String line, UsageDataEvent event) {
                            events.add(new UsageDataEventWrapper(UploadPreview.this.parameters, event));
                            if (events.size() > 25) {
                                UploadPreview.this.addEvents(events);
                                events.clear();
                            }
                        }
                    });
                    this.addEvents(events);
                }
                catch (Exception e) {
                    Activator.getDefault().log(2, e, "An error occurred while trying to read %1$s", file.getAbsolutePath());
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    boolean isDisposed() {
        if (this.viewer == null) {
            return true;
        }
        if (this.viewer.getTable() == null) {
            return true;
        }
        return this.viewer.getTable().isDisposed();
    }

    void addEvents(List<UsageDataEventWrapper> newEvents) {
        if (this.isDisposed()) {
            return;
        }
        this.events.addAll(newEvents);
        final Object[] array = newEvents.toArray(new Object[newEvents.size()]);
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                if (UploadPreview.this.isDisposed()) {
                    return;
                }
                UploadPreview.this.viewer.add(array);
                UploadPreview.this.resizeColumns(array);
            }
        });
    }

    private Display getDisplay() {
        return this.viewer.getTable().getDisplay();
    }

    void resizeColumns(Object[] events) {
        if (this.isDisposed()) {
            return;
        }
        GC gc = new GC((Drawable)this.getDisplay());
        gc.setFont(this.viewer.getTable().getFont());
        this.resizeColumn(gc, this.includeColumn, events);
        this.resizeColumn(gc, this.whatColumn, events);
        this.resizeColumn(gc, this.kindColumn, events);
        this.resizeColumn(gc, this.bundleIdColumn, events);
        this.resizeColumn(gc, this.bundleVersionColumn, events);
        this.resizeColumn(gc, this.descriptionColumn, events);
        this.resizeColumn(gc, this.timestampColumn, events);
        gc.dispose();
    }

    void resizeColumn(GC gc, UsageDataTableViewerColumn column, Object[] events) {
        column.resize(gc, events);
    }

    abstract class UsageDataColumnProvider
    extends ColumnLabelProvider {
        UsageDataColumnProvider() {
        }

        public int getMaximumWidth(GC gc, Object[] events) {
            int width = 0;
            Object[] objectArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                Object event = objectArray[n2];
                Point extent = gc.textExtent(this.getText(event));
                int x = extent.x;
                Image image = this.getImage(event);
                if (image != null) {
                    x += image.getBounds().width;
                }
                if (x > width) {
                    width = x;
                }
                ++n2;
            }
            return width;
        }

        public Color getForeground(Object element) {
            if (((UsageDataEventWrapper)element).isIncludedByFilter()) {
                return UploadPreview.this.colorBlack;
            }
            return UploadPreview.this.colorGray;
        }

        public String getText(Object element) {
            return this.getText((UsageDataEventWrapper)element);
        }

        public Image getImage(Object element) {
            return this.getImage((UsageDataEventWrapper)element);
        }

        public String getText(UsageDataEventWrapper element) {
            return "";
        }

        public Image getImage(UsageDataEventWrapper element) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UsageDataTableViewerColumn {
        private TableViewerColumn column;
        private UsageDataColumnProvider usageDataColumnProvider;
        private Comparator<UsageDataEventWrapper> comparator = new Comparator<UsageDataEventWrapper>(){

            @Override
            public int compare(UsageDataEventWrapper event1, UsageDataEventWrapper event2) {
                if (UsageDataTableViewerColumn.this.usageDataColumnProvider == null) {
                    return 0;
                }
                String text1 = UsageDataTableViewerColumn.this.usageDataColumnProvider.getText(event1);
                String text2 = UsageDataTableViewerColumn.this.usageDataColumnProvider.getText(event2);
                if (text1 == null && text2 == null) {
                    return 0;
                }
                if (text1 == null) {
                    return -1;
                }
                if (text2 == null) {
                    return 1;
                }
                return text1.compareTo(text2);
            }
        };
        private ViewerSorter sorter = new ViewerSorter(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                return UsageDataTableViewerColumn.this.comparator.compare((UsageDataEventWrapper)object1, (UsageDataEventWrapper)object2);
            }
        };
        private SelectionListener selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsageDataTableViewerColumn.this.setSortColumn();
            }
        };

        public UsageDataTableViewerColumn(int style) {
            this.column = new TableViewerColumn(UploadPreview.this.viewer, style);
            this.initialize();
        }

        public void setSortColumn() {
            this.getTable().setSortColumn(this.getColumn());
            this.getTable().setSortDirection(1024);
            UploadPreview.this.viewer.setSorter(this.sorter);
        }

        private void initialize() {
            this.getColumn().addSelectionListener(this.selectionListener);
            this.getColumn().setWidth(25);
        }

        TableColumn getColumn() {
            return this.column.getColumn();
        }

        Table getTable() {
            return UploadPreview.this.viewer.getTable();
        }

        public void setSorter(Comparator<UsageDataEventWrapper> comparator) {
            this.comparator = comparator;
        }

        public void resize(GC gc, Object[] objects) {
            int width = this.usageDataColumnProvider.getMaximumWidth(gc, objects) + 20;
            width = Math.max(this.getColumn().getWidth(), width);
            this.getColumn().setWidth(width);
        }

        public void setLabelProvider(UsageDataColumnProvider usageDataColumnProvider) {
            this.usageDataColumnProvider = usageDataColumnProvider;
            this.column.setLabelProvider((CellLabelProvider)usageDataColumnProvider);
        }

        public void setWidth(int width) {
            this.getColumn().setWidth(width);
        }

        public void setText(String text) {
            this.getColumn().setText(text);
        }
    }
}

