/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.ui.wizards;

import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.usagedata.internal.ui.Activator;
import org.eclipse.epp.usagedata.internal.ui.uploaders.AskUserUploader;
import org.eclipse.epp.usagedata.internal.ui.wizards.AskUserUploaderWizard;
import org.eclipse.epp.usagedata.internal.ui.wizards.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

public class SelectActionWizardPage
extends WizardPage {
    private static final String UDC_URL = "http://www.eclipse.org/org/usagedata/index.php";
    private static final String FAQ_URL = "http://www.eclipse.org/org/usagedata/faq.php";
    private static final int WIDTH_HINT = 500;
    private final AskUserUploader uploader;
    private Button neverUploadRadio;
    private Button dontUploadRadio;
    private Button uploadAlwaysRadio;
    private Button uploadNowRadio;

    public SelectActionWizardPage(AskUserUploader uploader) {
        super("wizardPage");
        this.uploader = uploader;
        this.setTitle(Messages.SelectActionWizardPage_3);
        this.setDescription(Messages.SelectActionWizardPage_4);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        FormText greeting = this.createFormText(composite, Messages.SelectActionWizardPage_5);
        greeting.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                if ("udc".equals(event.getHref())) {
                    SelectActionWizardPage.this.browseTo(SelectActionWizardPage.UDC_URL);
                } else if ("preview".equals(event.getHref())) {
                    ((AskUserUploaderWizard)SelectActionWizardPage.this.getWizard()).showPreviewPage();
                } else if ("faq".equals(event.getHref())) {
                    SelectActionWizardPage.this.browseTo(SelectActionWizardPage.FAQ_URL);
                }
            }
        });
        this.createSpacer(composite);
        this.createUploadNowRadio(composite);
        this.createSpacer(composite);
        this.createUploadAlwaysRadio(composite);
        this.createSpacer(composite);
        this.createDontUploadRadio(composite);
        this.createSpacer(composite);
        this.createNeverUploadRadio(composite);
        this.createSpacer(composite);
        FormText text = this.createFormText(composite, this.getTermsText());
        text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                ((AskUserUploaderWizard)SelectActionWizardPage.this.getWizard()).showTermsPage();
            }
        });
        this.setControl((Control)composite);
    }

    private String getTermsText() {
        return Messages.SelectActionWizardPage_9;
    }

    private void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData layoutData = new GridData();
        layoutData.heightHint = 5;
        spacer.setLayoutData((Object)layoutData);
    }

    private void createUploadNowRadio(Composite parent) {
        this.uploadNowRadio = this.createRadio(parent, Messages.SelectActionWizardPage_10, 0);
        this.createDescriptionText(parent, Messages.SelectActionWizardPage_11);
    }

    private void createUploadAlwaysRadio(Composite parent) {
        this.uploadAlwaysRadio = this.createRadio(parent, Messages.SelectActionWizardPage_12, 1);
        this.createDescriptionText(parent, Messages.SelectActionWizardPage_13);
    }

    private void createDontUploadRadio(Composite parent) {
        this.dontUploadRadio = this.createRadio(parent, Messages.SelectActionWizardPage_14, 2);
        this.createDescriptionText(parent, Messages.SelectActionWizardPage_15);
    }

    private void createNeverUploadRadio(Composite parent) {
        this.neverUploadRadio = this.createRadio(parent, Messages.SelectActionWizardPage_16, 3);
        this.createDescriptionText(parent, Messages.SelectActionWizardPage_17);
    }

    private Button createRadio(Composite parent, String label, final int action) {
        Button radio = new Button(parent, 16);
        radio.setText(label);
        radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectActionWizardPage.this.uploader.setAction(action);
                SelectActionWizardPage.this.getContainer().updateButtons();
            }
        });
        radio.setSelection(this.uploader.getAction() == action);
        return radio;
    }

    private void createDescriptionText(Composite parent, String string) {
        this.createText(parent, string, 25);
    }

    private void createText(Composite parent, String string, int indent) {
        Label text = new Label(parent, 64);
        text.setText(string);
        GridData layoutData = new GridData();
        layoutData.horizontalIndent = indent;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.widthHint = 500;
        text.setLayoutData((Object)layoutData);
    }

    private FormText createFormText(Composite parent, String string) {
        FormText text = new FormText(parent, 64);
        text.setText(string, true, true);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.widthHint = 500;
        text.setLayoutData((Object)layoutData);
        return text;
    }

    public boolean isPageComplete() {
        if (this.uploadAlwaysRadio.getSelection()) {
            return true;
        }
        if (this.uploadNowRadio.getSelection()) {
            return true;
        }
        if (this.neverUploadRadio.getSelection()) {
            return true;
        }
        return this.dontUploadRadio.getSelection();
    }

    private void browseTo(String url) {
        try {
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(url));
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.epp.usagedata.ui", "Error opening browser", (Throwable)e));
        }
    }
}

