/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.wst.common.componentcore.internal.ComponentcorePackage;
import org.eclipse.wst.common.componentcore.internal.ProjectComponents;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleIndexingAdapter;

public class ProjectComponentsImpl
extends EObjectImpl
implements ProjectComponents {
    protected static final String PROJECT_NAME_EDEFAULT = "";
    protected String projectName = "";
    protected EList components = null;
    protected static final String VERSION_EDEFAULT = "1.0.0";
    protected String version = "1.0.0";
    private boolean isIndexed;
    private final Map modulesIndex = new HashMap();

    protected ProjectComponentsImpl() {
    }

    protected EClass eStaticClass() {
        return ComponentcorePackage.Literals.PROJECT_COMPONENTS;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String newProjectName) {
        String oldProjectName = this.projectName;
        this.projectName = newProjectName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldProjectName, (Object)this.projectName));
        }
    }

    public EList getComponents() {
        if (this.components == null) {
            this.components = new EObjectContainmentEList(WorkbenchComponent.class, (InternalEObject)this, 1);
        }
        return this.components;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldVersion, (Object)this.version));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getComponents()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getProjectName();
            }
            case 1: {
                return this.getComponents();
            }
            case 2: {
                return this.getVersion();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setProjectName((String)newValue);
                return;
            }
            case 1: {
                this.getComponents().clear();
                this.getComponents().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setVersion((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setProjectName(PROJECT_NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.getComponents().clear();
                return;
            }
            case 2: {
                this.setVersion(VERSION_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return PROJECT_NAME_EDEFAULT == null ? this.projectName != null : !PROJECT_NAME_EDEFAULT.equals(this.projectName);
            }
            case 1: {
                return this.components != null && !this.components.isEmpty();
            }
            case 2: {
                return VERSION_EDEFAULT == null ? this.version != null : !VERSION_EDEFAULT.equals(this.version);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (projectName: ");
        result.append(this.projectName);
        result.append(", version: ");
        result.append(this.version);
        result.append(')');
        return result.toString();
    }

    public WorkbenchComponent findWorkbenchModule(String aDeployName) {
        if (this.getComponents().size() == 1) {
            return ((WorkbenchComponent)this.getComponents().get(0)).getName().equals(aDeployName) ? (WorkbenchComponent)this.getComponents().get(0) : null;
        }
        if (!this.isIndexed()) {
            this.indexModules();
        }
        return (WorkbenchComponent)this.getModulesIndex().get(aDeployName);
    }

    private boolean isIndexed() {
        return this.isIndexed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexModules() {
        if (this.isIndexed) {
            return;
        }
        Map map = this.modulesIndex;
        synchronized (map) {
            Object adapter = EcoreUtil.getAdapter((List)this.eAdapters(), ModuleIndexingAdapter.class);
            if (adapter == null) {
                adapter = new ModuleIndexingAdapter();
                this.eAdapters().add(adapter);
            }
            WorkbenchComponent module2 = null;
            for (WorkbenchComponent module2 : this.getComponents()) {
                this.modulesIndex.put(module2.getName(), module2);
            }
        }
        this.isIndexed = true;
    }

    Map getModulesIndex() {
        return this.modulesIndex;
    }
}

