/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.ui.screenshots;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.commons.ui.screenshots.Messages;
import org.eclipse.mylyn.internal.commons.ui.screenshots.ScreenshotImages;
import org.eclipse.mylyn.internal.commons.ui.screenshots.SelectToolAction;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

public class ScreenshotViewer {
    private SelectToolAction captureAction;
    private SelectToolAction fitAction;
    private IAction cropAction;
    private IAction markAction;
    private IAction clearAction;
    private IAction undoAction;
    private IAction redoAction;
    private Composite paletteArea;
    private int lastDrawAction;
    private IDialogSettings dialogSettings;
    private SelectToolAction drawLineToolbar;
    private SelectToolAction drawArrowToolbar;
    private SelectToolAction drawBoxToolbar;
    private SelectToolAction drawTextToolbar;
    private SelectToolAction lineTypeToolbar;
    private SelectToolAction lineBoldToolbar;
    private SelectToolAction drawColorToolbar;
    private boolean dirty;
    private Image originalImage;
    private Image workImage;
    private Image previousImage;
    private GC workImageGC;
    private Canvas canvas;
    private ScrolledComposite scrolledComposite;
    private Rectangle currentSelection;
    private Rectangle originalSelection;
    private Point startPoint;
    private Set<SelectionSide> resizableSides = EnumSet.noneOf(SelectionSide.class);
    private double scaleFactor = 1.0;
    private final Map<Integer, Cursor> cursors = new HashMap<Integer, Cursor>();
    private EditorAction currentAction = EditorAction.CROPPING;
    private boolean isFirstCapture = true;
    private Text textArea;
    private List<int[]> historyMouseEvent = new ArrayList<int[]>();
    private List<int[]> historyDrawTool = new ArrayList<int[]>();
    private List<StringBuffer> historyDrawText = new ArrayList<StringBuffer>();
    private List<String> historyDrawFont = new ArrayList<String>();
    private int historyCheckpoint = 0;
    private ViewForm vf;
    private static final int CURSOR_MARK_TOOL = -1;
    private static final int INITIAL_CAPTURE_DELAY = 400;
    private static final String DEFAULT_DELAY = "2";
    private static final String DELAY_DIALOG_KEY = "ScreenshotViewerDelayDialog";
    private static final String DELAY_DIALOG_DELAY_VALUE = "DelayValue";
    private static final int[][] grapGroupPoints;
    private static final int[] grapScanOrder;
    private static final int[] grabPointCurosr;
    private static final SelectionSide[][] grabPointResizableSides;
    private static final int SQUARE_SIZE = 3;

    static {
        int[][] nArrayArray = new int[16][];
        nArrayArray[0] = new int[3];
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 2;
        nArray2[2] = 1;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 3;
        nArray3[2] = 2;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = 4;
        nArray4[2] = 2;
        nArrayArray[4] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[1] = 1;
        nArrayArray[5] = nArray5;
        nArrayArray[6] = new int[]{4, 1, 2};
        int[] nArray6 = new int[3];
        nArray6[1] = 2;
        nArray6[2] = 3;
        nArrayArray[7] = nArray6;
        nArrayArray[8] = new int[]{4, 2, 4};
        int[] nArray7 = new int[3];
        nArray7[1] = 3;
        nArray7[2] = 5;
        nArrayArray[9] = nArray7;
        nArrayArray[10] = new int[]{4, 3, 7};
        int[] nArray8 = new int[3];
        nArray8[1] = 4;
        nArray8[2] = 5;
        nArrayArray[11] = nArray8;
        nArrayArray[12] = new int[]{1, 4, 5};
        nArrayArray[13] = new int[]{2, 4, 6};
        nArrayArray[14] = new int[]{3, 4, 7};
        nArrayArray[15] = new int[]{4, 4, 7};
        grapGroupPoints = nArrayArray;
        int[] nArray9 = new int[5];
        nArray9[1] = 4;
        nArray9[2] = 1;
        nArray9[3] = 3;
        nArray9[4] = 2;
        grapScanOrder = nArray9;
        grabPointCurosr = new int[]{8, 7, 6, 9, 9, 6, 7, 8};
        grabPointResizableSides = new SelectionSide[][]{{SelectionSide.LEFT, SelectionSide.TOP}, {SelectionSide.TOP}, {SelectionSide.TOP, SelectionSide.RIGHT}, {SelectionSide.LEFT}, {SelectionSide.RIGHT}, {SelectionSide.LEFT, SelectionSide.BOTTOM}, {SelectionSide.BOTTOM}, {SelectionSide.BOTTOM, SelectionSide.RIGHT}};
    }

    public ScreenshotViewer(Composite parent, int style) {
        this.createControl(parent, style);
    }

    public Control getControl() {
        return this.vf;
    }

    private void doDispose() {
        this.disposeImageResources();
        this.canvas.setCursor(null);
        for (Cursor cursor : this.cursors.values()) {
            cursor.dispose();
        }
    }

    private void createControl(Composite parent, int style) {
        this.vf = new ViewForm(parent, style);
        this.vf.horizontalSpacing = 0;
        this.vf.verticalSpacing = 0;
        this.vf.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.vf.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ScreenshotViewer.this.doDispose();
            }
        });
        this.allocateCursors();
        ToolBarManager tbm = new ToolBarManager(8519936);
        this.captureAction = new SelectToolAction((Composite)this.getShell(), Messages.ScreenshotCreationPage_Capture_Desktop_C, 1){

            public void run() {
                if (ScreenshotViewer.this.captureAction.getSelect() == 0) {
                    ScreenshotViewer.this.captureScreenshotContent(400);
                } else if (ScreenshotViewer.this.captureAction.getSelect() == 4) {
                    ScreenshotViewer.this.captureScreenshotContentDelayed();
                } else if (ScreenshotViewer.this.captureAction.getSelect() == 1) {
                    ScreenshotViewer.this.captureScreenshotContent(ScreenshotViewer.this.captureAction.getClipboardImage());
                } else if (ScreenshotViewer.this.captureAction.getSelect() == 3) {
                    ScreenshotViewer.this.captureScreenshotContentFromSelection();
                } else {
                    ScreenshotViewer.this.captureScreenshotContent(ScreenshotViewer.this.captureAction.getFileImage());
                }
                if (ScreenshotViewer.this.isFirstCapture) {
                    ScreenshotViewer.this.isFirstCapture = false;
                    ScreenshotViewer.this.fitAction.setEnabled(true);
                    ScreenshotViewer.this.cropAction.setEnabled(true);
                    ScreenshotViewer.this.cropAction.setChecked(true);
                    ScreenshotViewer.this.markAction.setEnabled(true);
                    ScreenshotViewer.this.drawLineToolbar.setEnabled(true);
                    ScreenshotViewer.this.drawArrowToolbar.setEnabled(true);
                    ScreenshotViewer.this.drawBoxToolbar.setEnabled(true);
                    ScreenshotViewer.this.drawTextToolbar.setEnabled(true);
                }
                ScreenshotViewer.this.historyMouseEvent = new ArrayList();
                ScreenshotViewer.this.historyDrawTool = new ArrayList();
                ScreenshotViewer.this.historyDrawText = new ArrayList();
                ScreenshotViewer.this.historyDrawFont = new ArrayList();
                ScreenshotViewer.this.historyCheckpoint = 0;
                ScreenshotViewer.this.undoAction.setEnabled(false);
                ScreenshotViewer.this.redoAction.setEnabled(false);
                ScreenshotViewer.this.clearAction.setEnabled(false);
            }

            protected boolean isEnableRectangle() {
                return ScreenshotViewer.this.currentSelection != null;
            }
        };
        this.captureAction.setToolTipText(Messages.ScreenshotCreationPage_Capture_Desktop);
        this.captureAction.setImageDescriptor(ScreenshotImages.IMAGE_CAPTURE);
        this.captureAction.setShowMenuAlways(false);
        this.fitAction = new SelectToolAction(Messages.ScreenshotCreationPage_Fit_Image_F, 2){

            public void run() {
                ScreenshotViewer.this.refreshCanvasSize();
            }
        };
        this.fitAction.setToolTipText(Messages.ScreenshotCreationPage_Fit_Image);
        this.fitAction.setImageDescriptor(ScreenshotImages.IMAGE_FIT);
        this.fitAction.setEnabled(false);
        this.cropAction = new Action(Messages.ScreenshotCreationPage_Crop_R, 8){

            public void run() {
                ScreenshotViewer.this.currentAction = EditorAction.CROPPING;
                ScreenshotViewer.this.cropAction.setChecked(true);
                ScreenshotViewer.this.markAction.setChecked(false);
                ScreenshotViewer.this.canvas.redraw();
            }
        };
        this.cropAction.setToolTipText(Messages.ScreenshotCreationPage_Crop);
        this.cropAction.setImageDescriptor(ScreenshotImages.CUT);
        this.cropAction.setEnabled(false);
        this.markAction = new Action(Messages.ScreenshotCreationPage_Annotate, 8){

            public void setChecked(boolean checked) {
                super.setChecked(checked);
                if (ScreenshotViewer.this.paletteArea != null) {
                    if (checked) {
                        if (ScreenshotViewer.this.getSelectDrawToolbar() < 0) {
                            ScreenshotViewer.this.setSelectDrawToolbar(ScreenshotViewer.this.lastDrawAction);
                        }
                    } else {
                        int select = ScreenshotViewer.this.getSelectDrawToolbar();
                        if (select >= 0) {
                            ScreenshotViewer.this.lastDrawAction = select;
                            ScreenshotViewer.this.unselectDrawToolbar();
                        }
                    }
                    boolean isDrawText = ScreenshotViewer.this.drawTextToolbar.getSelect() >= 0 ? false : checked;
                    ScreenshotViewer.this.drawColorToolbar.setEnabled(isDrawText);
                    ScreenshotViewer.this.lineTypeToolbar.setEnabled(isDrawText);
                    ScreenshotViewer.this.lineBoldToolbar.setEnabled(isDrawText);
                }
            }

            public void run() {
                ScreenshotViewer.this.currentAction = EditorAction.MARKING;
                ScreenshotViewer.this.cropAction.setChecked(false);
                ScreenshotViewer.this.markAction.setChecked(true);
                ScreenshotViewer.this.canvas.redraw();
            }
        };
        this.markAction.setToolTipText(Messages.ScreenshotCreationPage_DRAW_ANNOTATION_ON_SCREENSHOT_IMAGE);
        this.markAction.setImageDescriptor(ScreenshotImages.EDIT);
        this.markAction.setEnabled(false);
        this.clearAction = new Action(Messages.ScreenshotCreationPage_Clear, 1){

            public void run() {
                ScreenshotViewer.this.clearAction.setEnabled(false);
                ScreenshotViewer.this.workImageGC.drawImage(ScreenshotViewer.this.originalImage, 0, 0);
                ScreenshotViewer.this.canvas.redraw();
                ScreenshotViewer.this.setDirty(true);
                ScreenshotViewer.this.historyMouseEvent = new ArrayList();
                ScreenshotViewer.this.historyDrawTool = new ArrayList();
                ScreenshotViewer.this.historyDrawText = new ArrayList();
                ScreenshotViewer.this.historyDrawFont = new ArrayList();
                ScreenshotViewer.this.historyCheckpoint = 0;
                ScreenshotViewer.this.undoAction.setEnabled(false);
                ScreenshotViewer.this.redoAction.setEnabled(false);
            }
        };
        this.clearAction.setToolTipText(Messages.ScreenshotCreationPage_Clear_all_annotations_made_on_screenshot_image);
        this.clearAction.setImageDescriptor(ScreenshotImages.CLEAR);
        this.clearAction.setEnabled(false);
        this.undoAction = new Action(Messages.ScreenshotCreationPage_Undo){

            public void run() {
                if (ScreenshotViewer.this.historyCheckpoint > 0) {
                    ScreenshotViewer screenshotViewer = ScreenshotViewer.this;
                    screenshotViewer.historyCheckpoint = screenshotViewer.historyCheckpoint - 1;
                    ScreenshotViewer.this.drawAnnotationHistory();
                }
                if (ScreenshotViewer.this.historyCheckpoint == 0) {
                    ScreenshotViewer.this.undoAction.setEnabled(false);
                }
                if (ScreenshotViewer.this.historyCheckpoint < ScreenshotViewer.this.historyDrawTool.size()) {
                    ScreenshotViewer.this.redoAction.setEnabled(true);
                }
            }
        };
        this.undoAction.setToolTipText(Messages.ScreenshotCreationPage_Undo_annotation);
        this.undoAction.setImageDescriptor(ScreenshotImages.UNDO);
        this.undoAction.setEnabled(false);
        this.redoAction = new Action(Messages.ScreenshotCreationPage_Redo){

            public void run() {
                if (ScreenshotViewer.this.historyCheckpoint < ScreenshotViewer.this.historyDrawTool.size()) {
                    ScreenshotViewer screenshotViewer = ScreenshotViewer.this;
                    screenshotViewer.historyCheckpoint = screenshotViewer.historyCheckpoint + 1;
                    ScreenshotViewer.this.drawAnnotationHistory();
                }
                if (ScreenshotViewer.this.historyCheckpoint > 0) {
                    ScreenshotViewer.this.undoAction.setEnabled(true);
                }
                if (ScreenshotViewer.this.historyCheckpoint >= ScreenshotViewer.this.historyDrawTool.size()) {
                    ScreenshotViewer.this.redoAction.setEnabled(false);
                }
            }
        };
        this.redoAction.setToolTipText(Messages.ScreenshotCreationPage_Redo_annotation);
        this.redoAction.setImageDescriptor(ScreenshotImages.REDO);
        this.redoAction.setEnabled(false);
        tbm.add((IContributionItem)this.createAndConfigureCI((IAction)this.captureAction));
        tbm.add((IContributionItem)new Separator());
        tbm.add((IContributionItem)this.createAndConfigureCI((IAction)this.fitAction));
        tbm.add((IContributionItem)this.createAndConfigureCI(this.cropAction));
        tbm.add((IContributionItem)this.createAndConfigureCI(this.markAction));
        tbm.add((IContributionItem)new Separator());
        tbm.add((IContributionItem)this.createAndConfigureCI(this.clearAction));
        tbm.add((IContributionItem)this.createAndConfigureCI(this.undoAction));
        tbm.add((IContributionItem)this.createAndConfigureCI(this.redoAction));
        tbm.add((IContributionItem)new Separator());
        Composite body = new Composite((Composite)this.vf, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        body.setLayout((Layout)layout);
        this.createPaletteBars(body);
        this.lastDrawAction = this.getSelectDrawToolbar();
        this.unselectDrawToolbar();
        this.scrolledComposite = new ScrolledComposite(body, 768);
        this.scrolledComposite.setLayoutData((Object)new GridData(1808));
        this.canvas = new Canvas((Composite)this.scrolledComposite, 0x20000000);
        this.scrolledComposite.setContent((Control)this.canvas);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ScreenshotViewer.this.workImage != null) {
                    Rectangle imageBounds = ScreenshotViewer.this.workImage.getBounds();
                    Rectangle canvasBounds = ScreenshotViewer.this.canvas.getClientArea();
                    int zoom = ScreenshotViewer.this.fitAction.getSelect();
                    switch (zoom) {
                        case 0: {
                            e.gc.drawImage(ScreenshotViewer.this.workImage, 0, 0, imageBounds.width, imageBounds.height, 0, 0, canvasBounds.width, canvasBounds.height);
                            break;
                        }
                        case 50: {
                            e.gc.drawImage(ScreenshotViewer.this.workImage, 0, 0, imageBounds.width, imageBounds.height, 0, 0, imageBounds.width / 2, imageBounds.height / 2);
                            break;
                        }
                        case 100: {
                            e.gc.drawImage(ScreenshotViewer.this.workImage, 0, 0);
                            break;
                        }
                        default: {
                            e.gc.drawImage(ScreenshotViewer.this.workImage, 0, 0, imageBounds.width, imageBounds.height, 0, 0, imageBounds.width * zoom / 100, imageBounds.height * zoom / 100);
                        }
                    }
                    ScreenshotViewer.this.drawSelection(e.gc);
                } else {
                    ScreenshotViewer.this.fitAction.setEnabled(false);
                }
            }
        });
        this.scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (ScreenshotViewer.this.fitAction.getSelect() == 0) {
                    ScreenshotViewer.this.refreshCanvasSize();
                }
            }
        });
        this.scrolledComposite.setEnabled(false);
        ToolBar control = tbm.createControl((Composite)this.vf);
        this.vf.setTopLeft((Control)control);
        this.vf.setContent((Control)body);
        this.registerMouseListeners();
        this.vf.setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)this.vf);
    }

    private Shell getShell() {
        return this.getControl().getShell();
    }

    private void createPaletteBars(Composite body) {
        this.paletteArea = new Composite(body, 0);
        this.paletteArea.setLayoutData((Object)new GridData(1040));
        RowLayout rowlayout = new RowLayout(512);
        ++rowlayout.marginRight;
        this.paletteArea.setLayout((Layout)rowlayout);
        this.paletteArea.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                Color gcForeground = e.gc.getForeground();
                Rectangle bounds = ((Composite)e.widget).getBounds();
                Color border = e.widget.getDisplay().getSystemColor(18);
                e.gc.setForeground(border);
                e.gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height);
                e.gc.setForeground(gcForeground);
            }
        });
        this.paletteArea.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                Menu rightClickMenu = new Menu((Decorations)Display.getDefault().getActiveShell(), 8);
                MenuItem menuItem = new MenuItem(rightClickMenu, 32);
                menuItem.setText(Messages.ScreenshotCreationPage_Show_Line_Type_Selector);
                menuItem.setSelection(ScreenshotViewer.this.lineTypeToolbar.getVisible());
                menuItem.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        ScreenshotViewer.this.lineTypeToolbar.setVisible(!ScreenshotViewer.this.lineTypeToolbar.getVisible());
                        ScreenshotViewer.this.paletteArea.layout();
                    }
                });
                menuItem = new MenuItem(rightClickMenu, 32);
                menuItem.setText(Messages.ScreenshotCreationPage_Show_Line_Bold_Selector);
                menuItem.setSelection(ScreenshotViewer.this.lineBoldToolbar.getVisible());
                menuItem.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        ScreenshotViewer.this.lineBoldToolbar.setVisible(!ScreenshotViewer.this.lineBoldToolbar.getVisible());
                        ScreenshotViewer.this.paletteArea.layout();
                    }
                });
                rightClickMenu.setLocation(e.x, e.y);
                rightClickMenu.setVisible(true);
            }
        });
        this.drawLineToolbar = new SelectToolAction(this.paletteArea, 3){

            public void run() {
                ScreenshotViewer.this.markAction.run();
                ScreenshotViewer.this.drawArrowToolbar.setUnselect();
                ScreenshotViewer.this.drawBoxToolbar.setUnselect();
                ScreenshotViewer.this.drawTextToolbar.setUnselect();
                ScreenshotViewer.this.drawColorToolbar.setEnabled(true);
                ScreenshotViewer.this.lineTypeToolbar.setEnabled(true);
                ScreenshotViewer.this.lineBoldToolbar.setEnabled(true);
            }
        };
        this.drawLineToolbar.setEnabled(false);
        this.drawArrowToolbar = new SelectToolAction(this.paletteArea, 4){

            public void run() {
                ScreenshotViewer.this.markAction.run();
                ScreenshotViewer.this.drawLineToolbar.setUnselect();
                ScreenshotViewer.this.drawBoxToolbar.setUnselect();
                ScreenshotViewer.this.drawTextToolbar.setUnselect();
                ScreenshotViewer.this.drawColorToolbar.setEnabled(true);
                ScreenshotViewer.this.lineTypeToolbar.setEnabled(true);
                ScreenshotViewer.this.lineBoldToolbar.setEnabled(true);
            }
        };
        this.drawArrowToolbar.setEnabled(false);
        this.drawBoxToolbar = new SelectToolAction(this.paletteArea, 5){

            public void run() {
                ScreenshotViewer.this.markAction.run();
                ScreenshotViewer.this.drawLineToolbar.setUnselect();
                ScreenshotViewer.this.drawArrowToolbar.setUnselect();
                ScreenshotViewer.this.drawTextToolbar.setUnselect();
                ScreenshotViewer.this.drawColorToolbar.setEnabled(true);
                ScreenshotViewer.this.lineTypeToolbar.setEnabled(true);
                ScreenshotViewer.this.lineBoldToolbar.setEnabled(true);
            }
        };
        this.drawBoxToolbar.setEnabled(false);
        this.drawTextToolbar = new SelectToolAction(this.paletteArea, 6){

            public void run() {
                ScreenshotViewer.this.markAction.run();
                ScreenshotViewer.this.drawLineToolbar.setUnselect();
                ScreenshotViewer.this.drawArrowToolbar.setUnselect();
                ScreenshotViewer.this.drawBoxToolbar.setUnselect();
                ScreenshotViewer.this.drawColorToolbar.setEnabled(false);
                ScreenshotViewer.this.lineTypeToolbar.setEnabled(false);
                ScreenshotViewer.this.lineBoldToolbar.setEnabled(false);
            }
        };
        this.drawTextToolbar.setEnabled(false);
        this.drawColorToolbar = new SelectToolAction(this.paletteArea, 9);
        this.drawColorToolbar.setEnabled(false);
        this.lineTypeToolbar = new SelectToolAction(this.paletteArea, 7);
        this.lineTypeToolbar.setEnabled(false);
        this.lineTypeToolbar.setVisible(false);
        this.lineBoldToolbar = new SelectToolAction(this.paletteArea, 8);
        this.lineBoldToolbar.setEnabled(false);
        this.lineBoldToolbar.setVisible(false);
    }

    private void setSelectDrawToolbar(int drawTool) {
        if (this.drawLineToolbar.setSelect(drawTool)) {
            this.drawArrowToolbar.setUnselect();
            this.drawBoxToolbar.setUnselect();
            this.drawTextToolbar.setUnselect();
            return;
        }
        if (this.drawArrowToolbar.setSelect(drawTool)) {
            this.drawLineToolbar.setUnselect();
            this.drawBoxToolbar.setUnselect();
            this.drawTextToolbar.setUnselect();
            return;
        }
        if (this.drawBoxToolbar.setSelect(drawTool)) {
            this.drawLineToolbar.setUnselect();
            this.drawArrowToolbar.setUnselect();
            this.drawTextToolbar.setUnselect();
            return;
        }
        this.drawLineToolbar.setUnselect();
        this.drawArrowToolbar.setUnselect();
        this.drawBoxToolbar.setUnselect();
        this.drawTextToolbar.setSelect(drawTool);
    }

    private void unselectDrawToolbar() {
        this.drawLineToolbar.setUnselect();
        this.drawArrowToolbar.setUnselect();
        this.drawBoxToolbar.setUnselect();
        this.drawTextToolbar.setUnselect();
    }

    private int getSelectDrawToolbar() {
        int drawTool = this.drawLineToolbar.getSelect();
        if (drawTool >= 0) {
            return drawTool;
        }
        drawTool = this.drawArrowToolbar.getSelect();
        if (drawTool >= 0) {
            return drawTool;
        }
        drawTool = this.drawBoxToolbar.getSelect();
        if (drawTool >= 0) {
            return drawTool;
        }
        drawTool = this.drawTextToolbar.getSelect();
        if (drawTool >= 0) {
            return drawTool;
        }
        return -1;
    }

    private ActionContributionItem createAndConfigureCI(IAction action) {
        ActionContributionItem ci = new ActionContributionItem(action);
        ci.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        return ci;
    }

    private void disposeImageResources() {
        if (this.originalImage != null) {
            this.originalImage.dispose();
        }
        if (this.workImageGC != null) {
            this.workImageGC.dispose();
        }
        if (this.workImage != null) {
            this.workImage.dispose();
        }
    }

    private void allocateCursors() {
        Display display = this.getShell().getDisplay();
        this.cursors.put(0, new Cursor((Device)display, 0));
        this.cursors.put(5, new Cursor((Device)display, 5));
        this.cursors.put(8, new Cursor((Device)display, 8));
        this.cursors.put(6, new Cursor((Device)display, 6));
        this.cursors.put(7, new Cursor((Device)display, 7));
        this.cursors.put(9, new Cursor((Device)display, 9));
        this.cursors.put(2, new Cursor((Device)display, 2));
        this.cursors.put(-1, new Cursor((Device)display, 21));
    }

    private Rectangle getScaledSelection() {
        if (this.currentSelection == null) {
            return null;
        }
        int x = (int)Math.round((double)this.currentSelection.x * this.scaleFactor);
        int y = (int)Math.round((double)this.currentSelection.y * this.scaleFactor);
        int right = (int)Math.round((double)(this.currentSelection.x + this.currentSelection.width) * this.scaleFactor);
        int bottom = (int)Math.round((double)(this.currentSelection.y + this.currentSelection.height) * this.scaleFactor);
        int width = Math.min(right, (int)Math.round((double)this.workImage.getBounds().width * this.scaleFactor)) - x;
        int height = Math.min(bottom, (int)Math.round((double)this.workImage.getBounds().height * this.scaleFactor)) - y;
        return new Rectangle(x, y, width, height);
    }

    private Rectangle getOutsideSelection(Rectangle rectangle) {
        if (rectangle == null) {
            return null;
        }
        return new Rectangle(rectangle.x - 6, rectangle.y - 6, rectangle.width + 12 + 1, rectangle.height + 12 + 1);
    }

    private int getGrabPoint(int x, int y) {
        int element;
        if (this.currentSelection == null) {
            return -1;
        }
        Rectangle inside = this.getScaledSelection();
        Rectangle outside = this.getOutsideSelection(inside);
        int[] xGroupPoint = new int[]{outside.x, inside.x, inside.x + 12, inside.x + inside.width - 12, inside.x + inside.width, outside.x + outside.width};
        int[] yGroupPoint = new int[]{outside.y, inside.y, inside.y + 12, inside.y + inside.height - 12, inside.y + inside.height, outside.y + outside.height};
        int xGroup = -1;
        int yGroup = -1;
        Object object = grapScanOrder;
        int n = grapScanOrder.length;
        int n2 = 0;
        while (n2 < n) {
            element = object[n2];
            if (xGroupPoint[element] <= x && x <= xGroupPoint[element + 1]) {
                xGroup = element;
                break;
            }
            ++n2;
        }
        if (xGroup < 0) {
            return -1;
        }
        object = grapScanOrder;
        n = grapScanOrder.length;
        n2 = 0;
        while (n2 < n) {
            element = object[n2];
            if (yGroupPoint[element] <= y && y <= yGroupPoint[element + 1]) {
                yGroup = element;
                break;
            }
            ++n2;
        }
        if (yGroup < 0) {
            return -1;
        }
        object = grapGroupPoints;
        n = grapGroupPoints.length;
        n2 = 0;
        while (n2 < n) {
            int element2 = object[n2];
            if (element2[0] == xGroup && element2[1] == yGroup) {
                return (int)element2[2];
            }
            ++n2;
        }
        return -1;
    }

    public boolean isComplete() {
        return this.workImage != null;
    }

    private void captureScreenshotContent(Image image) {
        Display display = this.getShell().getDisplay();
        this.disposeImageResources();
        this.originalImage = image;
        Rectangle displayBounds = this.originalImage.getBounds();
        this.workImage = new Image((Device)display, displayBounds.width, displayBounds.height);
        GC gc = new GC((Drawable)this.workImage);
        gc.drawImage(this.originalImage, 0, 0);
        gc.dispose();
        this.workImageGC = new GC((Drawable)this.workImage);
        this.workImageGC.setLineCap(2);
        this.scrolledComposite.setEnabled(true);
        this.clearSelection();
        this.refreshCanvasSize();
        this.stateChanged();
    }

    protected void stateChanged() {
    }

    private void captureScreenshotContentFromSelection() {
        Display display = this.getShell().getDisplay();
        Image image = new Image((Device)display, this.currentSelection);
        GC gc = new GC((Drawable)image);
        gc.drawImage(this.workImage, this.currentSelection.x, this.currentSelection.y, this.currentSelection.width, this.currentSelection.height, 0, 0, this.currentSelection.width, this.currentSelection.height);
        gc.dispose();
        this.disposeImageResources();
        this.originalImage = image;
        Rectangle displayBounds = this.originalImage.getBounds();
        this.workImage = new Image((Device)display, displayBounds.width, displayBounds.height);
        gc = new GC((Drawable)this.workImage);
        gc.drawImage(this.originalImage, 0, 0);
        gc.dispose();
        this.workImageGC = new GC((Drawable)this.workImage);
        this.workImageGC.setLineCap(2);
        this.scrolledComposite.setEnabled(true);
        this.clearSelection();
        this.refreshCanvasSize();
        this.stateChanged();
    }

    private void captureScreenshotContent(int delay) {
        final Display display = this.getShell().getDisplay();
        final Shell wizardShell = this.getShell();
        wizardShell.setVisible(false);
        this.getShell().getDisplay().timerExec(delay, new Runnable(){

            public void run() {
                ScreenshotViewer.this.disposeImageResources();
                Rectangle displayBounds = display.getBounds();
                ScreenshotViewer.this.originalImage = new Image((Device)display, displayBounds.width, displayBounds.height);
                ScreenshotViewer.this.workImage = new Image((Device)display, displayBounds.width, displayBounds.height);
                GC gc = new GC((Drawable)display);
                gc.copyArea(ScreenshotViewer.this.originalImage, displayBounds.x, displayBounds.y);
                gc.copyArea(ScreenshotViewer.this.workImage, displayBounds.x, displayBounds.y);
                gc.dispose();
                ScreenshotViewer.this.workImageGC = new GC((Drawable)ScreenshotViewer.this.workImage);
                ScreenshotViewer.this.workImageGC.setLineCap(2);
                ScreenshotViewer.this.scrolledComposite.setEnabled(true);
                ScreenshotViewer.this.clearSelection();
                ScreenshotViewer.this.refreshCanvasSize();
                wizardShell.setVisible(true);
                ScreenshotViewer.this.stateChanged();
            }
        });
    }

    private void captureScreenshotContentDelayed() {
        IInputValidator delayValidator = new IInputValidator(){

            public String isValid(String newText) {
                try {
                    int result = Integer.parseInt(newText);
                    if (result > 0) {
                        return null;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                return Messages.ScreenshotViewer_EnterValidSeconds;
            }
        };
        String delay = this.getDelayFromSettings(DEFAULT_DELAY);
        InputDialog delayDialog = new InputDialog(this.getShell(), Messages.ScreenshotViewer_Delay, Messages.ScreenshotViewer_EnterDelayForScreenshot, delay, delayValidator);
        int resultCode = delayDialog.open();
        if (resultCode == 0) {
            this.storeDelaySetting(delayDialog.getValue());
            int newDelay = Integer.parseInt(delayDialog.getValue());
            int newDelayInMs = newDelay * 1000;
            this.captureScreenshotContent(400 + newDelayInMs);
        }
    }

    private void storeDelaySetting(String value) {
        if (this.dialogSettings != null) {
            IDialogSettings section = this.dialogSettings.getSection(DELAY_DIALOG_KEY);
            if (section == null) {
                section = this.dialogSettings.addNewSection(DELAY_DIALOG_KEY);
            }
            section.put(DELAY_DIALOG_DELAY_VALUE, value);
        }
    }

    private String getDelayFromSettings(String defaultValue) {
        IDialogSettings section;
        String delay = defaultValue;
        if (this.dialogSettings != null && (section = this.dialogSettings.getSection(DELAY_DIALOG_KEY)) != null) {
            int lastDelay = section.getInt(DELAY_DIALOG_DELAY_VALUE);
            delay = String.valueOf(lastDelay);
        }
        return delay;
    }

    public void setDialogSettings(IDialogSettings dialogSettings) {
        this.dialogSettings = dialogSettings;
    }

    public IDialogSettings getDialogSettings() {
        return this.dialogSettings;
    }

    private void refreshCurrentSelection(int x, int y) {
        int startX = Math.min(this.startPoint.x, x);
        int startY = Math.min(this.startPoint.y, y);
        int width = Math.abs(this.startPoint.x - x);
        int height = Math.abs(this.startPoint.y - y);
        this.currentSelection = new Rectangle(startX, startY, width, height);
        Rectangle imageBounds = this.workImage.getBounds();
        --imageBounds.width;
        --imageBounds.height;
        this.currentSelection.intersect(imageBounds);
    }

    private void refreshSelectionResize(int x, int y) {
        this.currentSelection = new Rectangle(this.originalSelection.x, this.originalSelection.y, this.originalSelection.width, this.originalSelection.height);
        int deltaX = x - this.startPoint.x;
        int deltaY = y - this.startPoint.y;
        Rectangle imageBounds = this.workImage.getBounds();
        if (this.resizableSides.contains((Object)SelectionSide.LEFT) && this.originalSelection.x + (deltaX = Math.min(deltaX, this.originalSelection.width)) < 0) {
            deltaX = -this.originalSelection.x;
        }
        if (this.resizableSides.contains((Object)SelectionSide.RIGHT) && this.originalSelection.x + this.originalSelection.width + (deltaX = Math.max(deltaX, -this.originalSelection.width)) > imageBounds.width) {
            deltaX = imageBounds.width - (this.originalSelection.x + this.originalSelection.width);
        }
        if (this.resizableSides.contains((Object)SelectionSide.TOP) && this.originalSelection.y + (deltaY = Math.min(deltaY, this.originalSelection.height)) < 0) {
            deltaY = -this.originalSelection.y;
        }
        if (this.resizableSides.contains((Object)SelectionSide.BOTTOM) && this.originalSelection.y + this.originalSelection.height + (deltaY = Math.max(deltaY, -this.originalSelection.height)) > imageBounds.height) {
            deltaY = imageBounds.height - (this.originalSelection.y + this.originalSelection.height);
        }
        if (this.resizableSides.contains((Object)SelectionSide.LEFT)) {
            this.currentSelection.x += deltaX;
            this.currentSelection.width -= deltaX;
        }
        if (this.resizableSides.contains((Object)SelectionSide.RIGHT)) {
            this.currentSelection.width += deltaX;
        }
        if (this.resizableSides.contains((Object)SelectionSide.TOP)) {
            this.currentSelection.y += deltaY;
            this.currentSelection.height -= deltaY;
        }
        if (this.resizableSides.contains((Object)SelectionSide.BOTTOM)) {
            this.currentSelection.height += deltaY;
        }
    }

    private void refreshSelectionPosition(int x, int y) {
        int newX = this.originalSelection.x + (x - this.startPoint.x);
        int newY = this.originalSelection.y + (y - this.startPoint.y);
        if (newX < 0) {
            newX = 0;
        }
        if (newY < 0) {
            newY = 0;
        }
        Rectangle imageBounds = this.workImage.getBounds();
        if (newX + this.originalSelection.width > imageBounds.width) {
            newX = imageBounds.width - this.originalSelection.width;
        }
        if (newY + this.originalSelection.height > imageBounds.height) {
            newY = imageBounds.height - this.originalSelection.height;
        }
        this.currentSelection = new Rectangle(newX, newY, this.originalSelection.width, this.originalSelection.height);
    }

    private void registerMouseListeners() {
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                int scaledX = (int)Math.round((double)e.x / ScreenshotViewer.this.scaleFactor);
                int scaledY = (int)Math.round((double)e.y / ScreenshotViewer.this.scaleFactor);
                if (ScreenshotViewer.this.currentAction == EditorAction.SELECTING) {
                    ScreenshotViewer.this.refreshCurrentSelection(scaledX, scaledY);
                    ScreenshotViewer.this.canvas.redraw();
                } else if (ScreenshotViewer.this.currentAction == EditorAction.RESIZING_SELECTION) {
                    ScreenshotViewer.this.refreshSelectionResize(scaledX, scaledY);
                    ScreenshotViewer.this.canvas.redraw();
                } else if (ScreenshotViewer.this.currentAction == EditorAction.MOVING_SELECTION) {
                    ScreenshotViewer.this.refreshSelectionPosition(scaledX, scaledY);
                    ScreenshotViewer.this.canvas.redraw();
                } else if (ScreenshotViewer.this.currentAction == EditorAction.CROPPING && ScreenshotViewer.this.currentSelection != null) {
                    boolean cursorSet = false;
                    int info = ScreenshotViewer.this.getGrabPoint(e.x, e.y);
                    if (info >= 0) {
                        ScreenshotViewer.this.canvas.setCursor((Cursor)ScreenshotViewer.this.cursors.get(grabPointCurosr[info]));
                        cursorSet = true;
                    }
                    if (!cursorSet && ScreenshotViewer.this.getScaledSelection().contains(e.x, e.y)) {
                        ScreenshotViewer.this.canvas.setCursor((Cursor)ScreenshotViewer.this.cursors.get(5));
                        cursorSet = true;
                    }
                    Cursor crossCursor = (Cursor)ScreenshotViewer.this.cursors.get(2);
                    if (!cursorSet && ScreenshotViewer.this.canvas.getCursor() != crossCursor) {
                        ScreenshotViewer.this.canvas.setCursor(crossCursor);
                    }
                } else if (ScreenshotViewer.this.currentAction == EditorAction.MARKING) {
                    if (ScreenshotViewer.this.startPoint != null) {
                        int drawTool = ScreenshotViewer.this.getSelectDrawToolbar();
                        if (drawTool == 0) {
                            int[] history = new int[]{5, scaledX, scaledY};
                            ScreenshotViewer.this.historyMouseEvent.add(history);
                        } else {
                            int[] history = (int[])ScreenshotViewer.this.historyMouseEvent.get(ScreenshotViewer.this.historyMouseEvent.size() - 1);
                            if (history[0] == 5) {
                                history[1] = scaledX;
                                history[2] = scaledY;
                            } else {
                                history = new int[]{5, scaledX, scaledY};
                                ScreenshotViewer.this.historyMouseEvent.add(history);
                            }
                        }
                    }
                    ScreenshotViewer.this.drawMarkLine(scaledX, scaledY);
                    Cursor markCursor = (Cursor)ScreenshotViewer.this.cursors.get(-1);
                    if (ScreenshotViewer.this.canvas.getCursor() != markCursor) {
                        ScreenshotViewer.this.canvas.setCursor(markCursor);
                    }
                }
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (ScreenshotViewer.this.currentAction == EditorAction.SELECTING || ScreenshotViewer.this.currentAction == EditorAction.RESIZING_SELECTION || ScreenshotViewer.this.currentAction == EditorAction.MOVING_SELECTION) {
                    int scaledX = (int)Math.round((double)e.x / ScreenshotViewer.this.scaleFactor);
                    int scaledY = (int)Math.round((double)e.y / ScreenshotViewer.this.scaleFactor);
                    if (ScreenshotViewer.this.currentAction == EditorAction.SELECTING) {
                        ScreenshotViewer.this.refreshCurrentSelection(scaledX, scaledY);
                    } else if (ScreenshotViewer.this.currentAction == EditorAction.RESIZING_SELECTION) {
                        ScreenshotViewer.this.refreshSelectionResize(scaledX, scaledY);
                    } else if (ScreenshotViewer.this.currentAction == EditorAction.MOVING_SELECTION) {
                        ScreenshotViewer.this.refreshSelectionPosition(scaledX, scaledY);
                    }
                    if (((ScreenshotViewer)ScreenshotViewer.this).currentSelection.width == 0 && ((ScreenshotViewer)ScreenshotViewer.this).currentSelection.height == 0) {
                        ScreenshotViewer.this.currentSelection = null;
                    }
                    ScreenshotViewer.this.startPoint = null;
                    ScreenshotViewer.this.currentAction = EditorAction.CROPPING;
                    ScreenshotViewer.this.canvas.redraw();
                    ScreenshotViewer.this.setDirty(true);
                } else if (ScreenshotViewer.this.currentAction == EditorAction.MARKING) {
                    if (ScreenshotViewer.this.startPoint != null) {
                        int drawTool = ScreenshotViewer.this.getSelectDrawToolbar();
                        if (drawTool != 0) {
                            if (drawTool == 30) {
                                this.drawAnnotationText();
                            }
                            ScreenshotViewer.this.previousImage.dispose();
                            ScreenshotViewer.this.previousImage = null;
                        }
                        int[] history = new int[]{4, 0, 0};
                        ScreenshotViewer.this.historyMouseEvent.add(history);
                    }
                    ScreenshotViewer.this.startPoint = null;
                    ScreenshotViewer.this.setDirty(true);
                }
            }

            private void drawAnnotationText() {
                int endedPoint_y;
                int endedPoint_x;
                ScreenshotViewer.this.workImageGC.drawImage(ScreenshotViewer.this.previousImage, 0, 0);
                ScreenshotViewer.this.canvas.redraw();
                int[] history = (int[])ScreenshotViewer.this.historyMouseEvent.get(ScreenshotViewer.this.historyMouseEvent.size() - 1);
                if (history[0] != 5) {
                    ScreenshotViewer screenshotViewer = ScreenshotViewer.this;
                    screenshotViewer.historyCheckpoint = screenshotViewer.historyCheckpoint - 1;
                    ScreenshotViewer.this.updateAnnotationHistory();
                    return;
                }
                if (history[1] < ((ScreenshotViewer)ScreenshotViewer.this).startPoint.x) {
                    endedPoint_x = ((ScreenshotViewer)ScreenshotViewer.this).startPoint.x;
                    ((ScreenshotViewer)ScreenshotViewer.this).startPoint.x = history[1];
                } else {
                    endedPoint_x = history[1];
                }
                if (history[2] < ((ScreenshotViewer)ScreenshotViewer.this).startPoint.y) {
                    endedPoint_y = ((ScreenshotViewer)ScreenshotViewer.this).startPoint.y;
                    ((ScreenshotViewer)ScreenshotViewer.this).startPoint.y = history[2];
                } else {
                    endedPoint_y = history[2];
                }
                final Rectangle bounds = new Rectangle(((ScreenshotViewer)ScreenshotViewer.this).startPoint.x, ((ScreenshotViewer)ScreenshotViewer.this).startPoint.y, endedPoint_x - ((ScreenshotViewer)ScreenshotViewer.this).startPoint.x, endedPoint_y - ((ScreenshotViewer)ScreenshotViewer.this).startPoint.y);
                ScreenshotViewer.this.textArea = new Text((Composite)ScreenshotViewer.this.canvas, 66);
                int xs = (int)Math.round((double)((ScreenshotViewer)ScreenshotViewer.this).startPoint.x * ScreenshotViewer.this.scaleFactor);
                int ys = (int)Math.round((double)((ScreenshotViewer)ScreenshotViewer.this).startPoint.y * ScreenshotViewer.this.scaleFactor);
                int xe = (int)Math.round((double)endedPoint_x * ScreenshotViewer.this.scaleFactor);
                int ye = (int)Math.round((double)endedPoint_y * ScreenshotViewer.this.scaleFactor);
                ScreenshotViewer.this.textArea.setBounds(new Rectangle(xs, ys, xe - xs, ye - ys));
                FontData fontData = new FontData(ScreenshotViewer.this.drawTextToolbar.getStringCustom());
                if (ScreenshotViewer.this.scaleFactor != 1.0) {
                    fontData.setHeight((int)Math.round((double)fontData.getHeight() * ScreenshotViewer.this.scaleFactor));
                }
                ScreenshotViewer.this.textArea.setFont(new Font((Device)ScreenshotViewer.this.getShell().getDisplay(), fontData));
                ScreenshotViewer.this.textArea.setForeground(new Color((Device)ScreenshotViewer.this.getShell().getDisplay(), SelectToolAction.int2rgb(ScreenshotViewer.this.drawTextToolbar.getIntgerCustom())));
                ScreenshotViewer.this.textArea.setTabs(1);
                Point point = ScreenshotViewer.this.textArea.getCaretLocation();
                ScreenshotViewer.this.textArea.setBounds(new Rectangle(xs - point.x, ys, xe - xs + point.x + point.x, ye - ys));
                ScreenshotViewer.this.textArea.setFocus();
                ScreenshotViewer.this.textArea.addListener(27, new Listener(){

                    public void handleEvent(Event event) {
                        String line;
                        int currpos;
                        String text = ScreenshotViewer.this.textArea.getText();
                        String newtext = "";
                        int charpos = currpos = 0;
                        ScreenshotViewer.this.textArea.setTopIndex(0);
                        ScreenshotViewer.this.textArea.setSelection(currpos);
                        int linepos = ScreenshotViewer.this.textArea.getCaretLineNumber();
                        boolean remove1st = false;
                        while (currpos < text.length()) {
                            int y = ScreenshotViewer.this.textArea.getCaretLineNumber();
                            if (linepos != y) {
                                line = text.substring(charpos, currpos);
                                if (line.endsWith("\n")) {
                                    line = line.substring(0, line.length() - 1);
                                }
                                newtext = String.valueOf(newtext) + "\n" + line;
                                remove1st = true;
                                charpos = currpos;
                                linepos = y;
                            }
                            ScreenshotViewer.this.textArea.setSelection(++currpos);
                        }
                        line = text.substring(charpos, currpos);
                        if (line.endsWith("\n")) {
                            line = line.substring(0, line.length() - 1);
                        }
                        if (line.length() > 0) {
                            newtext = String.valueOf(newtext) + "\n" + text.substring(charpos, currpos);
                            remove1st = true;
                        }
                        currpos = newtext.indexOf("\r");
                        while (currpos > 0) {
                            newtext = String.valueOf(newtext.substring(0, currpos)) + newtext.substring(currpos + 1);
                            currpos = newtext.indexOf("\r");
                        }
                        newtext = newtext.replace("\t", " ");
                        if (remove1st) {
                            newtext = newtext.substring(1);
                        }
                        text = newtext;
                        ScreenshotViewer.this.textArea.dispose();
                        ScreenshotViewer.this.textArea = null;
                        if (text.length() > 0) {
                            ((StringBuffer)ScreenshotViewer.this.historyDrawText.get(ScreenshotViewer.this.historyCheckpoint - 1)).append(text);
                            Color color = ScreenshotViewer.this.workImageGC.getForeground();
                            FontData fontData = new FontData(ScreenshotViewer.this.drawTextToolbar.getStringCustom());
                            ScreenshotViewer.this.workImageGC.setFont(new Font((Device)ScreenshotViewer.this.getShell().getDisplay(), fontData));
                            ScreenshotViewer.this.workImageGC.setForeground(new Color((Device)ScreenshotViewer.this.getShell().getDisplay(), SelectToolAction.int2rgb(ScreenshotViewer.this.drawTextToolbar.getIntgerCustom())));
                            ScreenshotViewer.this.workImageGC.setClipping(bounds);
                            ScreenshotViewer.this.workImageGC.drawText(text, bounds.x, bounds.y, true);
                            ScreenshotViewer.this.workImageGC.setClipping(null);
                            ScreenshotViewer.this.workImageGC.setForeground(color);
                        } else {
                            ScreenshotViewer screenshotViewer = ScreenshotViewer.this;
                            screenshotViewer.historyCheckpoint = screenshotViewer.historyCheckpoint - 1;
                            ScreenshotViewer.this.updateAnnotationHistory();
                        }
                        ScreenshotViewer.this.canvas.redraw();
                    }
                });
            }

            public void mouseDown(MouseEvent e) {
                int info;
                int scaledX = (int)((double)e.x / ScreenshotViewer.this.scaleFactor);
                int scaledY = (int)((double)e.y / ScreenshotViewer.this.scaleFactor);
                if (ScreenshotViewer.this.currentAction == EditorAction.MARKING) {
                    ScreenshotViewer.this.updateAnnotationHistory();
                    int drawTool = ScreenshotViewer.this.getSelectDrawToolbar();
                    int[] history = new int[5];
                    history[0] = ScreenshotViewer.this.historyMouseEvent.size();
                    history[1] = drawTool;
                    history[2] = ScreenshotViewer.this.lineTypeToolbar != null ? ScreenshotViewer.this.lineTypeToolbar.getSelect() : 3;
                    history[3] = ScreenshotViewer.this.lineBoldToolbar != null ? ScreenshotViewer.this.lineBoldToolbar.getSelect() : 1;
                    RGB rgb = drawTool == 30 ? SelectToolAction.int2rgb(ScreenshotViewer.this.drawTextToolbar.getIntgerCustom()) : SelectToolAction.int2rgb(ScreenshotViewer.this.drawColorToolbar.getSelect());
                    history[4] = (rgb.red << 16) + (rgb.green << 8) + rgb.blue;
                    ScreenshotViewer.this.historyDrawTool.add(history);
                    ScreenshotViewer.this.historyDrawText.add(new StringBuffer());
                    if (drawTool == 30) {
                        FontData fontData = new FontData(ScreenshotViewer.this.drawTextToolbar.getStringCustom());
                        ScreenshotViewer.this.historyDrawFont.add(fontData.toString());
                    } else {
                        ScreenshotViewer.this.historyDrawFont.add("");
                    }
                    ScreenshotViewer.this.historyCheckpoint = ScreenshotViewer.this.historyDrawTool.size();
                    history = new int[]{3, scaledX, scaledY};
                    ScreenshotViewer.this.historyMouseEvent.add(history);
                    ScreenshotViewer.this.undoAction.setEnabled(true);
                    if (drawTool != 0) {
                        Display display = ScreenshotViewer.this.getShell().getDisplay();
                        ScreenshotViewer.this.previousImage = new Image((Device)display, ScreenshotViewer.this.workImage.getBounds());
                        GC gc = new GC((Drawable)ScreenshotViewer.this.previousImage);
                        gc.drawImage(ScreenshotViewer.this.workImage, 0, 0);
                        gc.dispose();
                    }
                    if (drawTool != 30) {
                        ScreenshotViewer.this.workImageGC.setLineStyle(ScreenshotViewer.this.lineTypeToolbar.getSelect());
                        ScreenshotViewer.this.workImageGC.setLineWidth(ScreenshotViewer.this.lineBoldToolbar.getSelect());
                        ScreenshotViewer.this.workImageGC.setForeground(new Color((Device)ScreenshotViewer.this.getShell().getDisplay(), SelectToolAction.int2rgb(ScreenshotViewer.this.drawColorToolbar.getSelect())));
                    } else {
                        ScreenshotViewer.this.workImageGC.setLineStyle(3);
                        ScreenshotViewer.this.workImageGC.setLineWidth(1);
                        ScreenshotViewer.this.workImageGC.setForeground(new Color((Device)ScreenshotViewer.this.getShell().getDisplay(), 0, 0, 0));
                    }
                    ScreenshotViewer.this.startPoint = new Point(scaledX, scaledY);
                    ScreenshotViewer.this.drawMarkLine(scaledX, scaledY);
                    ScreenshotViewer.this.canvas.setCursor((Cursor)ScreenshotViewer.this.cursors.get(-1));
                    return;
                }
                if (ScreenshotViewer.this.currentAction != EditorAction.CROPPING) {
                    return;
                }
                if (ScreenshotViewer.this.currentSelection != null && (info = ScreenshotViewer.this.getGrabPoint(e.x, e.y)) >= 0) {
                    ScreenshotViewer.this.originalSelection = ScreenshotViewer.this.currentSelection;
                    ScreenshotViewer.this.currentAction = EditorAction.RESIZING_SELECTION;
                    ScreenshotViewer.this.resizableSides = new HashSet();
                    SelectionSide[] selectionSideArray = grabPointResizableSides[info];
                    int n = selectionSideArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SelectionSide side = selectionSideArray[n2];
                        ScreenshotViewer.this.resizableSides.add(side);
                        ++n2;
                    }
                    ScreenshotViewer.this.startPoint = new Point(scaledX, scaledY);
                    ScreenshotViewer.this.canvas.redraw();
                    return;
                }
                if (ScreenshotViewer.this.currentSelection != null && ScreenshotViewer.this.currentSelection.contains(scaledX, scaledY)) {
                    ScreenshotViewer.this.originalSelection = ScreenshotViewer.this.currentSelection;
                    ScreenshotViewer.this.currentAction = EditorAction.MOVING_SELECTION;
                    ScreenshotViewer.this.startPoint = new Point(scaledX, scaledY);
                    ScreenshotViewer.this.canvas.redraw();
                    return;
                }
                ScreenshotViewer.this.canvas.setCursor((Cursor)ScreenshotViewer.this.cursors.get(2));
                ScreenshotViewer.this.currentAction = EditorAction.SELECTING;
                ScreenshotViewer.this.currentSelection = null;
                ScreenshotViewer.this.startPoint = new Point(scaledX, scaledY);
                ScreenshotViewer.this.canvas.redraw();
            }
        });
    }

    private void clearSelection() {
        this.currentSelection = null;
        this.startPoint = null;
        this.setDirty(true);
    }

    private void refreshCanvasSize() {
        if (this.fitAction.getSelect() == 0) {
            this.scrolledComposite.getHorizontalBar().setVisible(false);
            this.scrolledComposite.getVerticalBar().setVisible(false);
            Rectangle bounds = this.scrolledComposite.getClientArea();
            if (this.workImage != null) {
                Rectangle imageBounds = this.workImage.getBounds();
                double xRatio = (double)bounds.width / (double)imageBounds.width;
                double yRatio = (double)bounds.height / (double)imageBounds.height;
                this.scaleFactor = Math.min(xRatio, yRatio);
                bounds.width = (int)Math.round((double)imageBounds.width * this.scaleFactor);
                bounds.height = (int)Math.round((double)imageBounds.height * this.scaleFactor);
            }
            this.canvas.setBounds(bounds);
        } else {
            this.scaleFactor = this.fitAction.getSelect();
            this.scaleFactor /= 100.0;
            Rectangle bounds = this.scrolledComposite.getClientArea();
            if (this.workImage != null) {
                Rectangle imageBounds = this.workImage.getBounds();
                bounds.width = (int)Math.round((double)imageBounds.width * this.scaleFactor);
                bounds.height = (int)Math.round((double)imageBounds.height * this.scaleFactor);
            }
            this.canvas.setBounds(bounds);
        }
        this.canvas.redraw();
    }

    private void updateAnnotationHistory() {
        if (this.historyCheckpoint < this.historyDrawTool.size()) {
            int[] history = this.historyDrawTool.get(this.historyCheckpoint);
            while (history[0] < this.historyMouseEvent.size()) {
                this.historyMouseEvent.remove(this.historyMouseEvent.size() - 1);
            }
            while (this.historyCheckpoint < this.historyDrawTool.size()) {
                this.historyDrawTool.remove(this.historyDrawTool.size() - 1);
            }
            while (this.historyCheckpoint < this.historyDrawText.size()) {
                this.historyDrawText.remove(this.historyDrawText.size() - 1);
            }
            while (this.historyCheckpoint < this.historyDrawFont.size()) {
                this.historyDrawFont.remove(this.historyDrawFont.size() - 1);
            }
            this.redoAction.setEnabled(false);
        }
        this.undoAction.setEnabled(this.historyCheckpoint > 0);
    }

    private void drawAnnotationHistory() {
        this.workImageGC.drawImage(this.originalImage, 0, 0);
        Color backBackground = this.workImageGC.getBackground();
        Color backForeground = this.workImageGC.getForeground();
        int backLineStyle = this.workImageGC.getLineStyle();
        int backLineWidth = this.workImageGC.getLineWidth();
        int c = 0;
        while (c < this.historyCheckpoint) {
            int[] history = this.historyDrawTool.get(c);
            int toolKind = history[1];
            int boldlKind = history[3];
            this.workImageGC.setLineStyle(history[2]);
            this.workImageGC.setLineWidth(boldlKind);
            this.workImageGC.setForeground(new Color((Device)this.getShell().getDisplay(), history[4] >> 16, history[4] >> 8 & 0xFF, history[4] & 0xFF));
            int h = history[0];
            history = this.historyMouseEvent.get(h);
            int start_x = history[1];
            int start_y = history[2];
            ++h;
            while (h < this.historyMouseEvent.size()) {
                history = this.historyMouseEvent.get(h);
                if (history[0] == 4) break;
                int x = history[1];
                int y = history[2];
                if (toolKind == 0) {
                    this.workImageGC.drawLine(start_x, start_y, x, y);
                    start_x = x;
                    start_y = y;
                } else if (start_x == x && start_y == y) {
                    this.workImageGC.drawLine(start_x, start_y, x, y);
                } else {
                    int width = x - start_x;
                    int height = y - start_y;
                    switch (toolKind) {
                        case 1: {
                            this.workImageGC.drawLine(start_x, start_y, x, y);
                            break;
                        }
                        case 2: {
                            this.workImageGC.setBackground(this.workImageGC.getForeground());
                            this.drawArrowLine(start_x, start_y, x, y, false);
                            break;
                        }
                        case 3: {
                            this.workImageGC.setBackground(this.workImageGC.getForeground());
                            this.drawArrowLine(start_x, start_y, x, y, true);
                            break;
                        }
                        case 10: {
                            this.workImageGC.drawRectangle(start_x, start_y, width, height);
                            break;
                        }
                        case 11: {
                            int rounded = boldlKind * 8;
                            this.workImageGC.drawRoundRectangle(start_x, start_y, width, height, rounded, rounded);
                            break;
                        }
                        case 20: {
                            this.workImageGC.drawOval(start_x, start_y, width, height);
                            break;
                        }
                        case 12: {
                            this.workImageGC.setBackground(this.workImageGC.getForeground());
                            this.workImageGC.fillRectangle(start_x, start_y, width, height);
                            break;
                        }
                        case 13: {
                            int rounded = boldlKind * 8;
                            this.workImageGC.setBackground(this.workImageGC.getForeground());
                            this.workImageGC.fillRoundRectangle(start_x, start_y, width, height, rounded, rounded);
                            break;
                        }
                        case 21: {
                            this.workImageGC.setBackground(this.workImageGC.getForeground());
                            this.workImageGC.fillOval(start_x, start_y, width, height);
                            break;
                        }
                        case 30: {
                            StringBuffer text = this.historyDrawText.get(c);
                            Font backFont = this.workImageGC.getFont();
                            FontData fontData = new FontData(this.historyDrawFont.get(c));
                            this.workImageGC.setFont(new Font((Device)this.getShell().getDisplay(), fontData));
                            this.workImageGC.setClipping(start_x, start_y, width, height);
                            this.workImageGC.drawText(text.toString(), start_x, start_y, true);
                            this.workImageGC.setClipping(null);
                            this.workImageGC.setFont(backFont);
                        }
                    }
                }
                ++h;
            }
            ++c;
        }
        this.workImageGC.setBackground(backBackground);
        this.workImageGC.setForeground(backForeground);
        this.workImageGC.setLineStyle(backLineStyle);
        this.workImageGC.setLineWidth(backLineWidth);
        this.canvas.redraw();
    }

    private void drawSelection(GC gc) {
        if (this.currentSelection == null) {
            return;
        }
        Rectangle inside = this.getScaledSelection();
        gc.setBackground(gc.getDevice().getSystemColor(15));
        gc.setAdvanced(true);
        gc.setAlpha(120);
        Region invertedSelection = new Region();
        invertedSelection.add(this.canvas.getClientArea());
        invertedSelection.subtract(inside);
        gc.setClipping(invertedSelection);
        gc.fillRectangle(this.canvas.getClientArea());
        gc.setClipping(null);
        invertedSelection.dispose();
        gc.setAdvanced(false);
        gc.setLineStyle(1);
        gc.setForeground(this.getShell().getDisplay().getSystemColor(16));
        gc.drawRectangle(inside);
        gc.setForeground(this.getShell().getDisplay().getSystemColor(16));
        Rectangle outside = this.getOutsideSelection(inside);
        gc.drawRectangle(outside);
        gc.setBackground(this.getShell().getDisplay().getSystemColor(16));
        gc.fillRectangle(outside.x, outside.y, 18, 6);
        gc.fillRectangle(outside.x + outside.width - 18, outside.y, 18, 6);
        gc.fillRectangle(outside.x, outside.y, 6, 18);
        gc.fillRectangle(outside.x + outside.width - 6, outside.y, 6, 18);
        gc.fillRectangle(outside.x, outside.y + outside.height - 18, 6, 18);
        gc.fillRectangle(outside.x + outside.width - 6, outside.y + outside.height - 18, 6, 18);
        gc.fillRectangle(outside.x, outside.y + outside.height - 6, 18, 6);
        gc.fillRectangle(outside.x + outside.width - 18, outside.y + outside.height - 6, 18, 6);
    }

    private void drawMarkLine(int x, int y) {
        if (this.startPoint != null) {
            this.clearAction.setEnabled(true);
            int drawTool = this.getSelectDrawToolbar();
            if (drawTool == 0) {
                this.workImageGC.drawLine(this.startPoint.x, this.startPoint.y, x, y);
                this.startPoint.x = x;
                this.startPoint.y = y;
            } else {
                this.workImageGC.drawImage(this.previousImage, 0, 0);
                if (this.startPoint.x == x && this.startPoint.y == y) {
                    this.workImageGC.drawLine(this.startPoint.x, this.startPoint.y, x, y);
                } else {
                    int width = x - this.startPoint.x;
                    int height = y - this.startPoint.y;
                    switch (drawTool) {
                        case 1: {
                            this.workImageGC.drawLine(this.startPoint.x, this.startPoint.y, x, y);
                            break;
                        }
                        case 2: {
                            Color backColor = this.workImageGC.getBackground();
                            Color markColor = new Color((Device)this.getShell().getDisplay(), SelectToolAction.int2rgb(this.drawColorToolbar.getSelect()));
                            this.workImageGC.setBackground(markColor);
                            this.drawArrowLine(this.startPoint.x, this.startPoint.y, x, y, false);
                            this.workImageGC.setBackground(backColor);
                            break;
                        }
                        case 3: {
                            Color backColor = this.workImageGC.getBackground();
                            Color markColor = new Color((Device)this.getShell().getDisplay(), SelectToolAction.int2rgb(this.drawColorToolbar.getSelect()));
                            this.workImageGC.setBackground(markColor);
                            this.drawArrowLine(this.startPoint.x, this.startPoint.y, x, y, true);
                            this.workImageGC.setBackground(backColor);
                            break;
                        }
                        case 10: {
                            this.workImageGC.drawRectangle(this.startPoint.x, this.startPoint.y, width, height);
                            break;
                        }
                        case 11: {
                            int rounded = this.lineBoldToolbar.getSelect() * 8;
                            this.workImageGC.drawRoundRectangle(this.startPoint.x, this.startPoint.y, width, height, rounded, rounded);
                            break;
                        }
                        case 20: {
                            this.workImageGC.drawOval(this.startPoint.x, this.startPoint.y, width, height);
                            break;
                        }
                        case 12: {
                            Color backColor = this.workImageGC.getBackground();
                            Color markColor = new Color((Device)this.getShell().getDisplay(), SelectToolAction.int2rgb(this.drawColorToolbar.getSelect()));
                            this.workImageGC.setBackground(markColor);
                            this.workImageGC.fillRectangle(this.startPoint.x, this.startPoint.y, width, height);
                            this.workImageGC.setBackground(backColor);
                            break;
                        }
                        case 13: {
                            int rounded = this.lineBoldToolbar.getSelect() * 8;
                            Color backColor = this.workImageGC.getBackground();
                            Color markColor = new Color((Device)this.getShell().getDisplay(), SelectToolAction.int2rgb(this.drawColorToolbar.getSelect()));
                            this.workImageGC.setBackground(markColor);
                            this.workImageGC.fillRoundRectangle(this.startPoint.x, this.startPoint.y, width, height, rounded, rounded);
                            this.workImageGC.setBackground(backColor);
                            break;
                        }
                        case 21: {
                            Color backColor = this.workImageGC.getBackground();
                            Color markColor = new Color((Device)this.getShell().getDisplay(), SelectToolAction.int2rgb(this.drawColorToolbar.getSelect()));
                            this.workImageGC.setBackground(markColor);
                            this.workImageGC.fillOval(this.startPoint.x, this.startPoint.y, width, height);
                            this.workImageGC.setBackground(backColor);
                            break;
                        }
                        case 30: {
                            this.workImageGC.fillRectangle(this.startPoint.x, this.startPoint.y, width, height);
                            this.workImageGC.drawRectangle(this.startPoint.x, this.startPoint.y, width, height);
                        }
                    }
                }
            }
            this.canvas.redraw();
        }
    }

    private void drawArrowLine(int xs, int ys, int xe, int ye, boolean bothsides) {
        int width = xe - xs;
        int height = ye - ys;
        int bold = this.workImageGC.getLineWidth();
        int leng = bold == 8 ? bold * 4 : (bold == 4 ? bold * 6 : (bold == 2 ? bold * 8 : bold * 10));
        double delta = 0.5235987755982988;
        double theta = Math.atan2(height, width);
        if (bothsides) {
            this.workImageGC.drawLine(xs + (int)((double)(leng / 2) * Math.cos(theta)), ys + (int)((double)(leng / 2) * Math.sin(theta)), xe - (int)((double)(leng / 2) * Math.cos(theta)), ye - (int)((double)(leng / 2) * Math.sin(theta)));
        } else {
            this.workImageGC.drawLine(xs, ys, xe - (int)((double)(leng / 2) * Math.cos(theta)), ye - (int)((double)(leng / 2) * Math.sin(theta)));
        }
        this.workImageGC.setLineWidth(1);
        int[] point = new int[]{xe, ye, xe - (int)((double)leng * Math.cos(theta - delta)), ye - (int)((double)leng * Math.sin(theta - delta)), xe - (int)((double)leng * Math.cos(theta + delta)), ye - (int)((double)leng * Math.sin(theta + delta))};
        this.workImageGC.fillPolygon(point);
        if (bothsides) {
            int[] point2 = new int[]{xs, ys, xs + (int)((double)leng * Math.cos(theta - delta)), ys + (int)((double)leng * Math.sin(theta - delta)), xs + (int)((double)leng * Math.cos(theta + delta)), ys + (int)((double)leng * Math.sin(theta + delta))};
            this.workImageGC.fillPolygon(point2);
        }
        this.workImageGC.setLineWidth(bold);
    }

    public Image createImage() {
        Image screenshot = new Image((Device)Display.getDefault(), this.currentSelection != null ? this.currentSelection : this.workImage.getBounds());
        GC gc = new GC((Drawable)screenshot);
        if (this.currentSelection != null) {
            gc.drawImage(this.workImage, this.currentSelection.x, this.currentSelection.y, this.currentSelection.width, this.currentSelection.height, 0, 0, this.currentSelection.width, this.currentSelection.height);
        } else {
            gc.drawImage(this.workImage, 0, 0);
        }
        gc.dispose();
        this.setDirty(false);
        return screenshot;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EditorAction {
        CROPPING,
        SELECTING,
        RESIZING_SELECTION,
        MOVING_SELECTION,
        MARKING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SelectionSide {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

