/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.buildpath;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;

public class CPJavaProject {
    private final List fCPListElements;

    public static CPJavaProject createFromExisting(IJavaScriptProject javaProject) throws CoreException {
        List classpathEntries = ClasspathModifier.getExistingEntries(javaProject);
        return new CPJavaProject(classpathEntries);
    }

    public CPJavaProject(List cpListElements) {
        this.fCPListElements = cpListElements;
    }

    public CPJavaProject createWorkingCopy() {
        ArrayList<CPListElement> newList = new ArrayList<CPListElement>(this.fCPListElements.size());
        Iterator iterator = this.fCPListElements.iterator();
        while (iterator.hasNext()) {
            CPListElement element = (CPListElement)iterator.next();
            newList.add(element.copy());
        }
        return new CPJavaProject(newList);
    }

    public CPListElement get(int index) {
        return (CPListElement)this.fCPListElements.get(index);
    }

    public IIncludePathEntry[] getIncludePathEntries() {
        IIncludePathEntry[] result = new IIncludePathEntry[this.fCPListElements.size()];
        int i = 0;
        Iterator iterator = this.fCPListElements.iterator();
        while (iterator.hasNext()) {
            CPListElement element = (CPListElement)iterator.next();
            result[i] = element.getClasspathEntry();
            ++i;
        }
        return result;
    }

    public CPListElement getCPElement(CPListElement element) {
        return ClasspathModifier.getClasspathEntry(this.fCPListElements, element);
    }

    public List getCPListElements() {
        return this.fCPListElements;
    }

    public IJavaScriptProject getJavaProject() {
        return ((CPListElement)this.fCPListElements.get(0)).getJavaProject();
    }

    public int indexOf(CPListElement element) {
        return this.fCPListElements.indexOf(element);
    }
}

