/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.ui.launching;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.text.DateFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.debug.core.jsdi.VirtualMachine;
import org.eclipse.wst.jsdt.debug.core.jsdi.connect.AttachingConnector;
import org.eclipse.wst.jsdt.debug.core.jsdi.connect.Connector;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugTarget;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.connect.RhinoAttachingConnector;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.RhinoUIPlugin;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.launching.Messages;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.launching.RhinoProcess;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.refactoring.Refactoring;
import org.mozilla.javascript.JavaScriptException;
import org.osgi.framework.Bundle;

public class RhinoLocalLaunchDelegate
implements ILaunchConfigurationDelegate2 {
    public static final String DEBUG_SHELL_CLASS = "org.eclipse.wst.jsdt.debug.rhino.debugger.shell.DebugMain";
    public static final String RHINO_MAIN_CLASS = "org.mozilla.javascript.tools.shell.Main";
    public static final String MOZILLA_JAVASCRIPT_BUNDLE = "org.mozilla.javascript";
    public static final String DEBUG_TRANSPORT_BUNDLE = "org.eclipse.wst.jsdt.debug.transport";
    private static final String RHINO_DEBUGGER_BUNDLE = "org.eclipse.wst.jsdt.debug.rhino.debugger";
    public static final String[] REQUIRED_BUNDLES = new String[]{"org.mozilla.javascript", "org.eclipse.wst.jsdt.debug.transport", "org.eclipse.wst.jsdt.debug.rhino.debugger"};
    private ArrayList scope = null;
    private ITypeRoot script = null;

    synchronized ITypeRoot getScript(ILaunchConfiguration configuration) throws CoreException {
        IFile resource;
        if (this.script == null && (resource = Refactoring.getScript(configuration)) != null) {
            this.script = (ITypeRoot)JavaScriptCore.create((IFile)resource);
        }
        return this.script;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.launching__, (Object)configuration.getName()), (int)8);
        port = SocketUtil.findFreePort();
        localmonitor.subTask(Messages.starting_rhino_interpreter);
        if (localmonitor.isCanceled()) {
            return;
        }
        localmonitor.worked(1);
        vm = null;
        p = null;
        try {
            try {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                localmonitor.subTask(Messages.configuring_rhino_debugger);
                                if (localmonitor.isCanceled()) {
lbl14:
                                    // 8 sources

                                    while (true) {
                                        var16_9 = null;
                                        if (this.scope != null) {
                                            this.scope.clear();
                                            this.scope = null;
                                        }
                                        this.script = null;
                                        return;
                                    }
                                }
                                localmonitor.worked(1);
                                cmdargs = new ArrayList<E>();
                                this.addVMArgs(configuration, launch, cmdargs);
                                this.addConnectionArgs(port, cmdargs);
                                this.addECMAVersion(configuration, cmdargs);
                                this.addEncoding(launch, cmdargs);
                                this.addOptLevel(configuration, cmdargs);
                                this.addStrictMode(configuration, cmdargs);
                                this.addFArg(cmdargs);
                                p = DebugPlugin.exec((String[])cmdargs.toArray(new String[cmdargs.size()]), null);
                                args = new HashMap<String, String>();
                                args.put("host", "localhost");
                                args.put("port", Integer.toString(port));
                                localmonitor.subTask(Messages.creating_rhino_vm);
                                if (!localmonitor.isCanceled()) break block18;
                                this.cancel(vm, p);
                                ** GOTO lbl14
                            }
                            localmonitor.worked(1);
                            connector = new RhinoAttachingConnector();
                            runnable = new ConnectRunnable((AttachingConnector)connector, args);
                            thread = new Thread((Runnable)runnable, Messages.connect_thread);
                            thread.setDaemon(true);
                            thread.start();
                            while (true) {
                                if (!thread.isAlive()) {
                                    if (runnable.exception == null) break;
                                    throw runnable.exception;
                                }
                                if (localmonitor.isCanceled()) {
                                    this.cancel(vm, p);
                                    thread.interrupt();
                                }
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (Exception v0) {}
                            }
                            if (runnable.vm == null) {
                                throw new IOException("Failed to connect to Rhino interpreter.");
                            }
                            vm = runnable.vm;
                            localmonitor.subTask(Messages.starting_rhino_process);
                            if (!localmonitor.isCanceled()) break block19;
                            this.cancel(vm, p);
                            ** GOTO lbl14
                        }
                        localmonitor.worked(1);
                        process = new RhinoProcess(launch, p, this.computeProcessName((Connector)connector, args));
                        process.setAttribute(IProcess.ATTR_CMDLINE, this.formatCommandlineArgs(cmdargs));
                        launch.addProcess((IProcess)process);
                        localmonitor.subTask(Messages.creating_js_debug_target);
                        if (!localmonitor.isCanceled()) break block20;
                        this.cancel(vm, p);
                        ** GOTO lbl14
                    }
                    localmonitor.worked(1);
                    target = new JavaScriptDebugTarget(vm, (IProcess)process, launch, true, false);
                    launch.addDebugTarget((IDebugTarget)target);
                    if (!localmonitor.isCanceled()) break block21;
                    this.cancel(vm, p);
                    ** GOTO lbl14
                }
                localmonitor.worked(1);
                ** GOTO lbl14
            }
            catch (IOException ioe) {
                this.cancel(vm, p);
                RhinoUIPlugin.log(ioe);
            }
            catch (Exception e) {
                block22: {
                    if (!(e instanceof JavaScriptException)) break block22;
                    if (!configuration.getAttribute("logexceptions", true)) ** GOTO lbl14
                    RhinoUIPlugin.log(e);
                    ** continue;
                }
                this.cancel(vm, p);
                RhinoUIPlugin.log(e);
            }
        }
        catch (Throwable var17_21) {
            var16_10 = null;
            if (this.scope != null) {
                this.scope.clear();
                this.scope = null;
            }
            this.script = null;
            throw var17_21;
        }
        {
            var16_11 = null;
            if (this.scope != null) {
                this.scope.clear();
                this.scope = null;
            }
            this.script = null;
        }
        launch.terminate();
    }

    void cancel(VirtualMachine vm, Process process) {
        if (process != null) {
            process.destroy();
        }
        if (vm != null) {
            vm.terminate();
        }
    }

    void addFArg(ArrayList args) {
        args.add("-f");
        args.addAll(this.scope);
    }

    void addVMArgs(ILaunchConfiguration configuration, ILaunch launch, ArrayList args) throws CoreException, IOException {
        IVMInstall vm = JavaRuntime.getDefaultVMInstall();
        File loc = vm.getInstallLocation();
        if (loc == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.debug.rhino.ui", "Could not locate the default VM install"));
        }
        File exe = StandardVMType.findJavaExecutable((File)vm.getInstallLocation());
        if (exe == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.debug.rhino.ui", "Could not find the Java executable for the default VM install"));
        }
        args.add(exe.getAbsolutePath());
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < REQUIRED_BUNDLES.length) {
            Bundle bundle = Platform.getBundle((String)REQUIRED_BUNDLES[i]);
            if (bundle == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.debug.rhino.ui", NLS.bind((String)"Could not locate the {0} bundle", (Object)REQUIRED_BUNDLES[i])));
            }
            File file = FileLocator.getBundleFile((Bundle)bundle);
            if (file.isDirectory()) {
                if (MOZILLA_JAVASCRIPT_BUNDLE.equals(REQUIRED_BUNDLES[i])) {
                    buffer.append(this.escapePath(file, false));
                } else if ((file = new File(file, "bin")).exists()) {
                    buffer.append(this.escapePath(file, false));
                }
            } else {
                buffer.append(this.escapePath(file, false));
            }
            if (i < REQUIRED_BUNDLES.length - 1) {
                this.appendSep(buffer);
            }
            ++i;
        }
        String encoding = this.getEncoding(launch);
        if (encoding != null) {
            args.add(encoding);
        }
        args.add("-cp");
        args.add(buffer.toString());
        args.add(DEBUG_SHELL_CLASS);
    }

    String getEncoding(ILaunch launch) {
        String encoding = launch.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING");
        if (encoding != null) {
            StringBuffer buffer = new StringBuffer("-Dfile.encoding=");
            buffer.append(encoding);
            return buffer.toString();
        }
        return null;
    }

    String escapePath(File file, boolean singlequote) {
        String path = file.getAbsolutePath();
        StringCharacterIterator iter = new StringCharacterIterator(path);
        StringBuffer buffer = new StringBuffer();
        boolean hasspace = false;
        char c = iter.current();
        while (c != '\uffff') {
            if (c == '\\') {
                buffer.append("/");
            } else if (c == '\"') {
                buffer.append("\"");
            } else if (c == ' ') {
                hasspace = true;
                buffer.append(c);
            } else {
                buffer.append(c);
            }
            c = iter.next();
        }
        if (hasspace && !singlequote) {
            buffer.insert(0, "\"");
            buffer.append("\"");
            return buffer.toString();
        }
        return path;
    }

    void appendSep(StringBuffer buffer) {
        if (Platform.getOS().equals("win32")) {
            buffer.append(';');
        } else {
            buffer.append(':');
        }
    }

    void addConnectionArgs(int port, ArrayList args) {
        args.add("-port");
        args.add(Integer.toString(port));
        args.add("-suspend");
        args.add("y");
    }

    void addECMAVersion(ILaunchConfiguration configuration, ArrayList args) throws CoreException {
        args.add("-version");
        args.add(configuration.getAttribute("ecmaversion", "170"));
    }

    void addEncoding(ILaunch launch, ArrayList args) {
        String encoding = launch.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING");
        if (encoding != null) {
            args.add("-encoding");
            args.add(encoding);
        }
    }

    void addOptLevel(ILaunchConfiguration configuration, ArrayList args) throws CoreException {
        int opt = configuration.getAttribute("optlevel", -1);
        args.add("-opt");
        args.add(Integer.toString(opt));
    }

    void addStrictMode(ILaunchConfiguration configuration, ArrayList args) throws CoreException {
        boolean strict = configuration.getAttribute("strictmode", false);
        if (strict) {
            args.add("-strict");
        }
    }

    synchronized void computeScriptScope(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        if (this.scope == null) {
            this.scope = new ArrayList();
            List list = configuration.getAttribute("includepath", null);
            if (list != null) {
                String entry = null;
                Iterator i = list.iterator();
                block4: while (i.hasNext()) {
                    entry = (String)i.next();
                    int kind = Integer.parseInt(entry.substring(0, 1));
                    switch (kind) {
                        case 1: {
                            File file;
                            String value = entry.substring(1);
                            IFile ifile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(value);
                            if (ifile == null || !ifile.exists() || this.scope.contains(value = this.escapePath(file = URIUtil.toFile((URI)ifile.getLocationURI()), true))) continue block4;
                            this.scope.add(value);
                            break;
                        }
                        case 2: {
                            String f = entry.substring(1);
                            File file = new File(f);
                            if (!file.exists() || this.scope.contains(file.getAbsolutePath())) continue block4;
                            this.scope.add(file.getAbsolutePath());
                        }
                    }
                }
            }
            this.addScriptAttribute(configuration, this.scope);
        }
    }

    void addScriptAttribute(ILaunchConfiguration configuration, ArrayList args) throws CoreException {
        ITypeRoot root = this.getScript(configuration);
        File file = URIUtil.toFile((URI)root.getResource().getLocationURI());
        String value = this.escapePath(file, true);
        args.remove(value);
        args.add(value);
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return null;
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return true;
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(Messages.computing_script_scope);
        this.computeScriptScope(configuration, monitor);
        if (this.scope.isEmpty()) {
            this.scope = null;
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.debug.rhino.ui", Messages.failed_to_compute_scope));
        }
        return true;
    }

    boolean hasProblems(ILaunchConfiguration configuration) throws CoreException {
        String name = configuration.getAttribute("script", "");
        IResource script = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(name));
        if (script.isAccessible()) {
            IMarker[] problems = script.findMarkers("org.eclipse.wst.jsdt.core.problem", true, 2);
            return problems.length > 0;
        }
        return false;
    }

    String formatCommandlineArgs(ArrayList args) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < args.size()) {
            buffer.append(args.get(i));
            if (i < args.size() - 1) {
                buffer.append(" ");
            }
            ++i;
        }
        return buffer.toString();
    }

    String formatConnectionArguments(Map args) {
        StringBuffer buffer = new StringBuffer();
        Map.Entry entry = null;
        Iterator iter = args.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            buffer.append(entry.getKey()).append(':').append(entry.getValue());
            if (!iter.hasNext()) continue;
            buffer.append(',');
        }
        return buffer.toString();
    }

    String computeProcessName(Connector connector, Map args) {
        StringBuffer buffer = new StringBuffer(connector.name());
        String timestamp = DateFormat.getDateTimeInstance(2, 2).format(new Date(System.currentTimeMillis()));
        return NLS.bind((String)Messages.process_label, (Object[])new String[]{buffer.toString(), this.formatConnectionArguments(args), timestamp});
    }

    class ConnectRunnable
    implements Runnable {
        VirtualMachine vm = null;
        Exception exception = null;
        private AttachingConnector connector = null;
        private Map args = null;

        ConnectRunnable(AttachingConnector connector, Map args) {
            this.connector = connector;
            this.args = args;
        }

        public void run() {
            try {
                long start = System.currentTimeMillis();
                Exception inner = null;
                do {
                    try {
                        this.vm = this.connector.attach(this.args);
                    }
                    catch (Exception e) {
                        inner = e;
                    }
                } while (this.vm == null && System.currentTimeMillis() < start + 15000L);
                if (this.vm == null) {
                    throw inner;
                }
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }

    class Filter
    implements FileFilter {
        Filter() {
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory() || JavaScriptCore.isJavaScriptLikeFileName((String)pathname.getName());
        }
    }
}

