/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.preferences;

import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.preferences.StatusInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AddICDialog
extends StatusDialog
implements IShellProvider {
    private Label nameLabel;
    private Text nameText;
    private Label hostLabel;
    private Text hostText;
    private Label pathLabel;
    private Text pathText;
    private Label protocolLabel;
    private Combo protocolCombo;
    private Button radio1;
    private Button radio2;
    private Text portText;
    Point shellSize;
    Point shellLocation;
    private String enteredHost;
    private String enteredName;
    private String enteredPort;
    private String enteredPath;
    private String enteredProtocol;
    private boolean enteredUseDefault;
    private Color errorColor;
    private StatusInfo dialogStatus;
    private static final String PROTOCOL_HTTPS = "https";
    private Listener changeListener = new Listener(){

        public void handleEvent(Event event) {
            AddICDialog.this.updateValidity();
        }
    };

    public AddICDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.help.ui.prefPageHelpContent");
        Composite topComposite = (Composite)super.createDialogArea(parent);
        topComposite.setSize(topComposite.computeSize(-1, -1));
        Composite topGroup = new Composite(topComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        topGroup.setLayout((Layout)layout);
        topGroup.setFont(topComposite.getFont());
        topGroup.setLayoutData((Object)new GridData(768));
        this.createNameSection(topGroup);
        this.createHostSection(topGroup);
        this.createPathSection(topGroup);
        this.createProtocolSection(topGroup);
        this.createPortSection(topGroup);
        this.updateValidity();
        Dialog.applyDialogFont((Control)topComposite);
        return topComposite;
    }

    public void initializeBounds() {
        this.shellSize = this.getInitialSize();
        this.shellLocation = this.getInitialLocation(this.shellSize);
        this.getShell().setBounds(this.shellLocation.x, this.shellLocation.y, this.shellSize.x + 150, this.shellSize.y);
        this.getShell().setText(Messages.AddICDialog_2);
    }

    private void createNameSection(Composite parent) {
        this.nameLabel = new Label(parent, 0);
        this.nameLabel.setText(Messages.AddICDialog_4);
        this.nameText = new Text(parent, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.nameText.getOrientation() == 0x4000000) {
            this.nameText.setOrientation(0x2000000);
        }
        this.nameText.addListener(24, this.changeListener);
    }

    private void createHostSection(Composite parent) {
        this.hostLabel = new Label(parent, 0);
        this.hostLabel.setText(Messages.AddICDialog_5);
        this.hostText = new Text(parent, 2048);
        this.hostText.setText("");
        this.hostText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.hostText.getOrientation() == 0x4000000) {
            this.hostText.setOrientation(0x2000000);
        }
        this.hostText.addListener(24, this.changeListener);
    }

    private void createPathSection(Composite parent) {
        this.pathLabel = new Label(parent, 0);
        this.pathLabel.setText(Messages.AddICDialog_7);
        this.pathText = new Text(parent, 2048);
        this.pathText.setText("/help");
        this.pathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.pathText.getOrientation() == 0x4000000) {
            this.pathText.setOrientation(0x2000000);
        }
        this.pathText.addListener(24, this.changeListener);
    }

    private void createProtocolSection(Composite parent) {
        this.protocolLabel = new Label(parent, 0);
        this.protocolLabel.setText(Messages.AddICDialog_8);
        this.protocolCombo = new Combo(parent, 12);
        this.protocolCombo.add("http");
        this.protocolCombo.add(PROTOCOL_HTTPS);
        this.protocolCombo.select(0);
    }

    private void createPortSection(Composite parent) {
        Composite portComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        portComposite.setLayout((Layout)layout);
        portComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.radio1 = new Button(portComposite, 16);
        this.radio1.setText(Messages.AddICDialog_9);
        this.radio1.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.radio1.addListener(13, this.changeListener);
        this.radio1.setSelection(true);
        this.radio2 = new Button(portComposite, 16);
        this.radio2.setText(Messages.AddICDialog_10);
        this.radio2.addListener(13, this.changeListener);
        this.portText = new Text(portComposite, 2048);
        this.portText.setLayoutData((Object)new GridData(50, -1));
        this.portText.addListener(24, this.changeListener);
        this.portText.setEnabled(false);
    }

    public String getEnteredHost() {
        return this.enteredHost;
    }

    public String getEnteredPath() {
        return this.enteredPath;
    }

    public String getEnteredProtocol() {
        return this.enteredProtocol;
    }

    public String getEnteredPort() {
        return this.enteredPort;
    }

    public String getEnteredName() {
        return this.enteredName;
    }

    public boolean getEnteredDefault() {
        return this.enteredUseDefault;
    }

    public void okPressed() {
        this.enteredHost = this.hostText.getText();
        this.enteredName = this.nameText.getText();
        this.enteredPath = this.pathText.getText();
        this.enteredProtocol = this.protocolCombo.getText();
        if (this.radio1.getSelection()) {
            this.enteredUseDefault = true;
            this.enteredPort = "80";
        } else {
            this.enteredUseDefault = false;
            this.enteredPort = this.portText.getText();
        }
        this.setReturnCode(0);
        if (this.errorColor != null) {
            this.errorColor.dispose();
        }
        this.close();
    }

    private void updateValidity() {
        boolean errorFound;
        block9: {
            String errorMessage = "";
            errorFound = false;
            this.dialogStatus = new StatusInfo();
            if (this.hostText != null && this.hostText.getText().equals("") && !errorFound) {
                errorMessage = Messages.AddICDialog_17;
                this.dialogStatus.setError(errorMessage);
                errorFound = true;
            }
            if (this.radio2 != null && this.radio2.getSelection()) {
                try {
                    this.portText.setEnabled(true);
                    int port = Integer.parseInt(this.portText.getText());
                    if (!(port >= 0 && port <= 65535 || errorFound)) {
                        errorMessage = Messages.AddICDialog_19;
                        this.dialogStatus.setError(errorMessage);
                        errorFound = true;
                    }
                    break block9;
                }
                catch (NumberFormatException numberFormatException) {
                    if (!errorFound) {
                        errorMessage = Messages.AddICDialog_19;
                        this.dialogStatus.setError(errorMessage);
                        errorFound = true;
                    }
                    break block9;
                }
            }
            if (this.radio1 != null && this.radio1.getSelection()) {
                this.portText.setEnabled(false);
            }
        }
        if (errorFound) {
            this.updateStatus(this.dialogStatus);
        } else {
            this.dialogStatus.setOK();
            this.updateStatus(this.dialogStatus);
        }
    }
}

