/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.IModuleVisitor;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerMonitorManager;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;

public class ServerUtil {
    public static final Object SERVER_JOB_FAMILY = "org.eclipse.wst.server.core";

    private ServerUtil() {
    }

    public static IModule getModule(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException();
        }
        IModule[] modules = ServerUtil.getModules(project);
        if (modules != null && modules.length > 0) {
            return modules[0];
        }
        return null;
    }

    public static IModule[] getModules(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<IModule> list = new ArrayList<IModule>();
        ModuleFactory[] factories = ServerPlugin.getModuleFactories();
        if (factories != null) {
            ModuleFactory[] moduleFactoryArray = factories;
            int n = factories.length;
            int n2 = 0;
            while (n2 < n) {
                IModule[] modules;
                ModuleFactory factory = moduleFactoryArray[n2];
                if (factory.isEnabled(project, null) && (modules = factory.getModules(project, null)) != null) {
                    IModule[] iModuleArray = modules;
                    int n3 = modules.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IModule module = iModuleArray[n4];
                        if (!list.contains(module)) {
                            list.add(module);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return list.toArray(new IModule[list.size()]);
    }

    public static IModule getModule(String moduleId) {
        if (moduleId == null) {
            throw new IllegalArgumentException();
        }
        int index = moduleId.indexOf(":");
        if (index <= 0) {
            return null;
        }
        String factoryId = moduleId.substring(0, index);
        ModuleFactory moduleFactory = ServerPlugin.findModuleFactory(factoryId);
        if (moduleFactory == null) {
            return null;
        }
        String moduleSubId = moduleId.substring(index + 1);
        return moduleFactory.findModule(moduleSubId, null);
    }

    public static IModule[] getModules(IModuleType[] moduleTypes) {
        ArrayList<IModule> list = new ArrayList<IModule>();
        ModuleFactory[] factories = ServerPlugin.getModuleFactories();
        if (factories != null) {
            ModuleFactory[] moduleFactoryArray = factories;
            int n = factories.length;
            int n2 = 0;
            while (n2 < n) {
                IModule[] modules;
                ModuleFactory factory = moduleFactoryArray[n2];
                if (ServerUtil.isSupportedModule(factory.getModuleTypes(), moduleTypes) && (modules = factory.getModules(null)) != null) {
                    IModule[] iModuleArray = modules;
                    int n3 = modules.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IModule module = iModuleArray[n4];
                        list.add(module);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        IModule[] modules = new IModule[list.size()];
        list.toArray(modules);
        return modules;
    }

    public static IModule[] getModules(String type) {
        ArrayList<IModule> list = new ArrayList<IModule>();
        ModuleFactory[] factories = ServerPlugin.getModuleFactories();
        if (factories != null) {
            ModuleFactory[] moduleFactoryArray = factories;
            int n = factories.length;
            int n2 = 0;
            while (n2 < n) {
                IModule[] modules;
                ModuleFactory factory = moduleFactoryArray[n2];
                if (ServerUtil.isSupportedModule(factory.getModuleTypes(), type, null) && (modules = factory.getModules(null)) != null) {
                    IModule[] iModuleArray = modules;
                    int n3 = modules.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IModule module = iModuleArray[n4];
                        if (type.equals(module.getModuleType().getId())) {
                            list.add(module);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        IModule[] modules = new IModule[list.size()];
        list.toArray(modules);
        return modules;
    }

    public static boolean isSupportedModule(IModuleType[] moduleTypes, String typeId, String versionId) {
        if (moduleTypes == null) {
            throw new IllegalArgumentException();
        }
        if ("".equals(typeId)) {
            typeId = null;
        }
        if ("".equals(versionId)) {
            versionId = null;
        }
        if (typeId == null && versionId == null) {
            return true;
        }
        IModuleType[] iModuleTypeArray = moduleTypes;
        int n = moduleTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleType moduleType = iModuleTypeArray[n2];
            if (ServerUtil.isSupportedModule(moduleType, typeId, versionId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isSupportedModule(IModuleType[] moduleTypes, IModuleType[] mt) {
        if (mt != null) {
            IModuleType[] iModuleTypeArray = mt;
            int n = mt.length;
            int n2 = 0;
            while (n2 < n) {
                IModuleType moduleType = iModuleTypeArray[n2];
                if (ServerUtil.isSupportedModule(moduleTypes, moduleType)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isSupportedModule(IModuleType[] moduleTypes, IModuleType mt) {
        if (moduleTypes == null || mt == null) {
            throw new IllegalArgumentException();
        }
        IModuleType[] iModuleTypeArray = moduleTypes;
        int n = moduleTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleType moduleType = iModuleTypeArray[n2];
            if (ServerUtil.isSupportedModule(moduleType, mt)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isSupportedModule(IModuleType moduleType, String type, String version) {
        String version2;
        String type2 = moduleType.getId();
        return ServerPlugin.matches(type, type2) && ServerPlugin.matches(version, version2 = moduleType.getVersion());
    }

    public static boolean isSupportedModule(IModuleType moduleType, IModuleType mt) {
        if (moduleType == null || mt == null) {
            throw new IllegalArgumentException();
        }
        return ServerPlugin.matches(mt.getId(), moduleType.getId()) && ServerPlugin.matches(mt.getVersion(), moduleType.getVersion());
    }

    public static void modifyModules(IServerWorkingCopy server, IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
        if (server == null) {
            throw new IllegalArgumentException("Server cannot be null");
        }
        if (add == null) {
            add = new IModule[]{};
        }
        if (remove == null) {
            remove = new IModule[]{};
        }
        IModule[] iModuleArray = add;
        int n = add.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            if (module == null) {
                throw new IllegalArgumentException("Cannot add null entries");
            }
            ++n2;
        }
        ArrayList<IModule> addParentModules = new ArrayList<IModule>();
        IModule[] iModuleArray2 = add;
        int n3 = add.length;
        n = 0;
        while (n < n3) {
            boolean found;
            IModule module;
            block19: {
                module = iModuleArray2[n];
                found = false;
                try {
                    IModule[] parents = server.getRootModules(module, monitor);
                    if (parents != null && parents.length > 0) {
                        IModule parent = parents[0];
                        found = true;
                        if (!addParentModules.contains(parent)) {
                            addParentModules.add(parent);
                        }
                    }
                }
                catch (Exception e) {
                    if (!Trace.WARNING) break block19;
                    Trace.trace("/warning", "Could not find parent module", e);
                }
            }
            if (!found) {
                addParentModules.add(module);
            }
            ++n;
        }
        iModuleArray2 = remove;
        n3 = remove.length;
        n = 0;
        while (n < n3) {
            IModule module = iModuleArray2[n];
            if (module == null) {
                throw new IllegalArgumentException("Cannot remove null entries");
            }
            ++n;
        }
        ArrayList<IModule> removeParentModules = new ArrayList<IModule>();
        IModule[] iModuleArray3 = remove;
        int n4 = remove.length;
        n3 = 0;
        while (n3 < n4) {
            boolean found;
            IModule module;
            block20: {
                module = iModuleArray3[n3];
                found = false;
                try {
                    IModule[] parents = server.getRootModules(module, monitor);
                    if (parents != null && parents.length > 0) {
                        IModule parent = parents[0];
                        found = true;
                        if (!removeParentModules.contains(parent)) {
                            removeParentModules.add(parent);
                        }
                    }
                }
                catch (Exception e) {
                    if (!Trace.WARNING) break block20;
                    Trace.trace("/warning", "Could not find parent module 2", e);
                }
            }
            if (!found) {
                removeParentModules.add(module);
            }
            ++n3;
        }
        IModule[] add2 = new IModule[addParentModules.size()];
        addParentModules.toArray(add2);
        IModule[] remove2 = new IModule[removeParentModules.size()];
        removeParentModules.toArray(remove2);
        server.modifyModules(add2, remove2, monitor);
    }

    public static void setRuntimeDefaultName(IRuntimeWorkingCopy runtime) {
        ServerUtil.setRuntimeDefaultName(runtime, -1);
    }

    public static int setRuntimeDefaultName(IRuntimeWorkingCopy runtime, int suffix) {
        String typeName = runtime.getRuntimeType().getName();
        String name = null;
        if (suffix == -1) {
            name = NLS.bind((String)Messages.defaultRuntimeName, (Object)typeName);
            suffix = 2;
        } else {
            name = NLS.bind((String)Messages.defaultRuntimeName2, (Object[])new String[]{typeName, String.valueOf(suffix)});
        }
        while (ServerPlugin.isNameInUse(runtime.getOriginal(), name)) {
            name = NLS.bind((String)Messages.defaultRuntimeName2, (Object[])new String[]{typeName, String.valueOf(++suffix)});
        }
        runtime.setName(name);
        return suffix;
    }

    public static void setServerDefaultName(IServerWorkingCopy server) {
        if (server == null) {
            throw new IllegalArgumentException();
        }
        String typeName = server.getServerType().getName();
        String host = server.getHost();
        IRuntime runtime = server.getRuntime();
        if (runtime != null && !(runtime instanceof RuntimeWorkingCopy)) {
            IRuntimeWorkingCopy wc = runtime.createWorkingCopy();
            ServerUtil.setRuntimeDefaultName(wc);
            if (!wc.getName().equals(runtime.getName())) {
                typeName = runtime.getName();
            }
        }
        String name = NLS.bind((String)Messages.defaultServerName, (Object[])new String[]{typeName, host});
        int i = 2;
        while (ServerPlugin.isNameInUse(server.getOriginal(), name)) {
            name = NLS.bind((String)Messages.defaultServerName2, (Object[])new String[]{typeName, host, String.valueOf(i)});
            ++i;
        }
        server.setName(name);
    }

    private static boolean isValidFilename(String name) {
        IStatus status = ResourcesPlugin.getWorkspace().validateName(name, 1);
        if (status != null && !status.isOK()) {
            return false;
        }
        status = ResourcesPlugin.getWorkspace().validateName(name, 2);
        return status == null || status.isOK();
    }

    private static String getValidFileName(String name) {
        if (ServerUtil.isValidFilename(name)) {
            return name;
        }
        String[] s = new String[]{".", "\\", "/", "?", ":", "*", "\"", "|", "<", ">"};
        int ind = 0;
        while (ind < s.length) {
            int index = name.indexOf(s[ind]);
            while (index >= 0) {
                name = String.valueOf(name.substring(0, index)) + name.substring(index + 1);
                index = name.indexOf(s[ind]);
            }
            ++ind;
        }
        return name;
    }

    public static IFile getUnusedServerFile(IProject project, IServer server) {
        if (project == null || server == null) {
            throw new IllegalArgumentException();
        }
        String typeName = ServerUtil.getValidFileName(server.getName());
        String name = String.valueOf(NLS.bind((String)Messages.defaultServerName3, (Object)typeName)) + "." + "server";
        int i = 2;
        while (ServerUtil.isFileNameInUse(project, name)) {
            name = String.valueOf(NLS.bind((String)Messages.defaultServerName4, (Object[])new String[]{typeName, String.valueOf(i)})) + "." + "server";
            ++i;
        }
        return project.getFile(name);
    }

    private static boolean isFileNameInUse(IProject project, String name) {
        if (name == null || project == null) {
            return false;
        }
        if (project.getFile(name).exists()) {
            return true;
        }
        return project.getFolder(name).exists();
    }

    public static IRuntime[] getRuntimes(String type, String version) {
        ArrayList<IRuntime> list = new ArrayList<IRuntime>();
        IRuntime[] runtimes = ServerCore.getRuntimes();
        if (runtimes != null) {
            IRuntime[] iRuntimeArray = runtimes;
            int n = runtimes.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntime runtime = iRuntimeArray[n2];
                IRuntimeType runtimeType = runtime.getRuntimeType();
                if (runtimeType != null && ServerUtil.isSupportedModule(runtimeType.getModuleTypes(), type, version)) {
                    list.add(runtime);
                }
                ++n2;
            }
        }
        IRuntime[] runtimes2 = new IRuntime[list.size()];
        list.toArray(runtimes2);
        return runtimes2;
    }

    public static IRuntimeType[] getRuntimeTypes(String type, String version) {
        ArrayList<IRuntimeType> list = new ArrayList<IRuntimeType>();
        IRuntimeType[] runtimeTypes = ServerCore.getRuntimeTypes();
        if (runtimeTypes != null) {
            IRuntimeType[] iRuntimeTypeArray = runtimeTypes;
            int n = runtimeTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntimeType runtimeType = iRuntimeTypeArray[n2];
                if (ServerUtil.isSupportedModule(runtimeType.getModuleTypes(), type, version)) {
                    list.add(runtimeType);
                }
                ++n2;
            }
        }
        IRuntimeType[] rt = new IRuntimeType[list.size()];
        list.toArray(rt);
        return rt;
    }

    public static IRuntimeType[] getRuntimeTypes(String type, String version, String runtimeTypeId) {
        ArrayList<IRuntimeType> list = new ArrayList<IRuntimeType>();
        IRuntimeType[] runtimeTypes = ServerCore.getRuntimeTypes();
        if (runtimeTypes != null) {
            IRuntimeType[] iRuntimeTypeArray = runtimeTypes;
            int n = runtimeTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntimeType runtimeType = iRuntimeTypeArray[n2];
                if (ServerUtil.isSupportedModule(runtimeType.getModuleTypes(), type, version)) {
                    if (runtimeTypeId == null) {
                        list.add(runtimeType);
                    } else {
                        StringTokenizer tokenizer = new StringTokenizer(runtimeTypeId, ",");
                        while (tokenizer.hasMoreTokens()) {
                            String curRuntimeTypeId = tokenizer.nextToken();
                            if (!runtimeType.getId().startsWith(curRuntimeTypeId)) continue;
                            list.add(runtimeType);
                        }
                    }
                }
                ++n2;
            }
        }
        IRuntimeType[] rt = new IRuntimeType[list.size()];
        list.toArray(rt);
        return rt;
    }

    public static IServer[] getAvailableServersForModule(IModule module, boolean includeErrors, IProgressMonitor monitor) {
        if (module == null) {
            return new IServer[0];
        }
        ArrayList<IServer> list = new ArrayList<IServer>();
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            IServer[] iServerArray = servers;
            int n = servers.length;
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    IServer server = iServerArray[n2];
                    if (!ServerUtil.containsModule(server, module, monitor)) {
                        try {
                            IModule[] parents = server.getRootModules(module, monitor);
                            if (parents != null && parents.length > 0) {
                                boolean found = false;
                                int size2 = parents.length;
                                int j = 0;
                                while (!found && j < size2) {
                                    IModule parent = parents[j];
                                    IStatus status = server.canModifyModules(new IModule[]{parent}, new IModule[0], monitor);
                                    if (status == null || status.isOK()) {
                                        list.add(server);
                                        found = true;
                                    }
                                    ++j;
                                }
                            }
                        }
                        catch (Exception exception) {
                            if (!includeErrors) break block9;
                            list.add(server);
                        }
                    }
                }
                ++n2;
            }
        }
        IServer[] allServers = new IServer[list.size()];
        list.toArray(allServers);
        return allServers;
    }

    public static IServer[] getServersByModule(IModule module, IProgressMonitor monitor) {
        if (module == null) {
            return new IServer[0];
        }
        ArrayList<IServer> list = new ArrayList<IServer>();
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            IServer[] iServerArray = servers;
            int n = servers.length;
            int n2 = 0;
            while (n2 < n) {
                IServer server = iServerArray[n2];
                if (ServerUtil.containsModule(server, module, monitor)) {
                    list.add(server);
                }
                ++n2;
            }
        }
        IServer[] allServers = new IServer[list.size()];
        list.toArray(allServers);
        return allServers;
    }

    public static boolean containsModule(IServer server, final IModule module, IProgressMonitor monitor) {
        if (server == null || module == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        if (Trace.FINEST) {
            Trace.trace("/finest", "containsModule() " + server + " " + module);
        }
        final boolean[] b = new boolean[1];
        ((Server)server).visit(new IModuleVisitor(){

            public boolean visit(IModule[] modules) {
                int size = modules.length;
                if (modules[size - 1].equals(module)) {
                    b[0] = true;
                    return false;
                }
                return true;
            }
        }, null);
        return b[0];
    }

    public static IServer getServer(ILaunchConfiguration configuration) throws CoreException {
        String serverId = configuration.getAttribute("server-id", null);
        if (serverId != null) {
            return ServerCore.findServer(serverId);
        }
        return null;
    }

    public static IStatus validateEdit(Object context, IServer server) {
        return ((Server)server).validateEdit(context);
    }

    public static int getMonitoredPort(IServer server, int port, String contentType) {
        return ServerMonitorManager.getInstance().getMonitoredPort(server, port, contentType);
    }

    public static ISchedulingRule getServerSchedulingRule(IServer server) {
        return server;
    }
}

