/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractTaskRepositoryPageContribution;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTaskRepositoryPage
extends WizardPage
implements ITaskRepositoryPage {
    private static final String CLASS = "class";
    private static final String ID = "id";
    private static final String KIND = "connectorKind";
    private static final String TASK_REPOSITORY_PAGE_CONTRIBUTION = "taskRepositoryPageContribution";
    private static final String TASK_REPOSITORY_PAGE_CONTRIBUTION_EXTENSION = "org.eclipse.mylyn.tasks.ui.taskRepositoryPageContribution";
    private static final Comparator<AbstractTaskRepositoryPageContribution> CONTRIBUTION_COMPARATOR = new ContributionComparator();
    private final TaskRepository repository;
    private final List<AbstractTaskRepositoryPageContribution> contributions;
    FormToolkit toolkit;
    private final AbstractTaskRepositoryPageContribution.Listener contributionListener = new AbstractTaskRepositoryPageContribution.Listener(){

        public void validationRequired(AbstractTaskRepositoryPageContribution contribution) {
            AbstractTaskRepositoryPage.this.validatePageSettings();
        }
    };

    public AbstractTaskRepositoryPage(String title, String description, TaskRepository repository) {
        super(title);
        if (repository != null && !repository.getConnectorKind().equals(this.getConnectorKind())) {
            throw new IllegalArgumentException("connectorKind of repository does not match connectorKind of page, expected '" + this.getConnectorKind() + "', got '" + repository.getConnectorKind() + "'");
        }
        this.repository = repository;
        this.contributions = new ArrayList<AbstractTaskRepositoryPageContribution>();
        this.setTitle(title);
        this.setDescription(description);
    }

    public abstract String getConnectorKind();

    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        super.dispose();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.toolkit = new FormToolkit(TasksUiPlugin.getDefault().getFormColors(parent.getDisplay()));
        Composite compositeContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        compositeContainer.setLayout((Layout)layout);
        this.createSettingControls(compositeContainer);
        this.createContributionControls(compositeContainer);
        Dialog.applyDialogFont((Control)compositeContainer);
        this.setControl((Control)compositeContainer);
    }

    protected abstract void createSettingControls(Composite var1);

    public boolean isPageComplete() {
        return super.isPageComplete() && this.conributionsIsPageComplete();
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && this.contributionsCanFlipToNextPage();
    }

    private boolean contributionsCanFlipToNextPage() {
        for (AbstractTaskRepositoryPageContribution contribution : this.contributions) {
            if (contribution.canFlipToNextPage()) continue;
            return false;
        }
        return true;
    }

    private boolean conributionsIsPageComplete() {
        for (AbstractTaskRepositoryPageContribution contribution : this.contributions) {
            if (contribution.isPageComplete()) continue;
            return false;
        }
        return true;
    }

    protected void createContributionControls(Composite parentControl) {
        this.contributions.clear();
        this.contributions.addAll(this.findApplicableContributors());
        if (!this.contributions.isEmpty()) {
            final ArrayList badContributions = new ArrayList();
            for (final AbstractTaskRepositoryPageContribution contribution : this.contributions) {
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        contribution.init(AbstractTaskRepositoryPage.this.getConnectorKind(), AbstractTaskRepositoryPage.this.repository);
                        contribution.addListener(AbstractTaskRepositoryPage.this.contributionListener);
                    }

                    public void handleException(Throwable e) {
                        badContributions.add(contribution);
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"Problems occured when initializing contribution \"{0}\"", (Object)contribution.getId()), e));
                    }
                });
            }
            this.contributions.removeAll(badContributions);
            Collections.sort(this.contributions, CONTRIBUTION_COMPARATOR);
            for (final AbstractTaskRepositoryPageContribution contribution : this.contributions) {
                final ExpandableComposite section = this.createSection(parentControl, contribution.getTitle());
                section.setToolTipText(contribution.getDescription());
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        Control control = contribution.createControl((Composite)section);
                        section.setClient(control);
                    }

                    public void handleException(Throwable e) {
                        section.dispose();
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"Problems occured when creating control for contribution \"{0}\"", (Object)contribution.getId()), e));
                    }
                });
            }
        }
    }

    protected ExpandableComposite createSection(final Composite parentControl, String title) {
        ExpandableComposite section = this.toolkit.createExpandableComposite(parentControl, 50);
        section.clientVerticalSpacing = 0;
        section.setBackground(parentControl.getBackground());
        section.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                parentControl.layout(true);
                AbstractTaskRepositoryPage.this.getControl().getShell().pack();
            }
        });
        section.setText(title);
        GridDataFactory.fillDefaults().indent(0, 5).grab(true, false).span(3, -1).applyTo((Control)section);
        return section;
    }

    protected abstract IStatus validate();

    @Override
    public void applyTo(TaskRepository repository) {
        this.applyContributionSettingsTo(repository);
    }

    private void applyContributionSettingsTo(TaskRepository repository) {
        for (AbstractTaskRepositoryPageContribution contribution : this.contributions) {
            contribution.applyTo(repository);
        }
    }

    @Override
    public void performFinish(TaskRepository repository) {
        this.applyTo(repository);
    }

    private IStatus computeValidation() {
        final MultiStatus cumulativeResult = new MultiStatus("org.eclipse.mylyn.tasks.ui", 0, Messages.AbstractTaskRepositoryPage_Validation_failed, null);
        IStatus result = this.validate();
        if (result != null) {
            cumulativeResult.add(result);
        }
        for (final AbstractTaskRepositoryPageContribution contribution : this.contributions) {
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    IStatus result = contribution.validate();
                    if (result != null) {
                        cumulativeResult.add(result);
                    }
                }

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"Problems occured when validating contribution \"{0}\"", (Object)contribution.getId()), e));
                }
            });
        }
        return cumulativeResult;
    }

    private void validatePageSettings() {
        IStatus validationStatus = this.computeValidation();
        this.applyValidationResult(validationStatus);
        this.getWizard().getContainer().updateButtons();
    }

    private void applyValidationResult(IStatus status) {
        if (status == null || status.isOK()) {
            this.setMessage(null, 1);
            this.setErrorMessage(null);
        } else {
            int messageType;
            switch (status.getSeverity()) {
                case 0: 
                case 1: {
                    messageType = 1;
                    break;
                }
                case 2: {
                    messageType = 2;
                    break;
                }
                default: {
                    messageType = 3;
                }
            }
            this.setErrorMessage(null);
            this.setMessage(status.getMessage(), messageType);
        }
    }

    private List<AbstractTaskRepositoryPageContribution> findApplicableContributors() {
        IExtension[] editorExtensions;
        ArrayList<AbstractTaskRepositoryPageContribution> contributors = new ArrayList<AbstractTaskRepositoryPageContribution>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint editorExtensionPoint = registry.getExtensionPoint(TASK_REPOSITORY_PAGE_CONTRIBUTION_EXTENSION);
        IExtension[] iExtensionArray = editorExtensions = editorExtensionPoint.getExtensions();
        int n = editorExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                String kind;
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(TASK_REPOSITORY_PAGE_CONTRIBUTION) && ((kind = element.getAttribute(KIND)) == null || kind.length() == 0 || kind.equals(this.getConnectorKind()))) {
                    String id = element.getAttribute(ID);
                    try {
                        if (id == null || id.length() == 0) {
                            throw new IllegalStateException("taskRepositoryPageContribution/@id is required");
                        }
                        Object contributor = element.createExecutableExtension(CLASS);
                        AbstractTaskRepositoryPageContribution pageContributor = (AbstractTaskRepositoryPageContribution)contributor;
                        pageContributor.setId(id);
                        if (pageContributor.isEnabled()) {
                            contributors.add(pageContributor);
                        }
                    }
                    catch (Throwable e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load taskRepositoryPageContribution '" + id + "' from plug-in " + element.getContributor().getName(), e));
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return contributors;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContributionComparator
    implements Comparator<AbstractTaskRepositoryPageContribution> {
        private ContributionComparator() {
        }

        @Override
        public int compare(AbstractTaskRepositoryPageContribution o1, AbstractTaskRepositoryPageContribution o2) {
            String s2;
            if (o1 == o2) {
                return 0;
            }
            String s1 = o1.getTitle();
            int i = s1.compareTo(s2 = o2.getTitle());
            if (i == 0) {
                i = o1.getId().compareTo(o2.getId());
            }
            return i;
        }
    }
}

