/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath.core.util;

import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.wst.xml.xpath.core.util.NodeListImpl;
import org.eclipse.wst.xml.xpath.core.util.SimpleXPathEngine;
import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.StaticContext;
import org.eclipse.wst.xml.xpath2.api.XPath2Expression;
import org.eclipse.wst.xml.xpath2.processor.Engine;
import org.eclipse.wst.xml.xpath2.processor.JFlexCupParser;
import org.eclipse.wst.xml.xpath2.processor.StaticError;
import org.eclipse.wst.xml.xpath2.processor.XPathParserException;
import org.eclipse.wst.xml.xpath2.processor.util.DynamicContextBuilder;
import org.eclipse.wst.xml.xpath2.processor.util.StaticContextBuilder;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPath20Helper {
    public static void compile(String xpathExp) throws XPathExpressionException {
        try {
            JFlexCupParser xpathParser = new JFlexCupParser();
            xpathParser.parse(xpathExp);
        }
        catch (XPathParserException ex) {
            throw new XPathExpressionException(ex.getMessage());
        }
    }

    public static class XPath2Engine
    implements SimpleXPathEngine {
        private NamespaceContext namespaceContext;
        private StaticContextBuilder staticContextBuilder = new StaticContextBuilder(){

            public NamespaceContext getNamespaceContext() {
                return XPath2Engine.this.namespaceContext;
            }
        };
        private XPath2Expression xPathExpression;

        public void parse(String expression) throws XPathExpressionException {
            this.xPathExpression = null;
            try {
                this.xPathExpression = new Engine().parseExpression(expression, (StaticContext)this.staticContextBuilder);
            }
            catch (StaticError se) {
                throw new XPathExpressionException(String.valueOf(se.getMessage()) + " (" + se.code() + ")");
            }
        }

        public boolean isValid() {
            return this.xPathExpression != null;
        }

        public NodeList execute(Node contextNode) {
            DynamicContextBuilder dynContext = new DynamicContextBuilder((StaticContext)this.staticContextBuilder);
            ResultSequence rs = this.xPathExpression.evaluate((DynamicContext)dynContext, new Object[]{contextNode});
            return new NodeListImpl(rs);
        }

        public void setNamespaceContext(NamespaceContext namespaceContext) {
            this.namespaceContext = namespaceContext;
        }
    }
}

