/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.tasks.bugs.AttributeTaskMapper;
import org.eclipse.mylyn.internal.tasks.bugs.SupportProduct;
import org.eclipse.mylyn.internal.tasks.bugs.SupportProviderManager;
import org.eclipse.mylyn.tasks.bugs.IProduct;
import org.eclipse.mylyn.tasks.bugs.ISupportRequest;
import org.eclipse.mylyn.tasks.bugs.ITaskContribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportRequest
implements ISupportRequest {
    private final Map<String, ITaskContribution> contributionByProductId;
    private final IStatus status;
    private final SupportProviderManager providerManager;
    private AttributeTaskMapper defaultContribution;
    private final IProduct product;

    public SupportRequest(SupportProviderManager providerManager, IStatus status, IProduct product) {
        this.providerManager = providerManager;
        this.status = status;
        this.contributionByProductId = new HashMap<String, ITaskContribution>();
        if (product != null) {
            this.product = product;
            this.defaultContribution = this.process(this.getNamespace(), (SupportProduct)product);
        } else {
            this.product = null;
            this.process();
        }
    }

    public SupportRequest(SupportProviderManager providerManager, IStatus status) {
        this(providerManager, status, null);
    }

    @Override
    public ITaskContribution getOrCreateContribution(IProduct product) {
        ITaskContribution contribution = this.contributionByProductId.get(product.getId());
        if (contribution == null) {
            contribution = new AttributeTaskMapper(this.status, product);
            this.contributionByProductId.put(product.getId(), contribution);
        }
        return contribution;
    }

    @Override
    public ITaskContribution getDefaultContribution() {
        if (this.defaultContribution == null) {
            String namespace = this.getNamespace();
            Map<String, String> attributes = this.providerManager.getDefaultProduct().getAllAttributes(namespace);
            this.defaultContribution = new AttributeTaskMapper(this.status, this.providerManager.getDefaultProduct());
            this.defaultContribution.getAttributes().putAll(attributes);
        }
        return this.defaultContribution;
    }

    public IProduct getProduct() {
        return this.product;
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }

    private void process() {
        String namespace = this.getNamespace();
        Collection<SupportProduct> products = this.providerManager.getProducts();
        for (SupportProduct product : products) {
            this.process(namespace, product);
        }
    }

    private AttributeTaskMapper process(String namespace, SupportProduct product) {
        Map<String, String> productAttributes = product.getAllAttributes(namespace);
        if (!productAttributes.isEmpty()) {
            Map<String, String> attributes = this.providerManager.getDefaultProduct().getAllAttributes(namespace);
            attributes.putAll(productAttributes);
            AttributeTaskMapper contribution = (AttributeTaskMapper)this.getOrCreateContribution(product);
            contribution.getAttributes().putAll(attributes);
            return contribution;
        }
        return null;
    }

    private String getNamespace() {
        return this.status.getPlugin();
    }

    public List<ITaskContribution> getContributions() {
        return new ArrayList<ITaskContribution>(this.contributionByProductId.values());
    }
}

