/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.loaders;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.enablement.ingres.internal.loaders.LoaderHelper;
import org.eclipse.datatools.enablement.ingres.models.ingressqlmodel.IngresSynonym;
import org.eclipse.datatools.enablement.ingres.models.ingressqlmodel.IngressqlmodelFactory;
import org.eclipse.datatools.modelbase.sql.schema.Schema;

public class IngresSynonymLoader
extends JDBCBaseLoader {
    private static final String SYNONYM_QUERY = "SELECT DISTINCT synonym_name, synonym_owner, table_name, table_owner FROM iisynonyms WHERE synonym_owner = ?";
    private static final String SYNONYM_NAME = "synonym_name";
    private static final String TABLE_NAME = "table_name";

    public IngresSynonymLoader() {
        this(null);
    }

    public IngresSynonymLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public IngresSynonymLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
    }

    public void loadSynonyms(List containmentList, List existingSynonyms) throws SQLException {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            stmt = this.getCatalogObject().getConnection().prepareStatement(SYNONYM_QUERY);
            rs = this.createResultSet(stmt);
            String synonymName = null;
            while (rs.next()) {
                synonymName = rs.getString(SYNONYM_NAME).trim();
                IngresSynonym synonym = (IngresSynonym)this.getAndRemoveSQLObject(existingSynonyms, synonymName);
                if (synonym == null) {
                    synonym = this.processRow(rs);
                    if (synonym == null) continue;
                    containmentList.add(synonym);
                    continue;
                }
                containmentList.add(synonym);
                if (!(synonym instanceof ICatalogObject)) continue;
                ((ICatalogObject)synonym).refresh();
            }
        }
        catch (Throwable throwable) {
            LoaderHelper.close(rs);
            LoaderHelper.close(stmt);
            throw throwable;
        }
        LoaderHelper.close(rs);
        LoaderHelper.close(stmt);
    }

    public void clearSynonyms(List existingSynonyms) {
        existingSynonyms.clear();
    }

    protected ResultSet createResultSet(PreparedStatement stmt) throws SQLException {
        try {
            String schema = ((Schema)this.getCatalogObject()).getName();
            stmt.setString(1, schema);
            return stmt.executeQuery();
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException("Error while retrieving catalog information (db event)");
            error.initCause(e);
            throw error;
        }
    }

    protected IngresSynonym processRow(ResultSet rs) throws SQLException {
        IngresSynonym synonym = this.createSynonym();
        this.initialize(synonym, rs);
        return synonym;
    }

    protected void initialize(IngresSynonym synonym, ResultSet rs) throws SQLException {
        String synonymName = rs.getString(SYNONYM_NAME).trim();
        String tableName = rs.getString(TABLE_NAME).trim();
        synonym.setName(synonymName);
        synonym.setTableName(tableName);
    }

    protected IngresSynonym createSynonym() {
        return IngressqlmodelFactory.eINSTANCE.createIngresSynonym();
    }
}

