/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core;

import java.io.PrintStream;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.core.internal.JptCommonCoreMessages;
import org.eclipse.jpt.common.utility.Command;
import org.eclipse.jpt.common.utility.internal.AsynchronousCommandExecutor;
import org.eclipse.jpt.common.utility.internal.SimpleCommandExecutor;
import org.eclipse.jpt.common.utility.internal.StatefulCommandExecutor;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.SynchronizedBoolean;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.jaxb.core.JaxbFacet;
import org.eclipse.jpt.jaxb.core.JaxbFile;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JaxbProjectManager;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.internal.SimpleJaxbProjectConfig;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDefinition;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenericJaxbProjectManager
extends AbstractModel
implements JaxbProjectManager {
    private final Vector<JaxbProject> jaxbProjects = new Vector();
    final ILock lock = this.getJobManager().newLock();
    private volatile StatefulCommandExecutor eventHandler = new AsynchronousCommandExecutor(JptCommonCoreMessages.DALI_EVENT_HANDLER_THREAD_NAME);
    private final IResourceChangeListener resourceChangeListener = new ResourceChangeListener();
    private static final int RESOURCE_CHANGE_EVENT_TYPES = 17;
    private static final String FACETED_PROJECT_FRAMEWORK_SETTINGS_FILE_NAME = "org.eclipse.wst.common.project.facet.core.xml";
    private final IFacetedProjectListener facetedProjectListener = new FacetedProjectListener();
    private static final IFacetedProjectEvent.Type[] FACETED_PROJECT_EVENT_TYPES = new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PRE_UNINSTALL};
    private final JavaElementChangeListener javaElementChangeListener = new JavaElementChangeListener();
    private static final int JAVA_CHANGE_EVENT_TYPES = 5;
    private static final boolean DEBUG = false;

    GenericJaxbProjectManager() {
    }

    void start() {
        try {
            this.lock.acquire();
            this.start_();
        }
        finally {
            this.lock.release();
        }
    }

    private void start_() {
        GenericJaxbProjectManager.debug("*** JAXB project manager START ***");
        try {
            this.buildJaxbProjects();
            this.eventHandler.start();
            this.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 17);
            FacetedProjectFramework.addListener((IFacetedProjectListener)this.facetedProjectListener, (IFacetedProjectEvent.Type[])FACETED_PROJECT_EVENT_TYPES);
            JavaCore.addElementChangedListener((IElementChangedListener)this.javaElementChangeListener, (int)5);
        }
        catch (RuntimeException ex) {
            JptJaxbCorePlugin.log(ex);
            this.stop_();
        }
    }

    private void buildJaxbProjects() {
        try {
            this.buildJaxbProjects_();
        }
        catch (CoreException ex) {
            JptJaxbCorePlugin.log(ex);
        }
    }

    private void buildJaxbProjects_() throws CoreException {
        this.getWorkspace().getRoot().accept((IResourceProxyVisitor)new ResourceProxyVisitor(), 0);
    }

    void stop() throws Exception {
        try {
            this.lock.acquire();
            this.stop_();
        }
        finally {
            this.lock.release();
        }
    }

    private void stop_() {
        GenericJaxbProjectManager.debug("*** JAXB project manager STOP ***");
        JavaCore.removeElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
        FacetedProjectFramework.removeListener((IFacetedProjectListener)this.facetedProjectListener);
        this.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.eventHandler.stop();
        this.clearJaxbProjects();
    }

    private void clearJaxbProjects() {
        for (JaxbProject jaxbProject : this.getJaxbProjects_()) {
            this.removeJaxbProject(jaxbProject);
        }
    }

    @Override
    public Iterable<JaxbProject> getJaxbProjects() {
        try {
            this.lock.acquire();
            Iterable<JaxbProject> iterable = this.getJaxbProjects_();
            return iterable;
        }
        finally {
            this.lock.release();
        }
    }

    private Iterable<JaxbProject> getJaxbProjects_() {
        return new LiveCloneIterable(this.jaxbProjects);
    }

    @Override
    public int getJaxbProjectsSize() {
        return this.jaxbProjects.size();
    }

    @Override
    public JaxbProject getJaxbProject(IProject project) {
        try {
            this.lock.acquire();
            JaxbProject jaxbProject = this.getJaxbProject_(project);
            return jaxbProject;
        }
        finally {
            this.lock.release();
        }
    }

    private JaxbProject getJaxbProject_(IProject project) {
        for (JaxbProject jaxbProject : this.jaxbProjects) {
            if (!jaxbProject.getProject().equals((Object)project)) continue;
            return jaxbProject;
        }
        return null;
    }

    @Override
    public JaxbFile getJaxbFile(IFile file) {
        JaxbProject jaxbProject = this.getJaxbProject(file.getProject());
        return jaxbProject == null ? null : jaxbProject.getJaxbFile(file);
    }

    @Override
    public void rebuildJaxbProject(IProject project) {
        try {
            this.lock.acquire();
            this.rebuildJaxbProject_(project);
        }
        finally {
            this.lock.release();
        }
    }

    private void rebuildJaxbProject_(IProject project) {
        this.removeJaxbProject(this.getJaxbProject_(project));
        this.addJaxbProject(project);
    }

    @Override
    public boolean javaElementChangeListenerIsActive() {
        return this.javaElementChangeListener.isActive();
    }

    @Override
    public void setJavaElementChangeListenerIsActive(boolean javaElementChangeListenerIsActive) {
        this.javaElementChangeListener.setActive(javaElementChangeListenerIsActive);
    }

    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public IJobManager getJobManager() {
        return Job.getJobManager();
    }

    void addJaxbProject(IProject project) {
        this.addJaxbProject(this.buildJaxbProject(project));
    }

    private void addJaxbProject(JaxbProject jaxbProject) {
        GenericJaxbProjectManager.dumpStackTrace("add: ", jaxbProject);
        if (jaxbProject != null) {
            this.addItemToCollection(jaxbProject, this.jaxbProjects, "jaxbProjects");
        }
    }

    private JaxbProject buildJaxbProject(IProject project) {
        return this.buildJaxbProject(this.buildJaxbProjectConfig(project));
    }

    private JaxbProject buildJaxbProject(JaxbProject.Config config) {
        JaxbPlatformDefinition platformDefinition = config.getPlatformDefinition();
        if (platformDefinition == null) {
            return null;
        }
        JaxbProject jaxbProject = this.buildJaxbProject(platformDefinition, config);
        if (jaxbProject == null) {
            return null;
        }
        return jaxbProject;
    }

    private JaxbProject buildJaxbProject(JaxbPlatformDefinition platformDefinition, JaxbProject.Config config) {
        try {
            return platformDefinition.getFactory().buildJaxbProject(config);
        }
        catch (RuntimeException ex) {
            JptJaxbCorePlugin.log(ex);
            return null;
        }
    }

    private JaxbProject.Config buildJaxbProjectConfig(IProject project) {
        SimpleJaxbProjectConfig config = new SimpleJaxbProjectConfig();
        config.setProject(project);
        config.setPlatformDefinition(JptJaxbCorePlugin.getJaxbPlatformManager().buildJaxbPlatformDefinition(project));
        return config;
    }

    void removeJaxbProject(JaxbProject jaxbProject) {
        GenericJaxbProjectManager.dumpStackTrace("remove: ", jaxbProject);
        this.removeItemFromCollection(jaxbProject, this.jaxbProjects, "jaxbProjects");
        jaxbProject.dispose();
    }

    void projectChanged(IResourceDelta delta) {
        this.eventHandler.execute(this.buildProjectChangedCommand(delta));
    }

    private Command buildProjectChangedCommand(final IResourceDelta delta) {
        return new EventHandlerCommand("Project POST_CHANGE Command"){

            void execute_() {
                GenericJaxbProjectManager.this.projectChanged_(delta);
            }
        };
    }

    void projectChanged_(IResourceDelta delta) {
        for (JaxbProject jaxbProject : this.jaxbProjects) {
            jaxbProject.projectChanged(delta);
        }
    }

    void projectPostCleanBuild(IProject project) {
        this.executeAfterEventsHandled(this.buildProjectPostCleanBuildCommand(project));
    }

    private Command buildProjectPostCleanBuildCommand(final IProject project) {
        return new EventHandlerCommand("Project POST_BUILD (CLEAN_BUILD) Command"){

            void execute_() {
                GenericJaxbProjectManager.this.projectPostCleanBuild_(project);
            }
        };
    }

    void projectPostCleanBuild_(IProject project) {
        JaxbProject jaxbProject = this.getJaxbProject_(project);
        if (jaxbProject != null) {
            this.removeJaxbProject(jaxbProject);
            this.addJaxbProject(project);
        }
    }

    void checkForJaxbFacetTransition(IProject project) {
        JaxbProject jaxbProject = this.getJaxbProject_(project);
        if (JaxbFacet.isInstalled(project)) {
            if (jaxbProject == null) {
                this.executeAfterEventsHandled(this.buildAddJaxbProjectCommand(project));
            }
        } else if (jaxbProject != null) {
            this.executeAfterEventsHandled(this.buildRemoveJaxbProjectCommand(jaxbProject));
        }
    }

    private Command buildAddJaxbProjectCommand(final IProject project) {
        return new EventHandlerCommand("Add JAXB Project Command"){

            void execute_() {
                GenericJaxbProjectManager.this.addJaxbProject(project);
            }
        };
    }

    private Command buildRemoveJaxbProjectCommand(final JaxbProject jaxbProject) {
        return new EventHandlerCommand("Remove JAXB Project Command"){

            void execute_() {
                GenericJaxbProjectManager.this.removeJaxbProject(jaxbProject);
            }
        };
    }

    void jaxbFacetedProjectPreUninstall(IProjectFacetActionEvent event) {
        IProject project = event.getProject().getProject();
        this.executeAfterEventsHandled(this.buildJaxbFacetedProjectPreUninstallCommand(project));
    }

    private Command buildJaxbFacetedProjectPreUninstallCommand(final IProject project) {
        return new EventHandlerCommand("Faceted Project PRE_UNINSTALL Command"){

            void execute_() {
                GenericJaxbProjectManager.this.jaxbFacetedProjectPreUninstall_(project);
            }
        };
    }

    void jaxbFacetedProjectPreUninstall_(IProject project) {
        this.removeJaxbProject(this.getJaxbProject_(project));
    }

    void javaElementChanged(ElementChangedEvent event) {
        this.eventHandler.execute(this.buildJavaElementChangedCommand(event));
    }

    private Command buildJavaElementChangedCommand(final ElementChangedEvent event) {
        return new EventHandlerCommand("Java element changed Command"){

            void execute_() {
                GenericJaxbProjectManager.this.javaElementChanged_(event);
            }
        };
    }

    void javaElementChanged_(ElementChangedEvent event) {
        for (JaxbProject jaxbProject : this.jaxbProjects) {
            jaxbProject.javaElementChanged(event);
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.jaxbProjects);
    }

    private void executeAfterEventsHandled(Command command) {
        SynchronizedBoolean flag = new SynchronizedBoolean(false);
        this.eventHandler.execute((Command)new PauseCommand(flag));
        try {
            flag.waitUntilTrue();
        }
        catch (InterruptedException interruptedException) {}
        try {
            command.execute();
        }
        finally {
            flag.setFalse();
        }
    }

    public void handleEventsSynchronously() {
        try {
            this.lock.acquire();
            this.handleEventsSynchronously_();
        }
        finally {
            this.lock.release();
        }
    }

    private void handleEventsSynchronously_() {
        this.eventHandler.stop();
        this.eventHandler = new SimpleCommandExecutor();
        this.eventHandler.start();
    }

    static void debug(String message, Object object) {
    }

    static void debug(String message) {
    }

    private static void debug_(String message) {
        System.out.println(String.valueOf(Thread.currentThread().getName()) + ": " + message);
    }

    static void dumpStackTrace() {
        GenericJaxbProjectManager.dumpStackTrace(null);
    }

    static void dumpStackTrace(String message, Object object) {
    }

    static void dumpStackTrace(String message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpStackTrace_(String message) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            if (message != null) {
                GenericJaxbProjectManager.debug_(message);
            }
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            int i = 3;
            while (i < stackTrace.length) {
                StackTraceElement element = stackTrace[i];
                if (element.getMethodName().equals("invoke0")) break;
                System.out.println("\t" + element);
                ++i;
            }
        }
    }

    private abstract class EventHandlerCommand
    implements Command {
        private final String name;

        EventHandlerCommand(String name) {
            this.name = name;
        }

        public final void execute() {
            try {
                try {
                    GenericJaxbProjectManager.this.lock.acquire();
                    this.execute_();
                }
                catch (RuntimeException ex) {
                    JptJaxbCorePlugin.log(ex);
                    GenericJaxbProjectManager.this.lock.release();
                }
            }
            finally {
                GenericJaxbProjectManager.this.lock.release();
            }
        }

        abstract void execute_();

        public String toString() {
            return this.name;
        }
    }

    private class FacetedProjectListener
    implements IFacetedProjectListener {
        FacetedProjectListener() {
        }

        public void handleEvent(IFacetedProjectEvent event) {
            switch (event.getType()) {
                case PRE_UNINSTALL: {
                    this.processPreUninstallEvent((IProjectFacetActionEvent)event);
                    break;
                }
            }
        }

        private void processPreUninstallEvent(IProjectFacetActionEvent event) {
            GenericJaxbProjectManager.debug("Facet PRE_UNINSTALL: ", event.getProjectFacet());
            if (event.getProjectFacet().equals(JaxbFacet.FACET)) {
                GenericJaxbProjectManager.this.jaxbFacetedProjectPreUninstall(event);
            }
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    private class JavaElementChangeListener
    implements IElementChangedListener {
        private volatile boolean active = true;

        JavaElementChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (this.active) {
                GenericJaxbProjectManager.this.javaElementChanged(event);
            }
        }

        void setActive(boolean active) {
            this.active = active;
        }

        boolean isActive() {
            return this.active;
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    private static class PauseCommand
    implements Command {
        private final Thread producerThread;
        private final SynchronizedBoolean flag;

        PauseCommand(SynchronizedBoolean flag) {
            this(Thread.currentThread(), flag);
        }

        PauseCommand(Thread producerThread, SynchronizedBoolean flag) {
            this.producerThread = producerThread;
            this.flag = flag;
        }

        public void execute() {
            this.flag.setTrue();
            if (Thread.currentThread() != this.producerThread) {
                try {
                    this.flag.waitUntilFalse();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 1: {
                    this.processPostChangeEvent(event);
                    break;
                }
                case 32: {
                    break;
                }
                case 8: {
                    break;
                }
                case 16: {
                    this.processPostBuildEvent(event);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    break;
                }
            }
        }

        private void processPostChangeEvent(IResourceChangeEvent event) {
            GenericJaxbProjectManager.debug("Resource POST_CHANGE");
            this.processPostChangeDelta(event.getDelta());
        }

        private void processPostChangeDelta(IResourceDelta delta) {
            IResource resource = delta.getResource();
            switch (resource.getType()) {
                case 8: {
                    this.processPostChangeRootDelta(delta);
                    break;
                }
                case 4: {
                    this.processPostChangeProjectDelta(delta);
                    break;
                }
                case 2: {
                    this.processPostChangeFolderDelta((IFolder)resource, delta);
                    break;
                }
                case 1: {
                    this.processPostChangeFileDelta((IFile)resource, delta);
                    break;
                }
            }
        }

        private void processPostChangeRootDelta(IResourceDelta delta) {
            this.processPostChangeDeltaChildren(delta);
        }

        private void processPostChangeProjectDelta(IResourceDelta delta) {
            GenericJaxbProjectManager.this.projectChanged(delta);
            this.processPostChangeDeltaChildren(delta);
        }

        private void processPostChangeFolderDelta(IFolder folder, IResourceDelta delta) {
            if (folder.getName().equals(".settings")) {
                this.processPostChangeDeltaChildren(delta);
            }
        }

        private void processPostChangeFileDelta(IFile file, IResourceDelta delta) {
            if (file.getName().equals(GenericJaxbProjectManager.FACETED_PROJECT_FRAMEWORK_SETTINGS_FILE_NAME)) {
                this.checkForFacetFileChanges(file, delta);
            }
        }

        private void checkForFacetFileChanges(IFile file, IResourceDelta delta) {
            switch (delta.getKind()) {
                case 1: 
                case 2: 
                case 4: {
                    GenericJaxbProjectManager.this.checkForJaxbFacetTransition(file.getProject());
                    break;
                }
                case 8: {
                    break;
                }
                case 16: {
                    break;
                }
            }
        }

        private void processPostChangeDeltaChildren(IResourceDelta delta) {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta child = iResourceDeltaArray[n2];
                this.processPostChangeDelta(child);
                ++n2;
            }
        }

        private void processPostBuildEvent(IResourceChangeEvent event) {
            GenericJaxbProjectManager.debug("Resource POST_BUILD: ", event.getResource());
            if (event.getBuildKind() == 15) {
                this.processPostCleanBuildDelta(event.getDelta());
            }
        }

        private void processPostCleanBuildDelta(IResourceDelta delta) {
            IResource resource = delta.getResource();
            switch (resource.getType()) {
                case 8: {
                    this.processPostCleanBuildDeltaChildren(delta);
                    break;
                }
                case 4: {
                    this.processProjectPostCleanBuild((IProject)resource);
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    break;
                }
            }
        }

        private void processPostCleanBuildDeltaChildren(IResourceDelta delta) {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta child = iResourceDeltaArray[n2];
                this.processPostCleanBuildDelta(child);
                ++n2;
            }
        }

        private void processProjectPostCleanBuild(IProject project) {
            GenericJaxbProjectManager.debug("\tProject CLEAN: ", project.getName());
            GenericJaxbProjectManager.this.projectPostCleanBuild(project);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    private class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        ResourceProxyVisitor() {
        }

        public boolean visit(IResourceProxy resourceProxy) {
            switch (resourceProxy.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    this.processProject(resourceProxy);
                    return false;
                }
                case 2: {
                    return false;
                }
                case 1: {
                    return false;
                }
            }
            return false;
        }

        private void processProject(IResourceProxy resourceProxy) {
            IProject project;
            if (resourceProxy.isAccessible() && JaxbFacet.isInstalled(project = (IProject)resourceProxy.requestResource())) {
                GenericJaxbProjectManager.this.addJaxbProject(project);
            }
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

