/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbContextRoot;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbType;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.resource.java.source.SourceNode;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaType
extends AbstractJavaContextNode
implements JaxbType {
    protected final JavaResourceAbstractType resourceType;

    protected AbstractJavaType(JaxbContextRoot parent, JavaResourceAbstractType resourceType) {
        super(parent);
        this.resourceType = resourceType;
    }

    @Override
    public IResource getResource() {
        return this.resourceType.getFile();
    }

    @Override
    public JavaResourceAbstractType getJavaResourceType() {
        return this.resourceType;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.resourceType.getQualifiedName();
    }

    @Override
    public String getTypeQualifiedName() {
        String packageName = this.getPackageName();
        return packageName.length() == 0 ? this.getFullyQualifiedName() : this.getFullyQualifiedName().substring(packageName.length() + 1);
    }

    @Override
    public String getSimpleName() {
        return this.resourceType.getName();
    }

    @Override
    public String getPackageName() {
        return this.resourceType.getPackageName();
    }

    @Override
    public JaxbPackage getJaxbPackage() {
        return this.getContextRoot().getPackage(this.getPackageName());
    }

    @Override
    public Iterable<String> getDirectlyReferencedTypeNames() {
        return EmptyIterable.instance();
    }

    protected CompilationUnit buildASTRoot() {
        return this.resourceType.getJavaResourceCompilationUnit().buildASTRoot();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getJavaResourceType().getNameTextRange(astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        if (reporter.isCancelled()) {
            throw new ValidationCancelledException();
        }
        IFile file = this.resourceType.getFile();
        if (file != null && file.getProject().equals((Object)this.getJaxbProject().getProject()) && this.resourceType instanceof SourceNode) {
            this.validate(messages, reporter, this.buildASTRoot());
        }
    }
}

