/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.XmlAccessOrder;
import org.eclipse.jpt.jaxb.core.context.XmlAccessType;
import org.eclipse.jpt.jaxb.core.context.XmlJavaTypeAdapter;
import org.eclipse.jpt.jaxb.core.context.XmlSchema;
import org.eclipse.jpt.jaxb.core.context.XmlSchemaType;
import org.eclipse.jpt.jaxb.core.internal.AbstractJaxbNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaPackageXmlJavaTypeAdapter;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaPackageXmlSchemaType;
import org.eclipse.jpt.jaxb.core.internal.resource.java.source.SourceNode;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorOrderAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorTypeAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlJavaTypeAdapterAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSchemaTypeAnnotation;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaPackageInfo
extends AbstractJavaContextNode
implements JaxbPackageInfo {
    protected final JavaResourcePackage resourcePackage;
    protected final XmlSchema xmlSchema;
    protected XmlAccessType specifiedAccessType;
    protected XmlAccessOrder specifiedAccessOrder;
    protected final XmlSchemaTypeContainer xmlSchemaTypeContainer;
    protected final XmlJavaTypeAdapterContainer xmlJavaTypeAdapterContainer;

    public GenericJavaPackageInfo(JaxbPackage parent, JavaResourcePackage resourcePackage) {
        super(parent);
        this.resourcePackage = resourcePackage;
        this.xmlSchema = this.getFactory().buildJavaXmlSchema(this);
        this.specifiedAccessType = this.getResourceAccessType();
        this.specifiedAccessOrder = this.getResourceAccessOrder();
        this.xmlSchemaTypeContainer = new XmlSchemaTypeContainer();
        this.xmlJavaTypeAdapterContainer = new XmlJavaTypeAdapterContainer();
    }

    @Override
    public JaxbPackage getParent() {
        return (JaxbPackage)super.getParent();
    }

    @Override
    public JaxbPackage getJaxbPackage() {
        return this.getParent();
    }

    @Override
    public IResource getResource() {
        return this.resourcePackage.getFile();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.xmlSchema.synchronizeWithResourceModel();
        this.setSpecifiedAccessType_(this.getResourceAccessType());
        this.setSpecifiedAccessOrder_(this.getResourceAccessOrder());
        this.syncXmlSchemaTypes();
        this.syncXmlJavaTypeAdapters();
    }

    @Override
    public void update() {
        super.update();
        this.xmlSchema.update();
    }

    @Override
    public JavaResourcePackage getResourcePackage() {
        return this.resourcePackage;
    }

    @Override
    public XmlSchema getXmlSchema() {
        return this.xmlSchema;
    }

    @Override
    public XmlAccessType getAccessType() {
        return this.specifiedAccessType != null ? this.specifiedAccessType : this.getDefaultAccessType();
    }

    @Override
    public XmlAccessType getSpecifiedAccessType() {
        return this.specifiedAccessType;
    }

    @Override
    public void setSpecifiedAccessType(XmlAccessType access) {
        this.getAccessorTypeAnnotation().setValue(XmlAccessType.toJavaResourceModel(access));
        this.setSpecifiedAccessType_(access);
    }

    protected void setSpecifiedAccessType_(XmlAccessType access) {
        XmlAccessType old = this.specifiedAccessType;
        this.specifiedAccessType = access;
        this.firePropertyChanged("specifiedAccessType", (Object)old, (Object)access);
    }

    @Override
    public XmlAccessType getDefaultAccessType() {
        return XmlAccessType.PUBLIC_MEMBER;
    }

    protected XmlAccessType getResourceAccessType() {
        return XmlAccessType.fromJavaResourceModel(this.getAccessorTypeAnnotation().getValue());
    }

    protected XmlAccessorTypeAnnotation getAccessorTypeAnnotation() {
        return (XmlAccessorTypeAnnotation)this.resourcePackage.getNonNullAnnotation("javax.xml.bind.annotation.XmlAccessorType");
    }

    @Override
    public XmlAccessOrder getAccessOrder() {
        return this.specifiedAccessOrder != null ? this.specifiedAccessOrder : this.getDefaultAccessOrder();
    }

    @Override
    public XmlAccessOrder getSpecifiedAccessOrder() {
        return this.specifiedAccessOrder;
    }

    @Override
    public void setSpecifiedAccessOrder(XmlAccessOrder accessOrder) {
        this.getAccessorOrderAnnotation().setValue(XmlAccessOrder.toJavaResourceModel(accessOrder));
        this.setSpecifiedAccessOrder_(accessOrder);
    }

    protected void setSpecifiedAccessOrder_(XmlAccessOrder accessOrder) {
        XmlAccessOrder old = this.specifiedAccessOrder;
        this.specifiedAccessOrder = accessOrder;
        this.firePropertyChanged("specifiedAccessOrder", (Object)old, (Object)accessOrder);
    }

    @Override
    public XmlAccessOrder getDefaultAccessOrder() {
        return XmlAccessOrder.UNDEFINED;
    }

    protected XmlAccessOrder getResourceAccessOrder() {
        return XmlAccessOrder.fromJavaResourceModel(this.getAccessorOrderAnnotation().getValue());
    }

    protected XmlAccessorOrderAnnotation getAccessorOrderAnnotation() {
        return (XmlAccessorOrderAnnotation)this.resourcePackage.getNonNullAnnotation("javax.xml.bind.annotation.XmlAccessorOrder");
    }

    @Override
    public ListIterable<XmlSchemaType> getXmlSchemaTypes() {
        return this.xmlSchemaTypeContainer.getContextElements();
    }

    @Override
    public int getXmlSchemaTypesSize() {
        return this.xmlSchemaTypeContainer.getContextElementsSize();
    }

    @Override
    public XmlSchemaType addXmlSchemaType(int index) {
        XmlSchemaTypeAnnotation annotation = (XmlSchemaTypeAnnotation)this.resourcePackage.addAnnotation(index, "javax.xml.bind.annotation.XmlSchemaType");
        return (XmlSchemaType)this.xmlSchemaTypeContainer.addContextElement(index, annotation);
    }

    @Override
    public void removeXmlSchemaType(XmlSchemaType xmlSchemaType) {
        this.removeXmlSchemaType(this.xmlSchemaTypeContainer.indexOfContextElement(xmlSchemaType));
    }

    @Override
    public void removeXmlSchemaType(int index) {
        this.resourcePackage.removeAnnotation(index, "javax.xml.bind.annotation.XmlSchemaType");
        this.xmlSchemaTypeContainer.removeContextElement(index);
    }

    @Override
    public void moveXmlSchemaType(int targetIndex, int sourceIndex) {
        this.resourcePackage.moveAnnotation(targetIndex, sourceIndex, "javax.xml.bind.annotation.XmlSchemaType");
        this.xmlSchemaTypeContainer.moveContextElement(targetIndex, sourceIndex);
    }

    protected XmlSchemaType buildXmlSchemaType(XmlSchemaTypeAnnotation xmlSchemaTypeAnnotation) {
        return new GenericJavaPackageXmlSchemaType(this, xmlSchemaTypeAnnotation);
    }

    protected void syncXmlSchemaTypes() {
        this.xmlSchemaTypeContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlSchemaTypeAnnotation> getXmlSchemaTypeAnnotations() {
        return this.resourcePackage.getAnnotations("javax.xml.bind.annotation.XmlSchemaType");
    }

    @Override
    public ListIterable<XmlJavaTypeAdapter> getXmlJavaTypeAdapters() {
        return this.xmlJavaTypeAdapterContainer.getContextElements();
    }

    @Override
    public int getXmlJavaTypeAdaptersSize() {
        return this.xmlJavaTypeAdapterContainer.getContextElementsSize();
    }

    @Override
    public XmlJavaTypeAdapter addXmlJavaTypeAdapter(int index) {
        XmlJavaTypeAdapterAnnotation annotation = (XmlJavaTypeAdapterAnnotation)this.resourcePackage.addAnnotation(index, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        return (XmlJavaTypeAdapter)this.xmlJavaTypeAdapterContainer.addContextElement(index, annotation);
    }

    @Override
    public void removeXmlJavaTypeAdapter(XmlJavaTypeAdapter xmlSchemaType) {
        this.removeXmlJavaTypeAdapter(this.xmlJavaTypeAdapterContainer.indexOfContextElement(xmlSchemaType));
    }

    @Override
    public void removeXmlJavaTypeAdapter(int index) {
        this.resourcePackage.removeAnnotation(index, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        this.xmlJavaTypeAdapterContainer.removeContextElement(index);
    }

    @Override
    public void moveXmlJavaTypeAdapter(int targetIndex, int sourceIndex) {
        this.resourcePackage.moveAnnotation(targetIndex, sourceIndex, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        this.xmlJavaTypeAdapterContainer.moveContextElement(targetIndex, sourceIndex);
    }

    protected XmlJavaTypeAdapter buildXmlJavaTypeAdapter(XmlJavaTypeAdapterAnnotation xmlJavaTypeAdapterAnnotation) {
        return new GenericJavaPackageXmlJavaTypeAdapter(this, xmlJavaTypeAdapterAnnotation);
    }

    protected void syncXmlJavaTypeAdapters() {
        this.xmlJavaTypeAdapterContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlJavaTypeAdapterAnnotation> getXmlJavaTypeAdapterAnnotations() {
        return this.resourcePackage.getAnnotations("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
    }

    protected CompilationUnit buildASTRoot() {
        return this.resourcePackage.getJavaResourceCompilationUnit().buildASTRoot();
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        result = this.xmlSchema.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        for (XmlSchemaType xmlSchemaType : this.getXmlSchemaTypes()) {
            result = xmlSchemaType.getJavaCompletionProposals(pos, filter, astRoot);
            if (CollectionTools.isEmpty(result)) continue;
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.resourcePackage.getNameTextRange(astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        if (reporter.isCancelled()) {
            throw new ValidationCancelledException();
        }
        IFile file = this.resourcePackage.getFile();
        if (file != null && file.getProject().equals((Object)this.getJaxbProject().getProject()) && this.resourcePackage instanceof SourceNode) {
            this.validate(messages, reporter, this.buildASTRoot());
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.xmlSchema.validate(messages, reporter, astRoot);
        for (XmlJavaTypeAdapter adapter : this.getXmlJavaTypeAdapters()) {
            adapter.validate(messages, reporter, astRoot);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlJavaTypeAdapterContainer
    extends AbstractJaxbNode.ContextListContainer<XmlJavaTypeAdapter, XmlJavaTypeAdapterAnnotation> {
        protected XmlJavaTypeAdapterContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "xmlJavaTypeAdapters";
        }

        @Override
        protected XmlJavaTypeAdapter buildContextElement(XmlJavaTypeAdapterAnnotation resourceElement) {
            return GenericJavaPackageInfo.this.buildXmlJavaTypeAdapter(resourceElement);
        }

        @Override
        protected ListIterable<XmlJavaTypeAdapterAnnotation> getResourceElements() {
            return GenericJavaPackageInfo.this.getXmlJavaTypeAdapterAnnotations();
        }

        @Override
        protected XmlJavaTypeAdapterAnnotation getResourceElement(XmlJavaTypeAdapter contextElement) {
            return contextElement.getResourceXmlJavaTypeAdapter();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlSchemaTypeContainer
    extends AbstractJaxbNode.ContextListContainer<XmlSchemaType, XmlSchemaTypeAnnotation> {
        protected XmlSchemaTypeContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "xmlSchemaTypes";
        }

        @Override
        protected XmlSchemaType buildContextElement(XmlSchemaTypeAnnotation resourceElement) {
            return GenericJavaPackageInfo.this.buildXmlSchemaType(resourceElement);
        }

        @Override
        protected ListIterable<XmlSchemaTypeAnnotation> getResourceElements() {
            return GenericJavaPackageInfo.this.getXmlSchemaTypeAnnotations();
        }

        @Override
        protected XmlSchemaTypeAnnotation getResourceElement(XmlSchemaType contextElement) {
            return contextElement.getResourceXmlSchemaType();
        }
    }
}

