/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbContextRoot;
import org.eclipse.jpt.jaxb.core.context.JaxbElementFactoryMethod;
import org.eclipse.jpt.jaxb.core.context.JaxbRegistry;
import org.eclipse.jpt.jaxb.core.context.JaxbType;
import org.eclipse.jpt.jaxb.core.internal.AbstractJaxbNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaType;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceType;
import org.eclipse.jpt.jaxb.core.resource.java.XmlRegistryAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaRegistry
extends AbstractJavaType
implements JaxbRegistry {
    protected final ElementFactoryMethodContainer elementFactoryMethodContainer = new ElementFactoryMethodContainer();
    private static final String ELEMENT_FACTORY_METHOD_CREATE_PREFIX = "create";
    protected static final String JAXB_ELEMENT_TYPE_NAME = "javax.xml.bind.JAXBElement";

    public GenericJavaRegistry(JaxbContextRoot parent, JavaResourceType resourceType) {
        super(parent, resourceType);
    }

    @Override
    public JavaResourceType getJavaResourceType() {
        return (JavaResourceType)super.getJavaResourceType();
    }

    protected XmlRegistryAnnotation getAnnotation() {
        return (XmlRegistryAnnotation)this.getJavaResourceType().getNonNullAnnotation("javax.xml.bind.annotation.XmlRegistry");
    }

    @Override
    public JaxbType.Kind getKind() {
        return JaxbType.Kind.REGISTRY;
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.elementFactoryMethodContainer.synchronizeWithResourceModel();
    }

    @Override
    public void update() {
        super.update();
        this.elementFactoryMethodContainer.update();
    }

    @Override
    public Iterable<JaxbElementFactoryMethod> getElementFactoryMethods() {
        return this.elementFactoryMethodContainer.getContextElements();
    }

    @Override
    public int getElementFactoryMethodsSize() {
        return this.elementFactoryMethodContainer.getContextElementsSize();
    }

    private JaxbElementFactoryMethod buildElementFactoryMethod(JavaResourceMethod resourceMethod) {
        return this.getFactory().buildJavaElementFactoryMethod(this, resourceMethod);
    }

    private Iterable<JavaResourceMethod> getResourceElementFactoryMethods() {
        return new FilteringIterable<JavaResourceMethod>(this.getJavaResourceType().getMethods()){

            protected boolean accept(JavaResourceMethod method) {
                return GenericJavaRegistry.methodIsElementFactoryMethod(method);
            }
        };
    }

    protected static boolean methodIsElementFactoryMethod(JavaResourceMethod method) {
        return GenericJavaRegistry.methodHasXmlElementDeclAnnotation(method);
    }

    protected static boolean methodHasXmlElementDeclAnnotation(JavaResourceMethod method) {
        return method.getAnnotation("javax.xml.bind.annotation.XmlElementDecl") != null;
    }

    protected static boolean methodStartsWithCreate(JavaResourceMethod method) {
        return method.getName().startsWith(ELEMENT_FACTORY_METHOD_CREATE_PREFIX);
    }

    protected static boolean methodReturnTypeIsJAXBElement(JavaResourceMethod method) {
        return method.typeIsSubTypeOf(JAXB_ELEMENT_TYPE_NAME);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getAnnotation().getTextRange(astRoot);
        return textRange != null ? textRange : super.getValidationTextRange(astRoot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ElementFactoryMethodContainer
    extends AbstractJaxbNode.ContextCollectionContainer<JaxbElementFactoryMethod, JavaResourceMethod> {
        protected ElementFactoryMethodContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "elementFactoryMethods";
        }

        @Override
        protected JaxbElementFactoryMethod buildContextElement(JavaResourceMethod resourceElement) {
            return GenericJavaRegistry.this.buildElementFactoryMethod(resourceElement);
        }

        @Override
        protected Iterable<JavaResourceMethod> getResourceElements() {
            return GenericJavaRegistry.this.getResourceElementFactoryMethods();
        }

        @Override
        protected JavaResourceMethod getResourceElement(JaxbElementFactoryMethod contextElement) {
            return contextElement.getResourceMethod();
        }
    }
}

