/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.XmlNs;
import org.eclipse.jpt.jaxb.core.context.XmlNsForm;
import org.eclipse.jpt.jaxb.core.context.XmlSchema;
import org.eclipse.jpt.jaxb.core.internal.AbstractJaxbNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.jaxb.core.resource.java.XmlNsAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSchemaAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlSchema
extends AbstractJavaContextNode
implements XmlSchema {
    protected String specifiedNamespace = this.getResourceNamespace();
    protected String location = this.getResourceLocation();
    protected XmlNsForm specifiedAttributeFormDefault = this.getResourceAttributeFormDefault();
    protected XmlNsForm specifiedElementFormDefault = this.getResourceElementFormDefault();
    protected final XmlNsPrefixContainer xmlNsPrefixContainer = new XmlNsPrefixContainer();

    public GenericJavaXmlSchema(JaxbPackageInfo parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedNamespace_(this.getResourceNamespace());
        this.setLocation_(this.getResourceLocation());
        this.setSpecifiedAttributeFormDefault_(this.getResourceAttributeFormDefault());
        this.setSpecifiedElementFormDefault_(this.getResourceElementFormDefault());
        this.syncXmlNsPrefixes();
    }

    @Override
    public void update() {
        super.update();
        this.updateXmlNsPrefixes();
    }

    @Override
    public JaxbPackageInfo getParent() {
        return (JaxbPackageInfo)super.getParent();
    }

    public JaxbPackage getJaxbPackage() {
        return this.getParent().getJaxbPackage();
    }

    protected JavaResourcePackage getResourcePackage() {
        return this.getParent().getResourcePackage();
    }

    protected XmlSchemaAnnotation getXmlSchemaAnnotation() {
        return (XmlSchemaAnnotation)this.getResourcePackage().getNonNullAnnotation("javax.xml.bind.annotation.XmlSchema");
    }

    @Override
    public String getNamespace() {
        return this.specifiedNamespace == null ? "" : this.specifiedNamespace;
    }

    @Override
    public String getSpecifiedNamespace() {
        return this.specifiedNamespace;
    }

    @Override
    public void setSpecifiedNamespace(String namespace) {
        this.getXmlSchemaAnnotation().setNamespace(namespace);
        this.setSpecifiedNamespace_(namespace);
    }

    protected void setSpecifiedNamespace_(String namespace) {
        String old = this.specifiedNamespace;
        this.specifiedNamespace = namespace;
        this.firePropertyChanged("specifiedNamespace", old, namespace);
    }

    protected String getResourceNamespace() {
        return this.getXmlSchemaAnnotation().getNamespace();
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String location) {
        this.getXmlSchemaAnnotation().setLocation(location);
        this.setLocation_(location);
    }

    protected void setLocation_(String location) {
        String old = this.location;
        this.location = location;
        this.firePropertyChanged("location", old, location);
    }

    protected String getResourceLocation() {
        return this.getXmlSchemaAnnotation().getLocation();
    }

    @Override
    public XmlNsForm getAttributeFormDefault() {
        return this.specifiedAttributeFormDefault == null ? XmlNsForm.UNSET : this.specifiedAttributeFormDefault;
    }

    @Override
    public XmlNsForm getSpecifiedAttributeFormDefault() {
        return this.specifiedAttributeFormDefault;
    }

    @Override
    public void setSpecifiedAttributeFormDefault(XmlNsForm attributeFormDefault) {
        this.getXmlSchemaAnnotation().setAttributeFormDefault(XmlNsForm.toJavaResourceModel(attributeFormDefault));
        this.setSpecifiedAttributeFormDefault_(attributeFormDefault);
    }

    protected void setSpecifiedAttributeFormDefault_(XmlNsForm attributeFormDefault) {
        XmlNsForm old = this.specifiedAttributeFormDefault;
        this.specifiedAttributeFormDefault = attributeFormDefault;
        this.firePropertyChanged("attributeFormDefault", (Object)old, (Object)attributeFormDefault);
    }

    protected XmlNsForm getResourceAttributeFormDefault() {
        return XmlNsForm.fromJavaResourceModel(this.getXmlSchemaAnnotation().getAttributeFormDefault());
    }

    @Override
    public XmlNsForm getElementFormDefault() {
        return this.specifiedElementFormDefault == null ? XmlNsForm.UNSET : this.specifiedElementFormDefault;
    }

    @Override
    public XmlNsForm getSpecifiedElementFormDefault() {
        return this.specifiedElementFormDefault;
    }

    @Override
    public void setSpecifiedElementFormDefault(XmlNsForm elementFormDefault) {
        this.getXmlSchemaAnnotation().setElementFormDefault(XmlNsForm.toJavaResourceModel(elementFormDefault));
        this.setSpecifiedElementFormDefault_(elementFormDefault);
    }

    protected void setSpecifiedElementFormDefault_(XmlNsForm elementFormDefault) {
        XmlNsForm old = this.specifiedElementFormDefault;
        this.specifiedElementFormDefault = elementFormDefault;
        this.firePropertyChanged("elementFormDefault", (Object)old, (Object)elementFormDefault);
    }

    protected XmlNsForm getResourceElementFormDefault() {
        return XmlNsForm.fromJavaResourceModel(this.getXmlSchemaAnnotation().getElementFormDefault());
    }

    @Override
    public ListIterable<XmlNs> getXmlNsPrefixes() {
        return this.xmlNsPrefixContainer.getContextElements();
    }

    @Override
    public int getXmlNsPrefixesSize() {
        return this.xmlNsPrefixContainer.getContextElementsSize();
    }

    @Override
    public XmlNs addXmlNsPrefix(int index) {
        XmlNsAnnotation annotation = this.getXmlSchemaAnnotation().addXmlns(index);
        return (XmlNs)this.xmlNsPrefixContainer.addContextElement(index, annotation);
    }

    @Override
    public void removeXmlNsPrefix(XmlNs xmlNsPrefix) {
        this.removeXmlNsPrefix(this.xmlNsPrefixContainer.indexOfContextElement(xmlNsPrefix));
    }

    @Override
    public void removeXmlNsPrefix(int index) {
        this.getXmlSchemaAnnotation().removeXmlns(index);
        this.xmlNsPrefixContainer.removeContextElement(index);
    }

    @Override
    public void moveXmlNsPrefix(int targetIndex, int sourceIndex) {
        this.getXmlSchemaAnnotation().moveXmlns(targetIndex, sourceIndex);
        this.xmlNsPrefixContainer.moveContextElement(targetIndex, sourceIndex);
    }

    protected XmlNs buildXmlNs(XmlNsAnnotation xmlNsAnnotation) {
        return this.getFactory().buildJavaXmlNs(this, xmlNsAnnotation);
    }

    protected void syncXmlNsPrefixes() {
        this.xmlNsPrefixContainer.synchronizeWithResourceModel();
    }

    protected void updateXmlNsPrefixes() {
        this.xmlNsPrefixContainer.update();
    }

    protected ListIterable<XmlNsAnnotation> getXmlNsAnnotations() {
        return this.getXmlSchemaAnnotation().getXmlns();
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        if (this.namespaceTouches(pos, astRoot)) {
            return this.getNamespaceProposals(filter);
        }
        return EmptyIterable.instance();
    }

    protected boolean namespaceTouches(int pos, CompilationUnit astRoot) {
        return this.getXmlSchemaAnnotation().namespaceTouches(pos, astRoot);
    }

    protected Iterable<String> getNamespaceProposals(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals((Iterable)new FilteringIterable(this.getJaxbProject().getSchemaLibrary().getSchemaLocations().keySet(), filter));
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getXmlSchemaAnnotation().getTextRange(astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        XsdSchema schema = this.getJaxbPackage().getXsdSchema();
        if (schema != null) {
            if (this.formConflicts(this.getAttributeFormDefault(), ((XSDSchema)schema.getXSDComponent()).getAttributeFormDefault())) {
                messages.add(DefaultValidationMessages.buildMessage(1, "XML_SCHEMA__MISMATCHED_ATTRIBUTE_FORM_DEFAULT", this, this.getXmlSchemaAnnotation().getAttributeFormDefaultTextRange(astRoot)));
            }
            if (this.formConflicts(this.getElementFormDefault(), ((XSDSchema)schema.getXSDComponent()).getElementFormDefault())) {
                messages.add(DefaultValidationMessages.buildMessage(1, "XML_SCHEMA__MISMATCHED_ELEMENT_FORM_DEFAULT", this, this.getXmlSchemaAnnotation().getElementFormDefaultTextRange(astRoot)));
            }
        }
    }

    protected boolean formConflicts(XmlNsForm form, XSDForm xsdForm) {
        return form == XmlNsForm.QUALIFIED ^ xsdForm == XSDForm.QUALIFIED_LITERAL;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlNsPrefixContainer
    extends AbstractJaxbNode.ContextListContainer<XmlNs, XmlNsAnnotation> {
        protected XmlNsPrefixContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "xmlNsPrefixes";
        }

        @Override
        protected XmlNs buildContextElement(XmlNsAnnotation resourceElement) {
            return GenericJavaXmlSchema.this.buildXmlNs(resourceElement);
        }

        @Override
        protected ListIterable<XmlNsAnnotation> getResourceElements() {
            return GenericJavaXmlSchema.this.getXmlNsAnnotations();
        }

        @Override
        protected XmlNsAnnotation getResourceElement(XmlNs contextElement) {
            return contextElement.getResourceXmlNs();
        }
    }
}

