/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Attribute;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.jaxb.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceXmlElementAnnotation
extends SourceAnnotation<Attribute>
implements XmlElementAnnotation {
    private static final SimpleDeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.xml.bind.annotation.XmlElement");
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    private final AnnotationElementAdapter<String> nameAdapter;
    private String name;
    private final DeclarationAnnotationElementAdapter<String> namespaceDeclarationAdapter;
    private final AnnotationElementAdapter<String> namespaceAdapter;
    private String namespace;
    private final DeclarationAnnotationElementAdapter<Boolean> nillableDeclarationAdapter;
    private final AnnotationElementAdapter<Boolean> nillableAdapter;
    private Boolean nillable;
    private final DeclarationAnnotationElementAdapter<Boolean> requiredDeclarationAdapter;
    private final AnnotationElementAdapter<Boolean> requiredAdapter;
    private Boolean required;
    private final DeclarationAnnotationElementAdapter<String> defaultValueDeclarationAdapter;
    private final AnnotationElementAdapter<String> defaultValueAdapter;
    private String defaultValue;
    private final DeclarationAnnotationElementAdapter<String> typeDeclarationAdapter;
    private final AnnotationElementAdapter<String> typeAdapter;
    private String type;
    private String fullyQualifiedTypeName;

    public static SourceXmlElementAnnotation buildSourceXmlElementAnnotation(JavaResourceAttribute parent, Attribute attribute) {
        return new SourceXmlElementAnnotation((JavaResourceNode)parent, attribute, (DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER);
    }

    public static SourceXmlElementAnnotation buildNestedSourceXmlElementAnnotation(JavaResourceNode parent, Attribute attribute, IndexedDeclarationAnnotationAdapter idaa) {
        return new SourceXmlElementAnnotation(parent, attribute, idaa);
    }

    private SourceXmlElementAnnotation(JavaResourceNode parent, Attribute attribute, DeclarationAnnotationAdapter daa) {
        this(parent, attribute, daa, (AnnotationAdapter)new ElementAnnotationAdapter((AnnotatedElement)attribute, daa));
    }

    private SourceXmlElementAnnotation(JavaResourceNode parent, Attribute attribute, IndexedDeclarationAnnotationAdapter idaa) {
        this(parent, attribute, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new ElementIndexedAnnotationAdapter((AnnotatedElement)attribute, idaa));
    }

    private SourceXmlElementAnnotation(JavaResourceNode parent, Attribute attribute, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, attribute, daa, annotationAdapter);
        this.nameDeclarationAdapter = this.buildNameAdapter(daa);
        this.nameAdapter = this.buildAnnotationElementAdapter(this.nameDeclarationAdapter);
        this.namespaceDeclarationAdapter = this.buildNamespaceAdapter(daa);
        this.namespaceAdapter = this.buildAnnotationElementAdapter(this.namespaceDeclarationAdapter);
        this.nillableDeclarationAdapter = this.buildNillableAdapter(daa);
        this.nillableAdapter = this.buildShortCircuitBooleanElementAdapter(this.nillableDeclarationAdapter);
        this.requiredDeclarationAdapter = this.buildRequiredAdapter(daa);
        this.requiredAdapter = this.buildShortCircuitBooleanElementAdapter(this.requiredDeclarationAdapter);
        this.defaultValueDeclarationAdapter = this.buildDefaultValueAdapter(daa);
        this.defaultValueAdapter = this.buildAnnotationElementAdapter(this.defaultValueDeclarationAdapter);
        this.typeDeclarationAdapter = this.buildTypeAdapter(daa);
        this.typeAdapter = this.buildAnnotationElementAdapter(this.typeDeclarationAdapter);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"name");
    }

    private DeclarationAnnotationElementAdapter<String> buildNamespaceAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"namespace");
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildNillableAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daa, (String)"nillable");
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildRequiredAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daa, (String)"required");
    }

    private DeclarationAnnotationElementAdapter<String> buildDefaultValueAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"defaultValue");
    }

    private DeclarationAnnotationElementAdapter<String> buildTypeAdapter(DeclarationAnnotationAdapter daa) {
        return SourceXmlElementAnnotation.buildAnnotationElementAdapter(daa, "type", (ExpressionConverter<String>)SimpleTypeStringExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }

    private AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    private AnnotationElementAdapter<Boolean> buildShortCircuitBooleanElementAdapter(DeclarationAnnotationElementAdapter<Boolean> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    @Override
    public String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlElement";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.namespace = this.buildNamespace(astRoot);
        this.nillable = this.buildNillable(astRoot);
        this.required = this.buildRequired(astRoot);
        this.defaultValue = this.buildDefaultValue(astRoot);
        this.type = this.buildType(astRoot);
        this.fullyQualifiedTypeName = this.buildFullyQualifiedTypeName(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncName(this.buildName(astRoot));
        this.syncNamespace(this.buildNamespace(astRoot));
        this.syncNillable(this.buildNillable(astRoot));
        this.syncRequired(this.buildRequired(astRoot));
        this.syncDefaultValue(this.buildDefaultValue(astRoot));
        this.syncType(this.buildType(astRoot));
        this.syncFullyQualifiedTypeName(this.buildFullyQualifiedTypeName(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasChanged(this.name, name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    @Override
    public boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.nameDeclarationAdapter, pos, astRoot);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        if (this.attributeValueHasChanged(this.namespace, namespace)) {
            this.namespace = namespace;
            this.namespaceAdapter.setValue((Object)namespace);
        }
    }

    private void syncNamespace(String astNamespace) {
        String old = this.namespace;
        this.namespace = astNamespace;
        this.firePropertyChanged("namespace", old, astNamespace);
    }

    private String buildNamespace(CompilationUnit astRoot) {
        return (String)this.namespaceAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNamespaceTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.namespaceDeclarationAdapter, astRoot);
    }

    @Override
    public boolean namespaceTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.namespaceDeclarationAdapter, pos, astRoot);
    }

    @Override
    public Boolean getNillable() {
        return this.nillable;
    }

    @Override
    public void setNillable(Boolean nillable) {
        if (this.attributeValueHasChanged(this.nillable, nillable)) {
            this.nillable = nillable;
            this.nillableAdapter.setValue((Object)nillable);
        }
    }

    private void syncNillable(Boolean astNillable) {
        Boolean old = this.nillable;
        this.nillable = astNillable;
        this.firePropertyChanged("nillable", old, astNillable);
    }

    private Boolean buildNillable(CompilationUnit astRoot) {
        return (Boolean)this.nillableAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNillableTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nillableDeclarationAdapter, astRoot);
    }

    @Override
    public Boolean getRequired() {
        return this.required;
    }

    @Override
    public void setRequired(Boolean required) {
        if (this.attributeValueHasChanged(this.required, required)) {
            this.required = required;
            this.requiredAdapter.setValue((Object)required);
        }
    }

    private void syncRequired(Boolean astRequired) {
        Boolean old = this.required;
        this.required = astRequired;
        this.firePropertyChanged("required", old, astRequired);
    }

    private Boolean buildRequired(CompilationUnit astRoot) {
        return (Boolean)this.requiredAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getRequiredTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.requiredDeclarationAdapter, astRoot);
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        if (this.attributeValueHasChanged(this.defaultValue, defaultValue)) {
            this.defaultValue = defaultValue;
            this.defaultValueAdapter.setValue((Object)defaultValue);
        }
    }

    private void syncDefaultValue(String astDefaultValue) {
        String old = this.defaultValue;
        this.defaultValue = astDefaultValue;
        this.firePropertyChanged("defaultValue", old, astDefaultValue);
    }

    private String buildDefaultValue(CompilationUnit astRoot) {
        return (String)this.defaultValueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getDefaultValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.defaultValueDeclarationAdapter, astRoot);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        if (this.attributeValueHasChanged(this.type, type)) {
            this.type = type;
            this.typeAdapter.setValue((Object)type);
        }
    }

    private void syncType(String astType) {
        String old = this.type;
        this.type = astType;
        this.firePropertyChanged("type", old, astType);
    }

    private String buildType(CompilationUnit astRoot) {
        return (String)this.typeAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getTypeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.typeDeclarationAdapter, astRoot);
    }

    @Override
    public String getFullyQualifiedTypeName() {
        return this.fullyQualifiedTypeName;
    }

    private void syncFullyQualifiedTypeName(String name) {
        String old = this.fullyQualifiedTypeName;
        this.fullyQualifiedTypeName = name;
        this.firePropertyChanged("fullyQualifiedTypeName", old, name);
    }

    private String buildFullyQualifiedTypeName(CompilationUnit astRoot) {
        return this.type == null ? null : ASTTools.resolveFullyQualifiedName((Expression)this.typeAdapter.getExpression(astRoot));
    }

    @Override
    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    private IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }
}

