/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.internal.context.core.IInteractionContextReader;
import org.eclipse.mylyn.internal.context.core.IInteractionContextWriter;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.SaxContextReader;
import org.eclipse.mylyn.internal.context.core.SaxContextWriter;

public class InteractionContextExternalizer {
    public static final String ELMNT_INTERACTION_HISTORY_OLD = "interactionEvent";
    public static final String ELMNT_INTERACTION_HISTORY = "InteractionHistory";
    public static final String ATR_STRUCTURE_KIND = "StructureKind";
    public static final String ATR_STRUCTURE_HANDLE = "StructureHandle";
    public static final String ATR_START_DATE = "StartDate";
    public static final String ATR_ORIGIN_ID = "OriginId";
    public static final String ATR_NAVIGATION = "Navigation";
    public static final String ATR_KIND = "Kind";
    public static final String ATR_INTEREST = "Interest";
    public static final String ATR_NUM_EVENTS = "NumEvents";
    public static final String ATR_CREATION_COUNT = "CreationCount";
    public static final String ATR_DELTA = "Delta";
    public static final String ATR_END_DATE = "EndDate";
    public static final String ATR_ID = "Id";
    public static final String ATR_VERSION = "Version";
    static final String DATE_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss.S z";

    /*
     * Exception decompiling
     */
    static String getFirstContextHandle(File sourceFile) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void writeContextToXml(IInteractionContext context, File file) throws IOException {
        this.writeContextToXml(context, file, new SaxContextWriter());
    }

    public void writeContextToXml(IInteractionContext context, File file, IInteractionContextWriter writer) throws IOException {
        if (context.getInteractionHistory().isEmpty()) {
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            ZipOutputStream outputStream = new ZipOutputStream(fileOutputStream);
            try {
                this.writeContext(context, outputStream, writer);
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileOutputStream.close();
        }
    }

    public void writeContext(IInteractionContext context, ZipOutputStream outputStream) throws IOException {
        this.writeContext(context, outputStream, new SaxContextWriter());
    }

    public void writeContext(IInteractionContext context, ZipOutputStream outputStream, IInteractionContextWriter writer) throws IOException {
        String handleIdentifier = context.getHandleIdentifier();
        String encoded = URLEncoder.encode(handleIdentifier, "UTF-8");
        ZipEntry zipEntry = new ZipEntry(String.valueOf(encoded) + ".xml");
        outputStream.putNextEntry(zipEntry);
        outputStream.setMethod(8);
        writer.setOutputStream(outputStream);
        writer.writeContextToStream(context);
        outputStream.flush();
        outputStream.closeEntry();
    }

    public IInteractionContext readContextFromXml(String handleIdentifier, File fromFile, IInteractionContextScaling scaling) {
        return this.readContextFromXml(handleIdentifier, fromFile, new SaxContextReader(), scaling);
    }

    public IInteractionContext readContextFromXml(String handleIdentifier, File fromFile, IInteractionContextReader reader, IInteractionContextScaling scaling) {
        String firstHandle;
        InteractionContext context;
        block5: {
            try {
                if (fromFile.exists()) break block5;
                return null;
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.core", "Could not read: " + fromFile.getAbsolutePath(), (Throwable)e));
                return null;
            }
        }
        if (reader instanceof SaxContextReader) {
            ((SaxContextReader)reader).setContextScaling(scaling);
        }
        if ((context = reader.readContext(handleIdentifier, fromFile)) == null && (firstHandle = InteractionContextExternalizer.getFirstContextHandle(fromFile)) != null && !firstHandle.equals(handleIdentifier) && (context = reader.readContext(firstHandle, fromFile)) != null) {
            context.setHandleIdentifier(handleIdentifier);
        }
        return context;
    }
}

